/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import org.opendaylight.controller.cluster.datastore.ShardDataTreeChangeListenerPublisher;
import org.opendaylight.mdsal.dom.api.DOMDataTreeChangeListener;
import org.opendaylight.mdsal.dom.spi.store.AbstractDOMStoreTreeChangePublisher;
import org.opendaylight.yangtools.concepts.Registration;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeCandidate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DefaultShardDataTreeChangeListenerPublisher
extends AbstractDOMStoreTreeChangePublisher
implements ShardDataTreeChangeListenerPublisher {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultShardDataTreeChangeListenerPublisher.class);
    private String logContext;

    DefaultShardDataTreeChangeListenerPublisher(String logContext) {
        this.logContext = logContext;
    }

    @Override
    public void publishChanges(DataTreeCandidate candidate) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("{}: publishChanges: {}", (Object)this.logContext, (Object)candidate);
        } else {
            LOG.debug("{}: publishChanges: rootPath: {}", (Object)this.logContext, (Object)candidate.getRootPath());
        }
        this.processCandidateTree(candidate);
    }

    protected void notifyListener(AbstractDOMStoreTreeChangePublisher.Reg registration, List<DataTreeCandidate> changes) {
        DOMDataTreeChangeListener listener = registration.listener();
        LOG.debug("{}: notifyListener: listener: {}", (Object)this.logContext, (Object)listener);
        listener.onDataTreeChanged(changes);
    }

    protected void registrationRemoved(AbstractDOMStoreTreeChangePublisher.Reg registration) {
        LOG.debug("Registration {} removed", (Object)registration);
    }

    @Override
    public void registerTreeChangeListener(YangInstanceIdentifier treeId, DOMDataTreeChangeListener listener, Optional<DataTreeCandidate> initialState, Consumer<Registration> onRegistration) {
        this.registerTreeChangeListener(treeId, listener, onRegistration);
        if (initialState.isPresent()) {
            DefaultShardDataTreeChangeListenerPublisher.notifySingleListener(treeId, listener, initialState.orElseThrow(), this.logContext);
        } else {
            listener.onInitialData();
        }
    }

    void registerTreeChangeListener(YangInstanceIdentifier treeId, DOMDataTreeChangeListener listener, Consumer<Registration> onRegistration) {
        LOG.debug("{}: registerTreeChangeListener: path: {}, listener: {}", new Object[]{this.logContext, treeId, listener});
        onRegistration.accept(super.registerTreeChangeListener(treeId, listener));
    }

    static void notifySingleListener(YangInstanceIdentifier treeId, DOMDataTreeChangeListener listener, DataTreeCandidate state, String logContext) {
        LOG.debug("{}: notifySingleListener: path: {}, listener: {}", new Object[]{logContext, treeId, listener});
        DefaultShardDataTreeChangeListenerPublisher publisher = new DefaultShardDataTreeChangeListenerPublisher(logContext);
        publisher.logContext = logContext;
        publisher.registerTreeChangeListener(treeId, listener);
        if (!publisher.processCandidateTree(state)) {
            listener.onInitialData();
        }
    }
}

