/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import com.google.common.base.Preconditions;
import com.google.common.primitives.UnsignedLong;
import com.google.common.util.concurrent.FutureCallback;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.controller.cluster.access.commands.AbortLocalTransactionRequest;
import org.opendaylight.controller.cluster.access.commands.CommitLocalTransactionRequest;
import org.opendaylight.controller.cluster.access.commands.ExistsTransactionRequest;
import org.opendaylight.controller.cluster.access.commands.ExistsTransactionSuccess;
import org.opendaylight.controller.cluster.access.commands.ModifyTransactionRequest;
import org.opendaylight.controller.cluster.access.commands.ModifyTransactionSuccess;
import org.opendaylight.controller.cluster.access.commands.PersistenceProtocol;
import org.opendaylight.controller.cluster.access.commands.ReadTransactionRequest;
import org.opendaylight.controller.cluster.access.commands.ReadTransactionSuccess;
import org.opendaylight.controller.cluster.access.commands.TransactionAbortRequest;
import org.opendaylight.controller.cluster.access.commands.TransactionAbortSuccess;
import org.opendaylight.controller.cluster.access.commands.TransactionCanCommitSuccess;
import org.opendaylight.controller.cluster.access.commands.TransactionCommitSuccess;
import org.opendaylight.controller.cluster.access.commands.TransactionDelete;
import org.opendaylight.controller.cluster.access.commands.TransactionDoCommitRequest;
import org.opendaylight.controller.cluster.access.commands.TransactionMerge;
import org.opendaylight.controller.cluster.access.commands.TransactionModification;
import org.opendaylight.controller.cluster.access.commands.TransactionPreCommitRequest;
import org.opendaylight.controller.cluster.access.commands.TransactionPreCommitSuccess;
import org.opendaylight.controller.cluster.access.commands.TransactionRequest;
import org.opendaylight.controller.cluster.access.commands.TransactionSuccess;
import org.opendaylight.controller.cluster.access.commands.TransactionWrite;
import org.opendaylight.controller.cluster.access.concepts.Request;
import org.opendaylight.controller.cluster.access.concepts.RequestEnvelope;
import org.opendaylight.controller.cluster.access.concepts.RequestException;
import org.opendaylight.controller.cluster.access.concepts.RuntimeRequestException;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;
import org.opendaylight.controller.cluster.access.concepts.UnsupportedRequestException;
import org.opendaylight.controller.cluster.datastore.AbstractFrontendHistory;
import org.opendaylight.controller.cluster.datastore.FrontendTransaction;
import org.opendaylight.controller.cluster.datastore.ReadWriteShardDataTreeTransaction;
import org.opendaylight.controller.cluster.datastore.ShardDataTreeCohort;
import org.opendaylight.yangtools.yang.common.Empty;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeCandidate;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeModification;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class FrontendReadWriteTransaction
extends FrontendTransaction {
    private static final Logger LOG = LoggerFactory.getLogger(FrontendReadWriteTransaction.class);
    private static final State ABORTED = new State(){

        @Override
        public String toString() {
            return "ABORTED";
        }
    };
    private static final State ABORTING = new State(){

        @Override
        public String toString() {
            return "ABORTING";
        }
    };
    private static final State COMMITTED = new State(){

        @Override
        public String toString() {
            return "COMMITTED";
        }
    };
    private State state;

    private FrontendReadWriteTransaction(AbstractFrontendHistory history, TransactionIdentifier id, ReadWriteShardDataTreeTransaction transaction) {
        super(history, id);
        this.state = new Open(transaction);
    }

    private FrontendReadWriteTransaction(AbstractFrontendHistory history, TransactionIdentifier id, DataTreeModification mod) {
        super(history, id);
        this.state = new Sealed(mod);
    }

    static FrontendReadWriteTransaction createOpen(AbstractFrontendHistory history, ReadWriteShardDataTreeTransaction transaction) {
        return new FrontendReadWriteTransaction(history, transaction.getIdentifier(), transaction);
    }

    static FrontendReadWriteTransaction createReady(AbstractFrontendHistory history, TransactionIdentifier id, DataTreeModification mod) {
        return new FrontendReadWriteTransaction(history, id, mod);
    }

    @Override
    TransactionSuccess<?> doHandleRequest(TransactionRequest<?> request, RequestEnvelope envelope, long now) throws RequestException {
        if (request instanceof ModifyTransactionRequest) {
            ModifyTransactionRequest modifyRequest = (ModifyTransactionRequest)request;
            return this.handleModifyTransaction(modifyRequest, envelope, now);
        }
        if (request instanceof CommitLocalTransactionRequest) {
            CommitLocalTransactionRequest commitLocalRequest = (CommitLocalTransactionRequest)request;
            this.handleCommitLocalTransaction(commitLocalRequest, envelope, now);
            return null;
        }
        if (request instanceof ExistsTransactionRequest) {
            ExistsTransactionRequest existsRequest = (ExistsTransactionRequest)request;
            return this.handleExistsTransaction(existsRequest);
        }
        if (request instanceof ReadTransactionRequest) {
            ReadTransactionRequest readRequest = (ReadTransactionRequest)request;
            return this.handleReadTransaction(readRequest);
        }
        if (request instanceof TransactionPreCommitRequest) {
            TransactionPreCommitRequest preCommitRequest = (TransactionPreCommitRequest)request;
            this.handleTransactionPreCommit(preCommitRequest, envelope, now);
            return null;
        }
        if (request instanceof TransactionDoCommitRequest) {
            TransactionDoCommitRequest doCommitRequest = (TransactionDoCommitRequest)request;
            this.handleTransactionDoCommit(doCommitRequest, envelope, now);
            return null;
        }
        if (request instanceof TransactionAbortRequest) {
            return this.handleTransactionAbort(request.getSequence(), envelope, now);
        }
        if (request instanceof AbortLocalTransactionRequest) {
            this.handleLocalTransactionAbort(request.getSequence(), envelope, now);
            return null;
        }
        LOG.warn("Rejecting unsupported request {}", request);
        throw new UnsupportedRequestException(request);
    }

    @Override
    void retire() {
        this.state = new Retired(this.state);
    }

    private void handleTransactionPreCommit(TransactionPreCommitRequest request, final RequestEnvelope envelope, final long now) throws RequestException {
        this.throwIfFailed();
        Ready ready = this.checkReady();
        switch (ready.stage.ordinal()) {
            case 3: {
                LOG.debug("{}: Transaction {} is already preCommitting", (Object)this.persistenceId(), (Object)this.getIdentifier());
                break;
            }
            case 2: {
                ready.stage = CommitStage.PRE_COMMIT_PENDING;
                LOG.debug("{}: Transaction {} initiating preCommit", (Object)this.persistenceId(), (Object)this.getIdentifier());
                ready.readyCohort.preCommit(new FutureCallback<DataTreeCandidate>(){

                    public void onSuccess(DataTreeCandidate result) {
                        FrontendReadWriteTransaction.this.successfulPreCommit(envelope, now);
                    }

                    public void onFailure(Throwable failure) {
                        FrontendReadWriteTransaction.this.failTransaction(envelope, now, new RuntimeRequestException("Precommit failed", failure));
                    }
                });
                break;
            }
            case 0: 
            case 1: 
            case 4: 
            case 5: {
                throw new IllegalStateException("Attempted to preCommit in stage " + String.valueOf((Object)ready.stage));
            }
            default: {
                FrontendReadWriteTransaction.throwUnhandledCommitStage(ready);
            }
        }
    }

    void successfulPreCommit(RequestEnvelope envelope, long startTime) {
        if (this.state instanceof Retired) {
            LOG.debug("{}: Suppressing successful preCommit of retired transaction {}", (Object)this.persistenceId(), (Object)this.getIdentifier());
            return;
        }
        Ready ready = this.checkReady();
        LOG.debug("{}: Transaction {} completed preCommit", (Object)this.persistenceId(), (Object)this.getIdentifier());
        this.recordAndSendSuccess(envelope, startTime, (TransactionSuccess<?>)new TransactionPreCommitSuccess(this.getIdentifier(), ((Request)envelope.getMessage()).getSequence()));
        ready.stage = CommitStage.PRE_COMMIT_COMPLETE;
    }

    void failTransaction(RequestEnvelope envelope, long now, RuntimeRequestException cause) {
        if (this.state instanceof Retired) {
            LOG.debug("{}: Suppressing failure of retired transaction {}", new Object[]{this.persistenceId(), this.getIdentifier(), cause});
            return;
        }
        this.recordAndSendFailure(envelope, now, cause);
        this.state = new Failed((RequestException)cause);
        LOG.debug("{}: Transaction {} failed", new Object[]{this.persistenceId(), this.getIdentifier(), cause});
    }

    private void handleTransactionDoCommit(TransactionDoCommitRequest request, final RequestEnvelope envelope, final long now) throws RequestException {
        this.throwIfFailed();
        Ready ready = this.checkReady();
        switch (ready.stage.ordinal()) {
            case 5: {
                LOG.debug("{}: Transaction {} is already committing", (Object)this.persistenceId(), (Object)this.getIdentifier());
                break;
            }
            case 4: {
                ready.stage = CommitStage.COMMIT_PENDING;
                LOG.debug("{}: Transaction {} initiating commit", (Object)this.persistenceId(), (Object)this.getIdentifier());
                ready.readyCohort.commit(new FutureCallback<UnsignedLong>(){

                    public void onSuccess(UnsignedLong result) {
                        FrontendReadWriteTransaction.this.successfulCommit(envelope, now);
                    }

                    public void onFailure(Throwable failure) {
                        FrontendReadWriteTransaction.this.failTransaction(envelope, now, new RuntimeRequestException("Commit failed", failure));
                    }
                });
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                throw new IllegalStateException("Attempted to doCommit in stage " + String.valueOf((Object)ready.stage));
            }
            default: {
                FrontendReadWriteTransaction.throwUnhandledCommitStage(ready);
            }
        }
    }

    private void handleLocalTransactionAbort(long sequence, RequestEnvelope envelope, long now) {
        this.checkOpen().abort(() -> this.recordAndSendSuccess(envelope, now, (TransactionSuccess<?>)new TransactionAbortSuccess(this.getIdentifier(), sequence)));
    }

    private void startAbort() {
        this.state = ABORTING;
        LOG.debug("{}: Transaction {} aborting", (Object)this.persistenceId(), (Object)this.getIdentifier());
    }

    private void finishAbort() {
        this.state = ABORTED;
        LOG.debug("{}: Transaction {} aborted", (Object)this.persistenceId(), (Object)this.getIdentifier());
    }

    private TransactionAbortSuccess handleTransactionAbort(final long sequence, final RequestEnvelope envelope, final long now) {
        if (this.state instanceof Open) {
            ReadWriteShardDataTreeTransaction openTransaction = this.checkOpen();
            this.startAbort();
            openTransaction.abort(() -> {
                this.recordAndSendSuccess(envelope, now, (TransactionSuccess<?>)new TransactionAbortSuccess(this.getIdentifier(), sequence));
                this.finishAbort();
            });
            return null;
        }
        if (ABORTING.equals(this.state)) {
            LOG.debug("{}: Transaction {} already aborting", (Object)this.persistenceId(), (Object)this.getIdentifier());
            return null;
        }
        if (ABORTED.equals(this.state)) {
            LOG.warn("{}: Transaction {} already aborted", (Object)this.persistenceId(), (Object)this.getIdentifier());
            return new TransactionAbortSuccess(this.getIdentifier(), sequence);
        }
        Ready ready = this.checkReady();
        this.startAbort();
        ready.readyCohort.abort(new FutureCallback<Empty>(){

            public void onSuccess(Empty result) {
                FrontendReadWriteTransaction.this.recordAndSendSuccess(envelope, now, (TransactionSuccess<?>)new TransactionAbortSuccess(FrontendReadWriteTransaction.this.getIdentifier(), sequence));
                FrontendReadWriteTransaction.this.finishAbort();
            }

            public void onFailure(Throwable failure) {
                FrontendReadWriteTransaction.this.recordAndSendFailure(envelope, now, new RuntimeRequestException("Abort failed", failure));
                LOG.warn("{}: Transaction {} abort failed", new Object[]{FrontendReadWriteTransaction.this.persistenceId(), FrontendReadWriteTransaction.this.getIdentifier(), failure});
                FrontendReadWriteTransaction.this.finishAbort();
            }
        });
        return null;
    }

    private void coordinatedCommit(final RequestEnvelope envelope, final long now) throws RequestException {
        this.throwIfFailed();
        Ready ready = this.checkReady();
        switch (ready.stage.ordinal()) {
            case 1: {
                LOG.debug("{}: Transaction {} is already canCommitting", (Object)this.persistenceId(), (Object)this.getIdentifier());
                break;
            }
            case 0: {
                ready.stage = CommitStage.CAN_COMMIT_PENDING;
                LOG.debug("{}: Transaction {} initiating canCommit", (Object)this.persistenceId(), (Object)this.getIdentifier());
                this.checkReady().readyCohort.canCommit(new FutureCallback<Empty>(){

                    public void onSuccess(Empty result) {
                        FrontendReadWriteTransaction.this.successfulCanCommit(envelope, now);
                    }

                    public void onFailure(Throwable failure) {
                        FrontendReadWriteTransaction.this.failTransaction(envelope, now, new RuntimeRequestException("CanCommit failed", failure));
                    }
                });
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                throw new IllegalStateException("Attempted to canCommit in stage " + String.valueOf((Object)ready.stage));
            }
            default: {
                FrontendReadWriteTransaction.throwUnhandledCommitStage(ready);
            }
        }
    }

    void successfulCanCommit(RequestEnvelope envelope, long startTime) {
        if (this.state instanceof Retired) {
            LOG.debug("{}: Suppressing successful canCommit of retired transaction {}", (Object)this.persistenceId(), (Object)this.getIdentifier());
            return;
        }
        Ready ready = this.checkReady();
        this.recordAndSendSuccess(envelope, startTime, (TransactionSuccess<?>)new TransactionCanCommitSuccess(this.getIdentifier(), ((Request)envelope.getMessage()).getSequence()));
        ready.stage = CommitStage.CAN_COMMIT_COMPLETE;
        LOG.debug("{}: Transaction {} completed canCommit", (Object)this.persistenceId(), (Object)this.getIdentifier());
    }

    private void directCommit(final RequestEnvelope envelope, final long now) throws RequestException {
        this.throwIfFailed();
        Ready ready = this.checkReady();
        switch (ready.stage.ordinal()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                LOG.debug("{}: Transaction {} in state {}, not initiating direct commit for {}", new Object[]{this.persistenceId(), this.getIdentifier(), this.state, envelope});
                break;
            }
            case 0: {
                ready.stage = CommitStage.CAN_COMMIT_PENDING;
                LOG.debug("{}: Transaction {} initiating direct canCommit", (Object)this.persistenceId(), (Object)this.getIdentifier());
                ready.readyCohort.canCommit(new FutureCallback<Empty>(){

                    public void onSuccess(Empty result) {
                        FrontendReadWriteTransaction.this.successfulDirectCanCommit(envelope, now);
                    }

                    public void onFailure(Throwable failure) {
                        FrontendReadWriteTransaction.this.failTransaction(envelope, now, new RuntimeRequestException("CanCommit failed", failure));
                    }
                });
                break;
            }
            default: {
                FrontendReadWriteTransaction.throwUnhandledCommitStage(ready);
            }
        }
    }

    void successfulDirectCanCommit(final RequestEnvelope envelope, final long startTime) {
        if (this.state instanceof Retired) {
            LOG.debug("{}: Suppressing direct canCommit of retired transaction {}", (Object)this.persistenceId(), (Object)this.getIdentifier());
            return;
        }
        Ready ready = this.checkReady();
        ready.stage = CommitStage.PRE_COMMIT_PENDING;
        LOG.debug("{}: Transaction {} initiating direct preCommit", (Object)this.persistenceId(), (Object)this.getIdentifier());
        ready.readyCohort.preCommit(new FutureCallback<DataTreeCandidate>(){

            public void onSuccess(DataTreeCandidate result) {
                FrontendReadWriteTransaction.this.successfulDirectPreCommit(envelope, startTime);
            }

            public void onFailure(Throwable failure) {
                FrontendReadWriteTransaction.this.failTransaction(envelope, startTime, new RuntimeRequestException("PreCommit failed", failure));
            }
        });
    }

    void successfulDirectPreCommit(final RequestEnvelope envelope, final long startTime) {
        if (this.state instanceof Retired) {
            LOG.debug("{}: Suppressing direct commit of retired transaction {}", (Object)this.persistenceId(), (Object)this.getIdentifier());
            return;
        }
        Ready ready = this.checkReady();
        ready.stage = CommitStage.COMMIT_PENDING;
        LOG.debug("{}: Transaction {} initiating direct commit", (Object)this.persistenceId(), (Object)this.getIdentifier());
        ready.readyCohort.commit(new FutureCallback<UnsignedLong>(){

            public void onSuccess(UnsignedLong result) {
                FrontendReadWriteTransaction.this.successfulCommit(envelope, startTime);
            }

            public void onFailure(Throwable failure) {
                FrontendReadWriteTransaction.this.failTransaction(envelope, startTime, new RuntimeRequestException("DoCommit failed", failure));
            }
        });
    }

    void successfulCommit(RequestEnvelope envelope, long startTime) {
        if (this.state instanceof Retired) {
            LOG.debug("{}: Suppressing commit response on retired transaction {}", (Object)this.persistenceId(), (Object)this.getIdentifier());
            return;
        }
        this.recordAndSendSuccess(envelope, startTime, (TransactionSuccess<?>)new TransactionCommitSuccess(this.getIdentifier(), ((Request)envelope.getMessage()).getSequence()));
        this.state = COMMITTED;
    }

    private void handleCommitLocalTransaction(CommitLocalTransactionRequest request, RequestEnvelope envelope, long now) throws RequestException {
        DataTreeModification sealedModification = this.checkSealed();
        if (!sealedModification.equals((Object)request.getModification())) {
            LOG.warn("Expecting modification {}, commit request has {}", (Object)sealedModification, (Object)request.getModification());
            throw new UnsupportedRequestException((Request)request);
        }
        Optional optFailure = request.getDelayedFailure();
        this.state = optFailure.isPresent() ? new Ready(this.history().createFailedCohort(this.getIdentifier(), sealedModification, (Exception)optFailure.orElseThrow())) : new Ready(this.history().createReadyCohort(this.getIdentifier(), sealedModification, Optional.empty()));
        if (request.isCoordinated()) {
            this.coordinatedCommit(envelope, now);
        } else {
            this.directCommit(envelope, now);
        }
    }

    private ExistsTransactionSuccess handleExistsTransaction(ExistsTransactionRequest request) {
        Optional data = ((DataTreeModification)this.checkOpen().getSnapshot()).readNode(request.getPath());
        return this.recordSuccess(request.getSequence(), new ExistsTransactionSuccess(this.getIdentifier(), request.getSequence(), data.isPresent()));
    }

    private ReadTransactionSuccess handleReadTransaction(ReadTransactionRequest request) {
        Optional data = ((DataTreeModification)this.checkOpen().getSnapshot()).readNode(request.getPath());
        return this.recordSuccess(request.getSequence(), new ReadTransactionSuccess(this.getIdentifier(), request.getSequence(), data));
    }

    private ModifyTransactionSuccess replyModifySuccess(long sequence) {
        return this.recordSuccess(sequence, new ModifyTransactionSuccess(this.getIdentifier(), sequence));
    }

    private void applyModifications(Collection<TransactionModification> modifications) {
        if (!modifications.isEmpty()) {
            DataTreeModification modification = (DataTreeModification)this.checkOpen().getSnapshot();
            for (TransactionModification m : modifications) {
                if (m instanceof TransactionDelete) {
                    modification.delete(m.getPath());
                    continue;
                }
                if (m instanceof TransactionWrite) {
                    TransactionWrite write = (TransactionWrite)m;
                    modification.write(m.getPath(), write.getData());
                    continue;
                }
                if (m instanceof TransactionMerge) {
                    TransactionMerge merge = (TransactionMerge)m;
                    modification.merge(m.getPath(), merge.getData());
                    continue;
                }
                LOG.warn("{}: ignoring unhandled modification {}", (Object)this.persistenceId(), (Object)m);
            }
        }
    }

    private @Nullable TransactionSuccess<?> handleModifyTransaction(ModifyTransactionRequest request, RequestEnvelope envelope, long now) throws RequestException {
        Optional maybeProto = request.getPersistenceProtocol();
        if (!maybeProto.isPresent()) {
            this.applyModifications(request.getModifications());
            return this.replyModifySuccess(request.getSequence());
        }
        switch ((PersistenceProtocol)maybeProto.orElseThrow()) {
            case ABORT: {
                if (ABORTING.equals(this.state)) {
                    LOG.debug("{}: Transaction {} already aborting", (Object)this.persistenceId(), (Object)this.getIdentifier());
                    return null;
                }
                ReadWriteShardDataTreeTransaction openTransaction = this.checkOpen();
                this.startAbort();
                openTransaction.abort(() -> {
                    this.recordAndSendSuccess(envelope, now, (TransactionSuccess<?>)new ModifyTransactionSuccess(this.getIdentifier(), request.getSequence()));
                    this.finishAbort();
                });
                return null;
            }
            case READY: {
                this.ensureReady(request.getModifications());
                return this.replyModifySuccess(request.getSequence());
            }
            case SIMPLE: {
                this.ensureReady(request.getModifications());
                this.directCommit(envelope, now);
                return null;
            }
            case THREE_PHASE: {
                this.ensureReady(request.getModifications());
                this.coordinatedCommit(envelope, now);
                return null;
            }
        }
        LOG.warn("{}: rejecting unsupported protocol {}", (Object)this.persistenceId(), maybeProto.orElseThrow());
        throw new UnsupportedRequestException((Request)request);
    }

    private void ensureReady(Collection<TransactionModification> modifications) {
        if (this.state instanceof Ready) {
            LOG.debug("{}: {} is already in state {}", new Object[]{this.persistenceId(), this.getIdentifier(), this.state});
            return;
        }
        this.applyModifications(modifications);
        this.state = new Ready(this.checkOpen().ready(Optional.empty()));
        LOG.debug("{}: transitioned {} to ready", (Object)this.persistenceId(), (Object)this.getIdentifier());
    }

    private void throwIfFailed() throws RequestException {
        if (this.state instanceof Failed) {
            LOG.debug("{}: {} has failed, rejecting request", (Object)this.persistenceId(), (Object)this.getIdentifier());
            throw ((Failed)this.state).cause;
        }
    }

    private ReadWriteShardDataTreeTransaction checkOpen() {
        Preconditions.checkState((boolean)(this.state instanceof Open), (String)"%s expect to be open, is in state %s", (Object)this.getIdentifier(), (Object)this.state);
        return ((Open)this.state).openTransaction;
    }

    private Ready checkReady() {
        Preconditions.checkState((boolean)(this.state instanceof Ready), (String)"%s expect to be ready, is in state %s", (Object)this.getIdentifier(), (Object)this.state);
        return (Ready)this.state;
    }

    private DataTreeModification checkSealed() {
        Preconditions.checkState((boolean)(this.state instanceof Sealed), (String)"%s expect to be sealed, is in state %s", (Object)this.getIdentifier(), (Object)this.state);
        return ((Sealed)this.state).sealedModification;
    }

    private static void throwUnhandledCommitStage(Ready ready) {
        throw new IllegalStateException("Unhandled commit stage " + String.valueOf((Object)ready.stage));
    }

    private static final class Open
    extends State {
        final ReadWriteShardDataTreeTransaction openTransaction;

        Open(ReadWriteShardDataTreeTransaction openTransaction) {
            this.openTransaction = Objects.requireNonNull(openTransaction);
        }

        @Override
        public String toString() {
            return "OPEN";
        }
    }

    private static abstract class State {
        private State() {
        }

        public abstract String toString();
    }

    private static final class Sealed
    extends State {
        final DataTreeModification sealedModification;

        Sealed(DataTreeModification sealedModification) {
            this.sealedModification = Objects.requireNonNull(sealedModification);
        }

        @Override
        public String toString() {
            return "SEALED";
        }
    }

    private static final class Retired
    extends State {
        private final String prevStateString;

        Retired(State prevState) {
            this.prevStateString = prevState.toString();
        }

        @Override
        public String toString() {
            return "RETIRED (in " + this.prevStateString + ")";
        }
    }

    private static final class Ready
    extends State {
        final ShardDataTreeCohort readyCohort;
        CommitStage stage;

        Ready(ShardDataTreeCohort readyCohort) {
            this.readyCohort = Objects.requireNonNull(readyCohort);
            this.stage = CommitStage.READY;
        }

        @Override
        public String toString() {
            return "READY (" + String.valueOf((Object)this.stage) + ")";
        }
    }

    private static enum CommitStage {
        READY,
        CAN_COMMIT_PENDING,
        CAN_COMMIT_COMPLETE,
        PRE_COMMIT_PENDING,
        PRE_COMMIT_COMPLETE,
        COMMIT_PENDING;

    }

    private static final class Failed
    extends State {
        final RequestException cause;

        Failed(RequestException cause) {
            this.cause = Objects.requireNonNull(cause);
        }

        @Override
        public String toString() {
            return "FAILED (" + this.cause.getMessage() + ")";
        }
    }
}

