/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import akka.actor.ActorRef;
import akka.actor.ActorSelection;
import akka.actor.PoisonPill;
import akka.dispatch.OnComplete;
import com.google.common.base.Verify;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.checkerframework.checker.lock.qual.GuardedBy;
import org.checkerframework.checker.lock.qual.Holding;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.controller.cluster.datastore.RootDataTreeChangeListenerActor;
import org.opendaylight.controller.cluster.datastore.messages.CloseDataTreeNotificationListenerRegistration;
import org.opendaylight.controller.cluster.datastore.messages.RegisterDataTreeChangeListener;
import org.opendaylight.controller.cluster.datastore.messages.RegisterDataTreeNotificationListenerReply;
import org.opendaylight.controller.cluster.datastore.utils.ActorUtils;
import org.opendaylight.mdsal.dom.api.DOMDataTreeChangeListener;
import org.opendaylight.yangtools.concepts.AbstractObjectRegistration;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;

final class RootDataTreeChangeListenerProxy<L extends DOMDataTreeChangeListener>
extends AbstractObjectRegistration<L> {
    private static final Logger LOG = LoggerFactory.getLogger(RootDataTreeChangeListenerProxy.class);
    private final ActorUtils actorUtils;
    private @GuardedBy(value={"this"}) State state;

    RootDataTreeChangeListenerProxy(ActorUtils actorUtils, @NonNull L listener, Set<String> shardNames) {
        super(listener);
        this.actorUtils = Objects.requireNonNull(actorUtils);
        this.state = new ResolveShards(shardNames.size());
        for (final String shardName : shardNames) {
            actorUtils.findLocalShardAsync(shardName).onComplete((Function1)new OnComplete<ActorRef>(){

                public void onComplete(Throwable failure, ActorRef success) {
                    RootDataTreeChangeListenerProxy.this.onFindLocalShardComplete(shardName, failure, success);
                }
            }, actorUtils.getClientDispatcher());
        }
    }

    protected synchronized void removeRegistration() {
        if (!(this.state instanceof Terminated)) {
            if (this.state instanceof ResolveShards) {
                this.state = new Terminated();
            } else {
                State state = this.state;
                if (state instanceof Subscribed) {
                    Subscribed subscribed = (Subscribed)state;
                    this.terminate(subscribed);
                } else {
                    throw new IllegalStateException("Unhandled close in state " + String.valueOf(this.state));
                }
            }
        }
    }

    private synchronized void onFindLocalShardComplete(String shardName, Throwable failure, ActorRef shard) {
        State state = this.state;
        if (state instanceof ResolveShards) {
            ResolveShards resolveShards = (ResolveShards)state;
            this.localShardsResolved(resolveShards, shardName, failure, shard);
        } else {
            LOG.debug("{}: lookup for shard {} turned into a noop on state {}", new Object[]{this.logContext(), shardName, this.state});
        }
    }

    @Holding(value={"this"})
    private void localShardsResolved(ResolveShards current, String shardName, Throwable failure, ActorRef shard) {
        Object result = failure != null ? failure : Verify.verifyNotNull((Object)shard);
        LOG.debug("{}: lookup for shard {} resulted in {}", new Object[]{this.logContext(), shardName, result});
        current.localShards.put(shardName, result);
        if (current.localShards.size() == current.shardCount) {
            if (current.localShards.values().stream().anyMatch(Throwable.class::isInstance)) {
                this.reportFailure(current.localShards);
            } else {
                this.subscribeToShards(current.localShards);
            }
        }
    }

    @Holding(value={"this"})
    private void reportFailure(Map<String, Object> localShards) {
        for (Map.Entry entry : Maps.filterValues(localShards, Throwable.class::isInstance).entrySet()) {
            Throwable cause = (Throwable)entry.getValue();
            LOG.error("{}: Failed to find local shard {}, cannot register {} at root", new Object[]{this.logContext(), entry.getKey(), this.getInstance(), cause});
        }
        this.state = new Terminated();
    }

    @Holding(value={"this"})
    private void subscribeToShards(Map<String, Object> localShards) {
        for (Map.Entry<String, Object> entry : localShards.entrySet()) {
            Object obj = entry.getValue();
            Verify.verify((boolean)(obj instanceof ActorRef), (String)"Unhandled response %s for shard %s", (Object)obj, (Object)entry.getKey());
        }
        ActorRef dtclActor = this.actorUtils.getActorSystem().actorOf(RootDataTreeChangeListenerActor.props((DOMDataTreeChangeListener)this.getInstance(), localShards.size()).withDispatcher(this.actorUtils.getNotificationDispatcherPath()));
        this.state = new Subscribed(dtclActor, localShards.size());
        RegisterDataTreeChangeListener regMessage = new RegisterDataTreeChangeListener(YangInstanceIdentifier.of(), dtclActor, true);
        for (Map.Entry<String, Object> entry : localShards.entrySet()) {
            final String shardName = entry.getKey();
            ActorRef shard = (ActorRef)entry.getValue();
            this.actorUtils.executeOperationAsync(shard, (Object)regMessage, this.actorUtils.getDatastoreContext().getShardInitializationTimeout()).onComplete((Function1)new OnComplete<Object>(){

                public void onComplete(Throwable failure, Object result) {
                    RootDataTreeChangeListenerProxy.this.onShardSubscribed(shardName, failure, result);
                }
            }, this.actorUtils.getClientDispatcher());
        }
    }

    private synchronized void onShardSubscribed(String shardName, Throwable failure, Object result) {
        State state = this.state;
        if (state instanceof Subscribed) {
            Subscribed current = (Subscribed)state;
            if (failure != null) {
                LOG.error("{}: Shard {} failed to subscribe, terminating listener {}", new Object[]{this.logContext(), shardName, this.getInstance(), failure});
                this.terminate(current);
            } else {
                this.onSuccessfulSubscription(current, shardName, (RegisterDataTreeNotificationListenerReply)result);
            }
        } else {
            this.terminateSubscription(shardName, failure, result);
        }
    }

    @Holding(value={"this"})
    private void onSuccessfulSubscription(Subscribed current, String shardName, RegisterDataTreeNotificationListenerReply reply) {
        ActorSelection regActor = this.actorUtils.actorSelection(reply.getListenerRegistrationPath());
        LOG.debug("{}: Shard {} subscribed at {}", new Object[]{this.logContext(), shardName, regActor});
        current.subscriptions.add(regActor);
    }

    @Holding(value={"this"})
    private void terminate(Subscribed current) {
        current.dtclActor.tell((Object)PoisonPill.getInstance(), ActorRef.noSender());
        for (ActorSelection regActor : current.subscriptions) {
            regActor.tell((Object)CloseDataTreeNotificationListenerRegistration.getInstance(), ActorRef.noSender());
        }
        this.state = new Terminated();
    }

    private void terminateSubscription(String shardName, Throwable failure, Object result) {
        if (failure == null) {
            ActorSelection regActor = this.actorUtils.actorSelection(((RegisterDataTreeNotificationListenerReply)result).getListenerRegistrationPath());
            LOG.debug("{}: Shard {} registered late, terminating subscription at {}", new Object[]{this.logContext(), shardName, regActor});
            regActor.tell((Object)CloseDataTreeNotificationListenerRegistration.getInstance(), ActorRef.noSender());
        } else {
            LOG.debug("{}: Shard {} reported late failure", new Object[]{this.logContext(), shardName, failure});
        }
    }

    private String logContext() {
        return this.actorUtils.getDatastoreContext().getLogicalStoreType().toString();
    }

    private static final class ResolveShards
    extends State {
        final Map<String, Object> localShards = new HashMap<String, Object>();
        final int shardCount;

        ResolveShards(int shardCount) {
            this.shardCount = shardCount;
        }
    }

    private static abstract class State {
        private State() {
        }
    }

    private static final class Terminated
    extends State {
        private Terminated() {
        }
    }

    private static final class Subscribed
    extends State {
        final List<ActorSelection> subscriptions;
        final ActorRef dtclActor;

        Subscribed(ActorRef dtclActor, int shardCount) {
            this.dtclActor = Objects.requireNonNull(dtclActor);
            this.subscriptions = new ArrayList<ActorSelection>(shardCount);
        }
    }
}

