/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import akka.actor.ActorRef;
import akka.util.Timeout;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.primitives.UnsignedLong;
import com.google.common.util.concurrent.FutureCallback;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Queue;
import java.util.SortedSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.controller.cluster.access.concepts.LocalHistoryIdentifier;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;
import org.opendaylight.controller.cluster.datastore.AbstractShardDataTreeTransaction;
import org.opendaylight.controller.cluster.datastore.DataTreeCohortActorRegistry;
import org.opendaylight.controller.cluster.datastore.DatastoreContext;
import org.opendaylight.controller.cluster.datastore.DefaultShardDataTreeChangeListenerPublisher;
import org.opendaylight.controller.cluster.datastore.ReadOnlyShardDataTreeTransaction;
import org.opendaylight.controller.cluster.datastore.ReadWriteShardDataTreeTransaction;
import org.opendaylight.controller.cluster.datastore.Shard;
import org.opendaylight.controller.cluster.datastore.ShardDataTreeChangeListenerPublisher;
import org.opendaylight.controller.cluster.datastore.ShardDataTreeCohort;
import org.opendaylight.controller.cluster.datastore.ShardDataTreeMetadata;
import org.opendaylight.controller.cluster.datastore.ShardDataTreeTransactionChain;
import org.opendaylight.controller.cluster.datastore.ShardDataTreeTransactionParent;
import org.opendaylight.controller.cluster.datastore.ShardStats;
import org.opendaylight.controller.cluster.datastore.SimpleShardDataTreeCohort;
import org.opendaylight.controller.cluster.datastore.node.utils.transformer.ReusableNormalizedNodePruner;
import org.opendaylight.controller.cluster.datastore.persisted.AbortTransactionPayload;
import org.opendaylight.controller.cluster.datastore.persisted.AbstractIdentifiablePayload;
import org.opendaylight.controller.cluster.datastore.persisted.CloseLocalHistoryPayload;
import org.opendaylight.controller.cluster.datastore.persisted.CommitTransactionPayload;
import org.opendaylight.controller.cluster.datastore.persisted.CreateLocalHistoryPayload;
import org.opendaylight.controller.cluster.datastore.persisted.MetadataShardDataTreeSnapshot;
import org.opendaylight.controller.cluster.datastore.persisted.PayloadVersion;
import org.opendaylight.controller.cluster.datastore.persisted.PurgeLocalHistoryPayload;
import org.opendaylight.controller.cluster.datastore.persisted.PurgeTransactionPayload;
import org.opendaylight.controller.cluster.datastore.persisted.ShardDataTreeSnapshot;
import org.opendaylight.controller.cluster.datastore.persisted.ShardDataTreeSnapshotMetadata;
import org.opendaylight.controller.cluster.datastore.persisted.ShardSnapshotState;
import org.opendaylight.controller.cluster.datastore.persisted.SkipTransactionsPayload;
import org.opendaylight.controller.cluster.datastore.utils.DataTreeModificationOutput;
import org.opendaylight.controller.cluster.datastore.utils.ImmutableUnsignedLongSet;
import org.opendaylight.controller.cluster.datastore.utils.PruningDataTreeModification;
import org.opendaylight.controller.cluster.raft.base.messages.InitiateCaptureSnapshot;
import org.opendaylight.controller.cluster.raft.messages.Payload;
import org.opendaylight.mdsal.common.api.OptimisticLockFailedException;
import org.opendaylight.mdsal.common.api.TransactionCommitFailedException;
import org.opendaylight.mdsal.dom.api.DOMDataTreeChangeListener;
import org.opendaylight.yangtools.concepts.Identifier;
import org.opendaylight.yangtools.concepts.Registration;
import org.opendaylight.yangtools.yang.common.Empty;
import org.opendaylight.yangtools.yang.common.RpcError;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.codec.binfmt.NormalizedNodeStreamVersion;
import org.opendaylight.yangtools.yang.data.tree.api.ConflictingModificationAppliedException;
import org.opendaylight.yangtools.yang.data.tree.api.DataTree;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeCandidate;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeCandidateTip;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeConfiguration;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeModification;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeSnapshot;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeTip;
import org.opendaylight.yangtools.yang.data.tree.api.DataValidationFailedException;
import org.opendaylight.yangtools.yang.data.tree.api.ModificationType;
import org.opendaylight.yangtools.yang.data.tree.api.TreeType;
import org.opendaylight.yangtools.yang.data.tree.impl.di.InMemoryDataTreeFactory;
import org.opendaylight.yangtools.yang.data.tree.spi.DataTreeCandidates;
import org.opendaylight.yangtools.yang.data.util.DataSchemaContextTree;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.concurrent.duration.FiniteDuration;

@VisibleForTesting
public class ShardDataTree
extends ShardDataTreeTransactionParent {
    private static final Timeout COMMIT_STEP_TIMEOUT = new Timeout(FiniteDuration.create((long)5L, (TimeUnit)TimeUnit.SECONDS));
    private static final Logger LOG = LoggerFactory.getLogger(ShardDataTree.class);
    private static final int MAX_TRANSACTION_BATCH = 100;
    private final Map<LocalHistoryIdentifier, ShardDataTreeTransactionChain> transactionChains = new HashMap<LocalHistoryIdentifier, ShardDataTreeTransactionChain>();
    private final DataTreeCohortActorRegistry cohortRegistry = new DataTreeCohortActorRegistry();
    private final Deque<CommitEntry> pendingTransactions = new ArrayDeque<CommitEntry>();
    private final Queue<CommitEntry> pendingCommits = new ArrayDeque<CommitEntry>();
    private final Queue<CommitEntry> pendingFinishCommits = new ArrayDeque<CommitEntry>();
    private final Map<Payload, Runnable> replicationCallbacks = new HashMap<Payload, Runnable>();
    private final ShardDataTreeChangeListenerPublisher treeChangeListenerPublisher;
    private final Collection<ShardDataTreeMetadata<?>> metadata;
    private final DataTree dataTree;
    private final String logContext;
    private final Shard shard;
    private Runnable runOnPendingTransactionsComplete;
    private DataTreeTip tip;
    private EffectiveModelContext schemaContext;
    private DataSchemaContextTree dataSchemaContext;
    private int currentTransactionBatch;

    ShardDataTree(Shard shard, EffectiveModelContext schemaContext, DataTree dataTree, ShardDataTreeChangeListenerPublisher treeChangeListenerPublisher, String logContext, ShardDataTreeMetadata<?> ... metadata) {
        this.dataTree = Objects.requireNonNull(dataTree);
        this.updateSchemaContext(schemaContext);
        this.shard = Objects.requireNonNull(shard);
        this.treeChangeListenerPublisher = Objects.requireNonNull(treeChangeListenerPublisher);
        this.logContext = Objects.requireNonNull(logContext);
        this.metadata = ImmutableList.copyOf((Object[])metadata);
        this.tip = dataTree;
    }

    ShardDataTree(Shard shard, EffectiveModelContext schemaContext, TreeType treeType, YangInstanceIdentifier root, ShardDataTreeChangeListenerPublisher treeChangeListenerPublisher, String logContext, ShardDataTreeMetadata<?> ... metadata) {
        this(shard, schemaContext, ShardDataTree.createDataTree(treeType, root), treeChangeListenerPublisher, logContext, metadata);
    }

    private static DataTree createDataTree(TreeType treeType, YangInstanceIdentifier root) {
        DataTreeConfiguration baseConfig = DataTreeConfiguration.getDefault((TreeType)treeType);
        return new InMemoryDataTreeFactory().create(new DataTreeConfiguration.Builder(baseConfig.getTreeType()).setMandatoryNodesValidation(baseConfig.isMandatoryNodesValidationEnabled()).setUniqueIndexes(baseConfig.isUniqueIndexEnabled()).setRootPath(root).build());
    }

    @VisibleForTesting
    public ShardDataTree(Shard shard, EffectiveModelContext schemaContext, TreeType treeType) {
        this(shard, schemaContext, treeType, YangInstanceIdentifier.of(), new DefaultShardDataTreeChangeListenerPublisher(""), "", new ShardDataTreeMetadata[0]);
    }

    final String logContext() {
        return this.logContext;
    }

    final long readTime() {
        return this.shard.ticker().read();
    }

    final DataTree getDataTree() {
        return this.dataTree;
    }

    @VisibleForTesting
    final EffectiveModelContext getSchemaContext() {
        return this.schemaContext;
    }

    final void updateSchemaContext(@NonNull EffectiveModelContext newSchemaContext) {
        this.dataTree.setEffectiveModelContext(newSchemaContext);
        this.schemaContext = newSchemaContext;
        this.dataSchemaContext = DataSchemaContextTree.from((EffectiveModelContext)newSchemaContext);
    }

    final void resetTransactionBatch() {
        this.currentTransactionBatch = 0;
    }

    @NonNull ShardDataTreeSnapshot takeStateSnapshot() {
        NormalizedNode rootNode = (NormalizedNode)this.takeSnapshot().readNode(YangInstanceIdentifier.of()).orElseThrow();
        ImmutableMap.Builder metaBuilder = ImmutableMap.builder();
        for (ShardDataTreeMetadata<?> meta : this.metadata) {
            Object snapshot = meta.toSnapshot();
            if (snapshot == null) continue;
            metaBuilder.put(((ShardDataTreeSnapshotMetadata)snapshot).getType(), snapshot);
        }
        return new MetadataShardDataTreeSnapshot(rootNode, (Map<Class<? extends ShardDataTreeSnapshotMetadata<?>>, ShardDataTreeSnapshotMetadata<?>>)metaBuilder.build());
    }

    private boolean anyPendingTransactions() {
        return !this.pendingTransactions.isEmpty() || !this.pendingCommits.isEmpty() || !this.pendingFinishCommits.isEmpty();
    }

    private void applySnapshot(@NonNull ShardDataTreeSnapshot snapshot, UnaryOperator<DataTreeModification> wrapper) throws DataValidationFailedException {
        Map<Object, Object> map;
        Stopwatch elapsed = Stopwatch.createStarted();
        if (this.anyPendingTransactions()) {
            LOG.warn("{}: applying state snapshot with pending transactions", (Object)this.logContext);
        }
        if (snapshot instanceof MetadataShardDataTreeSnapshot) {
            MetadataShardDataTreeSnapshot ms = (MetadataShardDataTreeSnapshot)snapshot;
            map = ms.getMetadata();
        } else {
            map = Map.of();
        }
        Map snapshotMeta = map;
        for (ShardDataTreeMetadata shardDataTreeMetadata : this.metadata) {
            ShardDataTreeSnapshotMetadata s = (ShardDataTreeSnapshotMetadata)snapshotMeta.get(shardDataTreeMetadata.getSupportedType());
            if (s != null) {
                shardDataTreeMetadata.applySnapshot(s);
                continue;
            }
            shardDataTreeMetadata.reset();
        }
        DataTreeModification unwrapped = this.newModification();
        DataTreeModification dataTreeModification = (DataTreeModification)wrapper.apply(unwrapped);
        dataTreeModification.delete(YangInstanceIdentifier.of());
        snapshot.getRootNode().ifPresent(rootNode -> mod.write(YangInstanceIdentifier.of(), rootNode));
        dataTreeModification.ready();
        this.dataTree.validate(unwrapped);
        DataTreeCandidateTip candidate = this.dataTree.prepare(unwrapped);
        this.dataTree.commit((DataTreeCandidate)candidate);
        this.notifyListeners((DataTreeCandidate)candidate);
        LOG.debug("{}: state snapshot applied in {}", (Object)this.logContext, (Object)elapsed);
    }

    final void applySnapshot(@NonNull ShardDataTreeSnapshot snapshot) throws DataValidationFailedException {
        this.applySnapshot(snapshot, UnaryOperator.identity());
    }

    final void applyRecoverySnapshot(@NonNull ShardSnapshotState snapshot) throws DataValidationFailedException {
        ReusableNormalizedNodePruner pruner = ReusableNormalizedNodePruner.forDataSchemaContext((DataSchemaContextTree)this.dataSchemaContext);
        if (snapshot.needsMigration()) {
            ReusableNormalizedNodePruner uintPruner = pruner.withUintAdaption();
            this.applySnapshot(snapshot.getSnapshot(), delegate -> new PruningDataTreeModification.Proactive((DataTreeModification)delegate, this.dataTree, uintPruner));
        } else {
            this.applySnapshot(snapshot.getSnapshot(), delegate -> new PruningDataTreeModification.Reactive((DataTreeModification)delegate, this.dataTree, pruner));
        }
    }

    private void applyRecoveryCandidate(CommitTransactionPayload payload) throws IOException {
        CommitTransactionPayload.CandidateTransaction entry = payload.acquireCandidate();
        DataTreeModification unwrapped = this.newModification();
        PruningDataTreeModification pruningMod = this.createPruningModification(unwrapped, NormalizedNodeStreamVersion.MAGNESIUM.compareTo((Enum)entry.streamVersion()) > 0);
        DataTreeCandidates.applyToModification((DataTreeModification)pruningMod, (DataTreeCandidate)entry.candidate());
        pruningMod.ready();
        LOG.trace("{}: Applying recovery modification {}", (Object)this.logContext, (Object)unwrapped);
        try {
            this.dataTree.validate(unwrapped);
            this.dataTree.commit((DataTreeCandidate)this.dataTree.prepare(unwrapped));
        }
        catch (Exception e) {
            File file = new File(System.getProperty("karaf.data", "."), "failed-recovery-payload-" + this.logContext + ".out");
            DataTreeModificationOutput.toFile(file, unwrapped);
            throw new IllegalStateException("%s: Failed to apply recovery payload. Modification data was written to file %s".formatted(this.logContext, file), e);
        }
        this.allMetadataCommittedTransaction(entry.transactionId());
    }

    private PruningDataTreeModification createPruningModification(DataTreeModification unwrapped, boolean uintAdapting) {
        ReusableNormalizedNodePruner pruner = ReusableNormalizedNodePruner.forDataSchemaContext((DataSchemaContextTree)this.dataSchemaContext);
        return uintAdapting ? new PruningDataTreeModification.Proactive(unwrapped, this.dataTree, pruner.withUintAdaption()) : new PruningDataTreeModification.Reactive(unwrapped, this.dataTree, pruner);
    }

    final void applyRecoveryPayload(@NonNull Payload payload) throws IOException {
        Payload payload2 = payload;
        Objects.requireNonNull(payload2);
        Payload payload3 = payload2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{CommitTransactionPayload.class, AbortTransactionPayload.class, PurgeTransactionPayload.class, CreateLocalHistoryPayload.class, CloseLocalHistoryPayload.class, PurgeLocalHistoryPayload.class, SkipTransactionsPayload.class}, (Object)payload3, n)) {
            case 0: {
                CommitTransactionPayload commit = (CommitTransactionPayload)payload3;
                this.applyRecoveryCandidate(commit);
                break;
            }
            case 1: {
                AbortTransactionPayload abort = (AbortTransactionPayload)payload3;
                this.allMetadataAbortedTransaction((TransactionIdentifier)abort.getIdentifier());
                break;
            }
            case 2: {
                PurgeTransactionPayload purge = (PurgeTransactionPayload)payload3;
                this.allMetadataPurgedTransaction((TransactionIdentifier)purge.getIdentifier());
                break;
            }
            case 3: {
                CreateLocalHistoryPayload create = (CreateLocalHistoryPayload)payload3;
                this.allMetadataCreatedLocalHistory((LocalHistoryIdentifier)create.getIdentifier());
                break;
            }
            case 4: {
                CloseLocalHistoryPayload close = (CloseLocalHistoryPayload)payload3;
                this.allMetadataClosedLocalHistory((LocalHistoryIdentifier)close.getIdentifier());
                break;
            }
            case 5: {
                PurgeLocalHistoryPayload purge = (PurgeLocalHistoryPayload)payload3;
                this.allMetadataPurgedLocalHistory((LocalHistoryIdentifier)purge.getIdentifier());
                break;
            }
            case 6: {
                SkipTransactionsPayload skip = (SkipTransactionsPayload)payload3;
                this.allMetadataSkipTransactions(skip);
                break;
            }
            default: {
                LOG.debug("{}: ignoring unhandled payload {}", (Object)this.logContext, (Object)payload);
            }
        }
    }

    private void applyReplicatedCandidate(CommitTransactionPayload payload) throws DataValidationFailedException, IOException {
        CommitTransactionPayload.CandidateTransaction payloadCandidate = payload.acquireCandidate();
        TransactionIdentifier transactionId = payloadCandidate.transactionId();
        LOG.debug("{}: Applying foreign transaction {}", (Object)this.logContext, (Object)transactionId);
        DataTreeModification mod = this.newModification();
        DataTreeCandidates.applyToModification((DataTreeModification)mod, (DataTreeCandidate)payloadCandidate.candidate());
        mod.ready();
        LOG.trace("{}: Applying foreign modification {}", (Object)this.logContext, (Object)mod);
        this.dataTree.validate(mod);
        DataTreeCandidateTip candidate = this.dataTree.prepare(mod);
        this.dataTree.commit((DataTreeCandidate)candidate);
        this.allMetadataCommittedTransaction(transactionId);
        this.notifyListeners((DataTreeCandidate)candidate);
    }

    final void applyReplicatedPayload(Identifier identifier, Payload payload) throws IOException, DataValidationFailedException {
        Payload payload2 = payload;
        Objects.requireNonNull(payload2);
        Payload payload3 = payload2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{CommitTransactionPayload.class, AbortTransactionPayload.class, PurgeTransactionPayload.class, CloseLocalHistoryPayload.class, CreateLocalHistoryPayload.class, PurgeLocalHistoryPayload.class, SkipTransactionsPayload.class}, (Object)payload3, n)) {
            case 0: {
                CommitTransactionPayload commit = (CommitTransactionPayload)payload3;
                if (identifier == null) {
                    this.applyReplicatedCandidate(commit);
                } else {
                    Verify.verify((boolean)(identifier instanceof TransactionIdentifier));
                    if (!this.payloadReplicationComplete((TransactionIdentifier)identifier)) {
                        this.applyReplicatedCandidate(commit);
                    }
                }
                this.checkRootOverwrite(commit.acquireCandidate().candidate());
                break;
            }
            case 1: {
                AbortTransactionPayload abort = (AbortTransactionPayload)payload3;
                if (identifier != null) {
                    this.payloadReplicationComplete(abort);
                }
                this.allMetadataAbortedTransaction((TransactionIdentifier)abort.getIdentifier());
                break;
            }
            case 2: {
                PurgeTransactionPayload purge = (PurgeTransactionPayload)payload3;
                if (identifier != null) {
                    this.payloadReplicationComplete(purge);
                }
                this.allMetadataPurgedTransaction((TransactionIdentifier)purge.getIdentifier());
                break;
            }
            case 3: {
                CloseLocalHistoryPayload close = (CloseLocalHistoryPayload)payload3;
                if (identifier != null) {
                    this.payloadReplicationComplete(close);
                }
                this.allMetadataClosedLocalHistory((LocalHistoryIdentifier)close.getIdentifier());
                break;
            }
            case 4: {
                CreateLocalHistoryPayload create = (CreateLocalHistoryPayload)payload3;
                if (identifier != null) {
                    this.payloadReplicationComplete(create);
                }
                this.allMetadataCreatedLocalHistory((LocalHistoryIdentifier)create.getIdentifier());
                break;
            }
            case 5: {
                PurgeLocalHistoryPayload purge = (PurgeLocalHistoryPayload)payload3;
                if (identifier != null) {
                    this.payloadReplicationComplete(purge);
                }
                this.allMetadataPurgedLocalHistory((LocalHistoryIdentifier)purge.getIdentifier());
                break;
            }
            case 6: {
                SkipTransactionsPayload skip = (SkipTransactionsPayload)payload3;
                if (identifier != null) {
                    this.payloadReplicationComplete(skip);
                }
                this.allMetadataSkipTransactions(skip);
                break;
            }
            default: {
                LOG.warn("{}: ignoring unhandled identifier {} payload {}", new Object[]{this.logContext, identifier, payload});
            }
        }
    }

    private void checkRootOverwrite(DataTreeCandidate candidate) {
        DatastoreContext datastoreContext = this.shard.getDatastoreContext();
        if (!datastoreContext.isSnapshotOnRootOverwrite()) {
            return;
        }
        if (!datastoreContext.isPersistent()) {
            return;
        }
        if (candidate.getRootPath().isEmpty() && candidate.getRootNode().modificationType() == ModificationType.WRITE) {
            LOG.debug("{}: shard root overwritten, enqueuing snapshot", (Object)this.logContext);
            this.shard.self().tell((Object)new InitiateCaptureSnapshot(), ActorRef.noSender());
        }
    }

    private void replicatePayload(Identifier id, Payload payload, @Nullable Runnable callback) {
        if (callback != null) {
            this.replicationCallbacks.put(payload, callback);
        }
        this.shard.persistPayload(id, payload, true);
    }

    private void payloadReplicationComplete(AbstractIdentifiablePayload<?> payload) {
        Runnable callback = this.replicationCallbacks.remove(payload);
        if (callback != null) {
            LOG.debug("{}: replication of {} completed, invoking {}", new Object[]{this.logContext, payload.getIdentifier(), callback});
            callback.run();
        } else {
            LOG.debug("{}: replication of {} has no callback", (Object)this.logContext, payload.getIdentifier());
        }
    }

    private boolean payloadReplicationComplete(TransactionIdentifier txId) {
        CommitEntry current = this.pendingFinishCommits.peek();
        if (current == null) {
            LOG.warn("{}: No outstanding transactions, ignoring consensus on transaction {}", (Object)this.logContext, (Object)txId);
            this.allMetadataCommittedTransaction(txId);
            return false;
        }
        TransactionIdentifier cohortTxId = current.cohort.transactionId();
        if (!cohortTxId.equals((Object)txId)) {
            LOG.debug("{}: Head of pendingFinishCommits queue is {}, ignoring consensus on transaction {}", new Object[]{this.logContext, cohortTxId, txId});
            this.allMetadataCommittedTransaction(txId);
            return false;
        }
        this.finishCommit(current.cohort);
        return true;
    }

    private void allMetadataAbortedTransaction(TransactionIdentifier txId) {
        for (ShardDataTreeMetadata<?> m : this.metadata) {
            m.onTransactionAborted(txId);
        }
    }

    private void allMetadataCommittedTransaction(TransactionIdentifier txId) {
        for (ShardDataTreeMetadata<?> m : this.metadata) {
            m.onTransactionCommitted(txId);
        }
    }

    private void allMetadataPurgedTransaction(TransactionIdentifier txId) {
        for (ShardDataTreeMetadata<?> m : this.metadata) {
            m.onTransactionPurged(txId);
        }
    }

    private void allMetadataCreatedLocalHistory(LocalHistoryIdentifier historyId) {
        for (ShardDataTreeMetadata<?> m : this.metadata) {
            m.onHistoryCreated(historyId);
        }
    }

    private void allMetadataClosedLocalHistory(LocalHistoryIdentifier historyId) {
        for (ShardDataTreeMetadata<?> m : this.metadata) {
            m.onHistoryClosed(historyId);
        }
    }

    private void allMetadataPurgedLocalHistory(LocalHistoryIdentifier historyId) {
        for (ShardDataTreeMetadata<?> m : this.metadata) {
            m.onHistoryPurged(historyId);
        }
    }

    private void allMetadataSkipTransactions(SkipTransactionsPayload payload) {
        LocalHistoryIdentifier historyId = (LocalHistoryIdentifier)payload.getIdentifier();
        ImmutableUnsignedLongSet txIds = payload.getTransactionIds();
        for (ShardDataTreeMetadata<?> m : this.metadata) {
            m.onTransactionsSkipped(historyId, txIds);
        }
    }

    final ShardDataTreeTransactionChain recreateTransactionChain(LocalHistoryIdentifier historyId, boolean closed) {
        ShardDataTreeTransactionChain ret = new ShardDataTreeTransactionChain(historyId, this);
        ShardDataTreeTransactionChain existing = this.transactionChains.putIfAbsent(historyId, ret);
        Preconditions.checkState((existing == null ? 1 : 0) != 0, (String)"Attempted to recreate chain %s, but %s already exists", (Object)historyId, (Object)existing);
        return ret;
    }

    final ShardDataTreeTransactionChain ensureTransactionChain(LocalHistoryIdentifier historyId, @Nullable Runnable callback) {
        ShardDataTreeTransactionChain chain = this.transactionChains.get(historyId);
        if (chain == null) {
            chain = new ShardDataTreeTransactionChain(historyId, this);
            this.transactionChains.put(historyId, chain);
            this.replicatePayload((Identifier)historyId, (Payload)CreateLocalHistoryPayload.create(historyId, this.shard.getDatastoreContext().getInitialPayloadSerializedBufferCapacity()), callback);
        } else if (callback != null) {
            callback.run();
        }
        return chain;
    }

    final @NonNull ReadOnlyShardDataTreeTransaction newReadOnlyTransaction(TransactionIdentifier txId) {
        this.shard.getShardMBean().incrementReadOnlyTransactionCount();
        LocalHistoryIdentifier historyId = txId.getHistoryId();
        return historyId.getHistoryId() == 0L ? this.newStandaloneReadOnlyTransaction(txId) : this.ensureTransactionChain(historyId, null).newReadOnlyTransaction(txId);
    }

    final @NonNull ReadOnlyShardDataTreeTransaction newStandaloneReadOnlyTransaction(TransactionIdentifier txId) {
        return new ReadOnlyShardDataTreeTransaction((ShardDataTreeTransactionParent)this, txId, this.takeSnapshot());
    }

    final @NonNull ReadWriteShardDataTreeTransaction newReadWriteTransaction(TransactionIdentifier txId) {
        this.shard.getShardMBean().incrementReadWriteTransactionCount();
        LocalHistoryIdentifier historyId = txId.getHistoryId();
        return historyId.getHistoryId() == 0L ? this.newStandaloneReadWriteTransaction(txId) : this.ensureTransactionChain(historyId, null).newReadWriteTransaction(txId);
    }

    final @NonNull ReadWriteShardDataTreeTransaction newStandaloneReadWriteTransaction(TransactionIdentifier txId) {
        return new ReadWriteShardDataTreeTransaction((ShardDataTreeTransactionParent)this, txId, this.newModification());
    }

    @VisibleForTesting
    final void notifyListeners(DataTreeCandidate candidate) {
        this.treeChangeListenerPublisher.publishChanges(candidate);
    }

    final void purgeLeaderState() {
        for (ShardDataTreeTransactionChain chain : this.transactionChains.values()) {
            chain.close();
        }
        this.transactionChains.clear();
        this.replicationCallbacks.clear();
    }

    final void closeTransactionChain(LocalHistoryIdentifier id, @Nullable Runnable callback) {
        if (this.commonCloseTransactionChain(id, callback)) {
            this.replicatePayload((Identifier)id, (Payload)CloseLocalHistoryPayload.create(id, this.shard.getDatastoreContext().getInitialPayloadSerializedBufferCapacity()), callback);
        }
    }

    final void closeTransactionChain(LocalHistoryIdentifier id) {
        this.commonCloseTransactionChain(id, null);
    }

    private boolean commonCloseTransactionChain(LocalHistoryIdentifier id, @Nullable Runnable callback) {
        ShardDataTreeTransactionChain chain = this.transactionChains.get(id);
        if (chain == null) {
            LOG.debug("{}: Closing non-existent transaction chain {}", (Object)this.logContext, (Object)id);
            if (callback != null) {
                callback.run();
            }
            return false;
        }
        chain.close();
        return true;
    }

    final void purgeTransactionChain(LocalHistoryIdentifier id, @Nullable Runnable callback) {
        ShardDataTreeTransactionChain chain = this.transactionChains.remove(id);
        if (chain == null) {
            LOG.debug("{}: Purging non-existent transaction chain {}", (Object)this.logContext, (Object)id);
            if (callback != null) {
                callback.run();
            }
            return;
        }
        this.replicatePayload((Identifier)id, (Payload)PurgeLocalHistoryPayload.create(id, this.shard.getDatastoreContext().getInitialPayloadSerializedBufferCapacity()), callback);
    }

    final void skipTransactions(LocalHistoryIdentifier id, ImmutableUnsignedLongSet transactionIds, Runnable callback) {
        ShardDataTreeTransactionChain chain = this.transactionChains.get(id);
        if (chain == null) {
            LOG.debug("{}: Skipping on non-existent transaction chain {}", (Object)this.logContext, (Object)id);
            if (callback != null) {
                callback.run();
            }
            return;
        }
        this.replicatePayload((Identifier)id, (Payload)SkipTransactionsPayload.create(id, transactionIds, this.shard.getDatastoreContext().getInitialPayloadSerializedBufferCapacity()), callback);
    }

    final Optional<DataTreeCandidate> readCurrentData() {
        return this.readNode(YangInstanceIdentifier.of()).map(state -> DataTreeCandidates.fromNormalizedNode((YangInstanceIdentifier)YangInstanceIdentifier.of(), (NormalizedNode)state));
    }

    final void registerTreeChangeListener(YangInstanceIdentifier path, DOMDataTreeChangeListener listener, Optional<DataTreeCandidate> initialState, Consumer<Registration> onRegistration) {
        this.treeChangeListenerPublisher.registerTreeChangeListener(path, listener, initialState, onRegistration);
    }

    final int getQueueSize() {
        return this.pendingTransactions.size() + this.pendingCommits.size() + this.pendingFinishCommits.size();
    }

    @Override
    final void abortTransaction(AbstractShardDataTreeTransaction<?> transaction, Runnable callback) {
        TransactionIdentifier id = transaction.getIdentifier();
        LOG.debug("{}: aborting transaction {}", (Object)this.logContext, (Object)id);
        this.replicatePayload((Identifier)id, (Payload)AbortTransactionPayload.create(id, this.shard.getDatastoreContext().getInitialPayloadSerializedBufferCapacity()), callback);
    }

    @Override
    final void abortFromTransactionActor(AbstractShardDataTreeTransaction<?> transaction) {
    }

    @Override
    final ShardDataTreeCohort finishTransaction(ReadWriteShardDataTreeTransaction transaction, Optional<SortedSet<String>> participatingShardNames) {
        DataTreeModification snapshot = (DataTreeModification)transaction.getSnapshot();
        TransactionIdentifier id = transaction.getIdentifier();
        LOG.debug("{}: readying transaction {}", (Object)this.logContext, (Object)id);
        snapshot.ready();
        LOG.debug("{}: transaction {} ready", (Object)this.logContext, (Object)id);
        return this.createReadyCohort(transaction.getIdentifier(), snapshot, participatingShardNames);
    }

    final void purgeTransaction(TransactionIdentifier id, Runnable callback) {
        LOG.debug("{}: purging transaction {}", (Object)this.logContext, (Object)id);
        this.replicatePayload((Identifier)id, (Payload)PurgeTransactionPayload.create(id, this.shard.getDatastoreContext().getInitialPayloadSerializedBufferCapacity()), callback);
    }

    @VisibleForTesting
    public final Optional<NormalizedNode> readNode(YangInstanceIdentifier path) {
        return this.takeSnapshot().readNode(path);
    }

    final DataTreeSnapshot takeSnapshot() {
        return this.dataTree.takeSnapshot();
    }

    @VisibleForTesting
    final DataTreeModification newModification() {
        return this.takeSnapshot().newModification();
    }

    final Collection<ShardDataTreeCohort> getAndClearPendingTransactions() {
        ArrayList<ShardDataTreeCohort> ret = new ArrayList<ShardDataTreeCohort>(this.getQueueSize());
        for (CommitEntry entry : this.pendingFinishCommits) {
            ret.add(entry.cohort);
        }
        for (CommitEntry entry : this.pendingCommits) {
            ret.add(entry.cohort);
        }
        for (CommitEntry entry : this.pendingTransactions) {
            ret.add(entry.cohort);
        }
        this.pendingFinishCommits.clear();
        this.pendingCommits.clear();
        this.pendingTransactions.clear();
        this.tip = this.dataTree;
        return ret;
    }

    final void resumeNextPendingTransaction() {
        LOG.debug("{}: attempting to resume transaction processing", (Object)this.logContext);
        this.processNextPending();
    }

    private void processNextPendingTransaction() {
        ++this.currentTransactionBatch;
        if (this.currentTransactionBatch > 100) {
            LOG.debug("{}: Already processed {}, scheduling continuation", (Object)this.logContext, (Object)this.currentTransactionBatch);
            this.shard.scheduleNextPendingTransaction();
            return;
        }
        this.processNextPending(this.pendingTransactions, ShardDataTreeCohort.State.CAN_COMMIT_PENDING, entry -> {
            Exception cause;
            SimpleShardDataTreeCohort cohort = entry.cohort;
            DataTreeModification modification = cohort.getDataTreeModification();
            LOG.debug("{}: Validating transaction {}", (Object)this.logContext, (Object)cohort.transactionId());
            try {
                this.tip.validate(modification);
                LOG.debug("{}: Transaction {} validated", (Object)this.logContext, (Object)cohort.transactionId());
                cohort.successfulCanCommit();
                entry.lastAccess = this.readTime();
                return;
            }
            catch (ConflictingModificationAppliedException e) {
                LOG.warn("{}: Store Tx {}: Conflicting modification for path {}.", new Object[]{this.logContext, cohort.transactionId(), e.getPath()});
                cause = new OptimisticLockFailedException("Optimistic lock failed for path " + String.valueOf(e.getPath()), (Throwable)e);
            }
            catch (DataValidationFailedException e) {
                LOG.warn("{}: Store Tx {}: Data validation failed for path {}.", new Object[]{this.logContext, cohort.transactionId(), e.getPath(), e});
                LOG.debug("{}: Store Tx {}: modifications: {}", new Object[]{this.logContext, cohort.transactionId(), modification});
                LOG.trace("{}: Current tree: {}", (Object)this.logContext, (Object)this.dataTree);
                cause = new TransactionCommitFailedException("Data did not pass validation for path " + String.valueOf(e.getPath()), (Throwable)e, new RpcError[0]);
            }
            catch (Exception e) {
                LOG.warn("{}: Unexpected failure in validation phase", (Object)this.logContext, (Object)e);
                cause = e;
            }
            this.pendingTransactions.poll().cohort.failedCanCommit(cause);
        });
    }

    private void processNextPending() {
        this.processNextPendingCommit();
        this.processNextPendingTransaction();
    }

    private void processNextPending(Queue<CommitEntry> queue, ShardDataTreeCohort.State allowedState, Consumer<CommitEntry> processor) {
        while (!queue.isEmpty()) {
            CommitEntry entry = queue.peek();
            SimpleShardDataTreeCohort cohort = entry.cohort;
            if (cohort.isFailed()) {
                LOG.debug("{}: Removing failed transaction {}", (Object)this.logContext, (Object)cohort.transactionId());
                queue.remove();
                continue;
            }
            if (cohort.getState() != allowedState) break;
            processor.accept(entry);
            break;
        }
        this.maybeRunOperationOnPendingTransactionsComplete();
    }

    private void processNextPendingCommit() {
        this.processNextPending(this.pendingCommits, ShardDataTreeCohort.State.COMMIT_PENDING, entry -> this.startCommit(entry.cohort, (DataTreeCandidate)entry.cohort.getCandidate()));
    }

    private boolean peekNextPendingCommit() {
        CommitEntry first = this.pendingCommits.peek();
        return first != null && first.cohort.getState() == ShardDataTreeCohort.State.COMMIT_PENDING;
    }

    void startCanCommit(SimpleShardDataTreeCohort cohort) {
        CommitEntry head = this.pendingTransactions.peek();
        if (head == null) {
            LOG.warn("{}: No transactions enqueued while attempting to start canCommit on {}", (Object)this.logContext, (Object)cohort);
            return;
        }
        if (!cohort.equals(head.cohort)) {
            Collection<String> precedingShardNames = this.extractPrecedingShardNames(cohort.getParticipatingShardNames());
            if (precedingShardNames.isEmpty()) {
                LOG.debug("{}: Tx {} is scheduled for canCommit step", (Object)this.logContext, (Object)cohort.transactionId());
                return;
            }
            LOG.debug("{}: Evaluating tx {} for canCommit -  preceding participating shard names {}", new Object[]{this.logContext, cohort.transactionId(), precedingShardNames});
            Iterator<CommitEntry> iter = this.pendingTransactions.iterator();
            int index = -1;
            int moveToIndex = -1;
            while (iter.hasNext()) {
                CommitEntry entry = iter.next();
                ++index;
                if (cohort.equals(entry.cohort)) {
                    if (moveToIndex < 0) {
                        LOG.debug("{}: Not moving tx {} - cannot proceed with canCommit", (Object)this.logContext, (Object)cohort.transactionId());
                        return;
                    }
                    LOG.debug("{}: Moving {} to index {} in the pendingTransactions queue", new Object[]{this.logContext, cohort.transactionId(), moveToIndex});
                    iter.remove();
                    ShardDataTree.insertEntry(this.pendingTransactions, entry, moveToIndex);
                    if (!cohort.equals(this.pendingTransactions.peek().cohort)) {
                        LOG.debug("{}: Tx {} is not at the head of the queue - cannot proceed with canCommit", (Object)this.logContext, (Object)cohort.transactionId());
                        return;
                    }
                    LOG.debug("{}: Tx {} is now at the head of the queue - proceeding with canCommit", (Object)this.logContext, (Object)cohort.transactionId());
                    break;
                }
                if (entry.cohort.getState() != ShardDataTreeCohort.State.READY) {
                    LOG.debug("{}: Skipping pending transaction {} in state {}", new Object[]{this.logContext, entry.cohort.transactionId(), entry.cohort.getState()});
                    continue;
                }
                Collection<String> pendingPrecedingShardNames = this.extractPrecedingShardNames(entry.cohort.getParticipatingShardNames());
                if (precedingShardNames.equals(pendingPrecedingShardNames)) {
                    if (moveToIndex < 0) {
                        LOG.debug("{}: Preceding shard names {} for pending tx {} match - saving moveToIndex {}", new Object[]{this.logContext, pendingPrecedingShardNames, entry.cohort.transactionId(), index});
                        moveToIndex = index;
                        continue;
                    }
                    LOG.debug("{}: Preceding shard names {} for pending tx {} match but moveToIndex already set to {}", new Object[]{this.logContext, pendingPrecedingShardNames, entry.cohort.transactionId(), moveToIndex});
                    continue;
                }
                LOG.debug("{}: Preceding shard names {} for pending tx {} differ - skipping", new Object[]{this.logContext, pendingPrecedingShardNames, entry.cohort.transactionId()});
            }
        }
        this.processNextPendingTransaction();
    }

    private static void insertEntry(Deque<CommitEntry> queue, CommitEntry entry, int atIndex) {
        if (atIndex == 0) {
            queue.addFirst(entry);
            return;
        }
        LOG.trace("Inserting into Deque at index {}", (Object)atIndex);
        ArrayDeque<CommitEntry> tempStack = new ArrayDeque<CommitEntry>(atIndex);
        for (int i = 0; i < atIndex; ++i) {
            tempStack.push(queue.poll());
        }
        queue.addFirst(entry);
        tempStack.forEach(queue::addFirst);
    }

    private Collection<String> extractPrecedingShardNames(Optional<SortedSet<String>> participatingShardNames) {
        return participatingShardNames.map(set -> set.headSet(this.shard.getShardName())).orElse(Collections.emptyList());
    }

    private void failPreCommit(Throwable cause) {
        this.shard.getShardMBean().incrementFailedTransactionsCount();
        this.pendingTransactions.poll().cohort.failedPreCommit(cause);
        this.processNextPendingTransaction();
    }

    void startPreCommit(final SimpleShardDataTreeCohort cohort) {
        DataTreeCandidateTip candidate;
        final CommitEntry entry = this.pendingTransactions.peek();
        Preconditions.checkState((entry != null ? 1 : 0) != 0, (String)"Attempted to pre-commit of %s when no transactions pending", (Object)cohort);
        SimpleShardDataTreeCohort current = entry.cohort;
        Verify.verify((boolean)cohort.equals(current), (String)"Attempted to pre-commit %s while %s is pending", (Object)cohort, (Object)current);
        final TransactionIdentifier currentId = current.transactionId();
        LOG.debug("{}: Preparing transaction {}", (Object)this.logContext, (Object)currentId);
        try {
            candidate = this.tip.prepare(cohort.getDataTreeModification());
            LOG.debug("{}: Transaction {} candidate ready", (Object)this.logContext, (Object)currentId);
        }
        catch (RuntimeException | DataValidationFailedException e) {
            this.failPreCommit(e);
            return;
        }
        cohort.userPreCommit((DataTreeCandidate)candidate, new FutureCallback<Empty>(){

            public void onSuccess(Empty result) {
                ShardDataTree.this.tip = (DataTreeTip)Verify.verifyNotNull((Object)candidate);
                entry.lastAccess = ShardDataTree.this.readTime();
                ShardDataTree.this.pendingTransactions.remove();
                ShardDataTree.this.pendingCommits.add(entry);
                LOG.debug("{}: Transaction {} prepared", (Object)ShardDataTree.this.logContext, (Object)currentId);
                cohort.successfulPreCommit(candidate);
                ShardDataTree.this.processNextPendingTransaction();
            }

            public void onFailure(Throwable failure) {
                ShardDataTree.this.failPreCommit(failure);
            }
        });
    }

    private void failCommit(Exception cause) {
        this.shard.getShardMBean().incrementFailedTransactionsCount();
        this.pendingFinishCommits.poll().cohort.failedCommit(cause);
        this.processNextPending();
    }

    private void finishCommit(SimpleShardDataTreeCohort cohort) {
        TransactionIdentifier txId = cohort.transactionId();
        DataTreeCandidateTip candidate = cohort.getCandidate();
        LOG.debug("{}: Resuming commit of transaction {}", (Object)this.logContext, (Object)txId);
        if (this.tip == candidate) {
            this.tip = this.dataTree;
        }
        try {
            this.dataTree.commit((DataTreeCandidate)candidate);
        }
        catch (Exception e) {
            LOG.error("{}: Failed to commit transaction {}", new Object[]{this.logContext, txId, e});
            this.failCommit(e);
            return;
        }
        this.allMetadataCommittedTransaction(txId);
        this.shard.getShardMBean().incrementCommittedTransactionCount();
        this.shard.getShardMBean().setLastCommittedTransactionTime(System.currentTimeMillis());
        this.pendingFinishCommits.poll().cohort.successfulCommit(UnsignedLong.ZERO, () -> this.lambda$finishCommit$7(txId, (DataTreeCandidate)candidate));
    }

    void startCommit(SimpleShardDataTreeCohort cohort, DataTreeCandidate candidate) {
        CommitTransactionPayload payload;
        CommitEntry entry = this.pendingCommits.peek();
        Preconditions.checkState((entry != null ? 1 : 0) != 0, (String)"Attempted to start commit of %s when no transactions pending", (Object)cohort);
        SimpleShardDataTreeCohort current = entry.cohort;
        if (!cohort.equals(current)) {
            LOG.debug("{}: Transaction {} scheduled for commit step", (Object)this.logContext, (Object)cohort.transactionId());
            return;
        }
        LOG.debug("{}: Starting commit for transaction {}", (Object)this.logContext, (Object)current.transactionId());
        TransactionIdentifier txId = cohort.transactionId();
        try {
            payload = CommitTransactionPayload.create(txId, candidate, PayloadVersion.current(), this.shard.getDatastoreContext().getInitialPayloadSerializedBufferCapacity());
        }
        catch (IOException e) {
            LOG.error("{}: Failed to encode transaction {} candidate {}", new Object[]{this.logContext, txId, candidate, e});
            this.pendingCommits.poll().cohort.failedCommit(e);
            this.processNextPending();
            return;
        }
        this.processNextPendingTransaction();
        this.pendingCommits.remove();
        this.pendingFinishCommits.add(entry);
        boolean replicationBatchHint = this.peekNextPendingCommit();
        this.shard.persistPayload((Identifier)txId, (Payload)payload, replicationBatchHint);
        entry.lastAccess = this.shard.ticker().read();
        LOG.debug("{}: Transaction {} submitted to persistence", (Object)this.logContext, (Object)txId);
        this.processNextPendingCommit();
    }

    final Collection<ActorRef> getCohortActors() {
        return this.cohortRegistry.getCohortActors();
    }

    final void processCohortRegistryCommand(ActorRef sender, DataTreeCohortActorRegistry.CohortRegistryCommand message) {
        this.cohortRegistry.process(sender, message);
    }

    @Override
    final ShardDataTreeCohort createFailedCohort(TransactionIdentifier txId, DataTreeModification mod, Exception failure) {
        SimpleShardDataTreeCohort cohort = new SimpleShardDataTreeCohort(this, mod, txId, failure);
        this.pendingTransactions.add(new CommitEntry(cohort, this.readTime()));
        return cohort;
    }

    @Override
    final ShardDataTreeCohort createReadyCohort(TransactionIdentifier txId, DataTreeModification mod, Optional<SortedSet<String>> participatingShardNames) {
        SimpleShardDataTreeCohort cohort = new SimpleShardDataTreeCohort(this, mod, txId, this.cohortRegistry.createCohort(this.schemaContext, txId, arg_0 -> ((Shard)this.shard).executeInSelf(arg_0), COMMIT_STEP_TIMEOUT), participatingShardNames);
        this.pendingTransactions.add(new CommitEntry(cohort, this.readTime()));
        return cohort;
    }

    final ShardDataTreeCohort newReadyCohort(TransactionIdentifier txId, DataTreeModification mod, Optional<SortedSet<String>> participatingShardNames) {
        LocalHistoryIdentifier historyId = txId.getHistoryId();
        if (historyId.getHistoryId() == 0L) {
            return this.createReadyCohort(txId, mod, participatingShardNames);
        }
        return this.ensureTransactionChain(historyId, null).createReadyCohort(txId, mod, participatingShardNames);
    }

    @SuppressFBWarnings(value={"DB_DUPLICATE_SWITCH_CLAUSES"}, justification="See inline comments below.")
    final void checkForExpiredTransactions(long transactionCommitTimeoutMillis, Function<SimpleShardDataTreeCohort, OptionalLong> accessTimeUpdater) {
        long timeout = TimeUnit.MILLISECONDS.toNanos(transactionCommitTimeoutMillis);
        long now = this.readTime();
        Queue<CommitEntry> currentQueue = !this.pendingFinishCommits.isEmpty() ? this.pendingFinishCommits : (!this.pendingCommits.isEmpty() ? this.pendingCommits : this.pendingTransactions);
        CommitEntry currentTx = currentQueue.peek();
        if (currentTx == null) {
            return;
        }
        long delta = now - currentTx.lastAccess;
        if (delta < timeout) {
            return;
        }
        OptionalLong updateOpt = accessTimeUpdater.apply(currentTx.cohort);
        if (updateOpt.isPresent()) {
            long newAccess = updateOpt.orElseThrow();
            long newDelta = now - newAccess;
            if (newDelta < delta) {
                LOG.debug("{}: Updated current transaction {} access time", (Object)this.logContext, (Object)currentTx.cohort.transactionId());
                currentTx.lastAccess = newAccess;
                delta = newDelta;
            }
            if (delta < timeout) {
                return;
            }
        }
        long deltaMillis = TimeUnit.NANOSECONDS.toMillis(delta);
        ShardDataTreeCohort.State state = currentTx.cohort.getState();
        LOG.warn("{}: Current transaction {} has timed out after {} ms in state {}", new Object[]{this.logContext, currentTx.cohort.transactionId(), deltaMillis, state});
        boolean processNext = true;
        TimeoutException cohortFailure = new TimeoutException("Backend timeout in state " + String.valueOf((Object)state) + " after " + deltaMillis + "ms");
        switch (state) {
            case CAN_COMMIT_PENDING: {
                currentQueue.remove().cohort.failedCanCommit(cohortFailure);
                break;
            }
            case CAN_COMMIT_COMPLETE: {
                currentQueue.remove().cohort.reportFailure(cohortFailure);
                break;
            }
            case PRE_COMMIT_PENDING: {
                currentQueue.remove().cohort.failedPreCommit(cohortFailure);
                break;
            }
            case PRE_COMMIT_COMPLETE: {
                currentQueue.remove().cohort.reportFailure(cohortFailure);
                break;
            }
            case COMMIT_PENDING: {
                LOG.warn("{}: Transaction {} is still committing, cannot abort", (Object)this.logContext, (Object)currentTx.cohort.transactionId());
                currentTx.lastAccess = now;
                processNext = false;
                return;
            }
            case READY: {
                currentQueue.remove().cohort.reportFailure(cohortFailure);
                break;
            }
            default: {
                currentQueue.remove();
            }
        }
        if (processNext) {
            this.processNextPending();
        }
    }

    boolean startAbort(SimpleShardDataTreeCohort cohort) {
        Iterator<CommitEntry> it = Iterables.concat(this.pendingFinishCommits, this.pendingCommits, this.pendingTransactions).iterator();
        if (!it.hasNext()) {
            LOG.debug("{}: no open transaction while attempting to abort {}", (Object)this.logContext, (Object)cohort.transactionId());
            return true;
        }
        CommitEntry first = (CommitEntry)it.next();
        if (cohort.equals(first.cohort)) {
            if (cohort.getState() != ShardDataTreeCohort.State.COMMIT_PENDING) {
                LOG.debug("{}: aborting head of queue {} in state {}", new Object[]{this.logContext, cohort.transactionId(), cohort.transactionId()});
                it.remove();
                if (cohort.getCandidate() != null) {
                    this.rebaseTransactions(it, (DataTreeTip)this.dataTree);
                }
                this.processNextPending();
                return true;
            }
            LOG.warn("{}: transaction {} is committing, skipping abort", (Object)this.logContext, (Object)cohort.transactionId());
            return false;
        }
        DataTreeTip newTip = (DataTreeTip)Objects.requireNonNullElse(first.cohort.getCandidate(), this.dataTree);
        while (it.hasNext()) {
            CommitEntry e = (CommitEntry)it.next();
            if (cohort.equals(e.cohort)) {
                LOG.debug("{}: aborting queued transaction {}", (Object)this.logContext, (Object)cohort.transactionId());
                it.remove();
                if (cohort.getCandidate() != null) {
                    this.rebaseTransactions(it, newTip);
                }
                return true;
            }
            newTip = Objects.requireNonNullElse(e.cohort.getCandidate(), newTip);
        }
        LOG.debug("{}: aborted transaction {} not found in the queue", (Object)this.logContext, (Object)cohort.transactionId());
        return true;
    }

    private void rebaseTransactions(Iterator<CommitEntry> iter, @NonNull DataTreeTip newTip) {
        this.tip = Objects.requireNonNull(newTip);
        while (iter.hasNext()) {
            SimpleShardDataTreeCohort cohort = iter.next().cohort;
            if (cohort.getState() == ShardDataTreeCohort.State.CAN_COMMIT_COMPLETE) {
                LOG.debug("{}: Revalidating queued transaction {}", (Object)this.logContext, (Object)cohort.transactionId());
                try {
                    this.tip.validate(cohort.getDataTreeModification());
                }
                catch (RuntimeException | DataValidationFailedException e) {
                    LOG.debug("{}: Failed to revalidate queued transaction {}", new Object[]{this.logContext, cohort.transactionId(), e});
                    cohort.reportFailure((Exception)e);
                }
                continue;
            }
            if (cohort.getState() != ShardDataTreeCohort.State.PRE_COMMIT_COMPLETE) continue;
            LOG.debug("{}: Repreparing queued transaction {}", (Object)this.logContext, (Object)cohort.transactionId());
            try {
                this.tip.validate(cohort.getDataTreeModification());
                DataTreeCandidateTip candidate = this.tip.prepare(cohort.getDataTreeModification());
                cohort.setNewCandidate(candidate);
                this.tip = candidate;
            }
            catch (RuntimeException | DataValidationFailedException e) {
                LOG.debug("{}: Failed to reprepare queued transaction {}", new Object[]{this.logContext, cohort.transactionId(), e});
                cohort.reportFailure((Exception)e);
            }
        }
    }

    final void setRunOnPendingTransactionsComplete(Runnable operation) {
        this.runOnPendingTransactionsComplete = operation;
        this.maybeRunOperationOnPendingTransactionsComplete();
    }

    private void maybeRunOperationOnPendingTransactionsComplete() {
        if (this.runOnPendingTransactionsComplete != null && !this.anyPendingTransactions()) {
            LOG.debug("{}: Pending transactions complete - running operation {}", (Object)this.logContext, (Object)this.runOnPendingTransactionsComplete);
            this.runOnPendingTransactionsComplete.run();
            this.runOnPendingTransactionsComplete = null;
        }
    }

    final ShardStats getStats() {
        return this.shard.getShardMBean();
    }

    final Iterator<SimpleShardDataTreeCohort> cohortIterator() {
        return Iterables.transform((Iterable)Iterables.concat(this.pendingFinishCommits, this.pendingCommits, this.pendingTransactions), e -> e.cohort).iterator();
    }

    final void removeTransactionChain(LocalHistoryIdentifier id) {
        if (this.transactionChains.remove(id) != null) {
            LOG.debug("{}: Removed transaction chain {}", (Object)this.logContext, (Object)id);
        }
    }

    private /* synthetic */ void lambda$finishCommit$7(TransactionIdentifier txId, DataTreeCandidate candidate) {
        LOG.trace("{}: Transaction {} committed, proceeding to notify", (Object)this.logContext, (Object)txId);
        this.notifyListeners(candidate);
        this.processNextPending();
    }

    private static final class CommitEntry {
        final SimpleShardDataTreeCohort cohort;
        long lastAccess;

        CommitEntry(SimpleShardDataTreeCohort cohort, long now) {
            this.cohort = Objects.requireNonNull(cohort);
            this.lastAccess = now;
        }

        public String toString() {
            return "CommitEntry [tx=" + String.valueOf(this.cohort.transactionId()) + ", state=" + String.valueOf((Object)this.cohort.getState()) + "]";
        }
    }
}

