/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.databroker;

import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import org.checkerframework.checker.lock.qual.GuardedBy;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;
import org.opendaylight.controller.cluster.databroker.ClientBackedReadTransaction;
import org.opendaylight.controller.cluster.databroker.ClientBackedReadWriteTransaction;
import org.opendaylight.controller.cluster.databroker.ClientBackedWriteTransaction;
import org.opendaylight.controller.cluster.databroker.actors.dds.AbstractClientHandle;
import org.opendaylight.controller.cluster.databroker.actors.dds.ClientLocalHistory;
import org.opendaylight.controller.cluster.databroker.actors.dds.ClientSnapshot;
import org.opendaylight.controller.cluster.databroker.actors.dds.ClientTransaction;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreReadTransaction;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreReadWriteTransaction;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreTransactionChain;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreWriteTransaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ClientBackedTransactionChain
implements DOMStoreTransactionChain {
    private static final Logger LOG = LoggerFactory.getLogger(ClientBackedTransactionChain.class);
    private final @GuardedBy(value={"this"}) Map<AbstractClientHandle<?>, Boolean> openSnapshots = new WeakHashMap();
    private final ClientLocalHistory history;
    private final boolean debugAllocation;

    ClientBackedTransactionChain(ClientLocalHistory history, boolean debugAllocation) {
        this.history = Objects.requireNonNull(history);
        this.debugAllocation = debugAllocation;
    }

    public DOMStoreReadTransaction newReadOnlyTransaction() {
        return new ClientBackedReadTransaction(this.createSnapshot(), this, this.allocationContext());
    }

    public DOMStoreReadWriteTransaction newReadWriteTransaction() {
        return new ClientBackedReadWriteTransaction(this.createTransaction(), this.allocationContext());
    }

    public DOMStoreWriteTransaction newWriteOnlyTransaction() {
        return new ClientBackedWriteTransaction(this.createTransaction(), this.allocationContext());
    }

    public synchronized void close() {
        ArrayList<TransactionIdentifier> abortedSnapshots = new ArrayList<TransactionIdentifier>();
        for (AbstractClientHandle<?> snap : this.openSnapshots.keySet()) {
            TransactionIdentifier id = snap.getIdentifier();
            LOG.debug("Aborting recorded transaction {}", (Object)id);
            if (!snap.abort()) continue;
            abortedSnapshots.add(id);
        }
        this.openSnapshots.clear();
        if (!abortedSnapshots.isEmpty()) {
            LOG.warn("Aborted unclosed transactions {}", abortedSnapshots, (Object)new Throwable("at"));
        }
        this.history.close();
    }

    synchronized void snapshotClosed(ClientSnapshot clientTransaction) {
        this.openSnapshots.remove(clientTransaction);
    }

    private ClientSnapshot createSnapshot() {
        return this.recordSnapshot(this.history.takeSnapshot());
    }

    private ClientTransaction createTransaction() {
        return this.recordSnapshot(this.history.createTransaction());
    }

    private Throwable allocationContext() {
        return this.debugAllocation ? new Throwable("allocated at") : null;
    }

    private synchronized <T extends AbstractClientHandle<?>> T recordSnapshot(T snapshot) {
        this.openSnapshots.put(snapshot, Boolean.TRUE);
        return snapshot;
    }
}

