/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.databroker.actors.dds;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.util.concurrent.AbstractFuture;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.checkerframework.checker.lock.qual.GuardedBy;
import org.checkerframework.checker.lock.qual.Holding;

class VotingFuture<T>
extends AbstractFuture<T> {
    private static final AtomicIntegerFieldUpdater<VotingFuture> VOTES_UPDATER = AtomicIntegerFieldUpdater.newUpdater(VotingFuture.class, "neededVotes");
    private final T result;
    private final @GuardedBy(value={"failures"}) Collection<Throwable> failures = new ArrayList<Throwable>(0);
    private volatile int neededVotes;

    VotingFuture(T result, int requiredVotes) {
        Preconditions.checkArgument((requiredVotes > 0 ? 1 : 0) != 0);
        this.neededVotes = requiredVotes;
        this.result = result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void voteYes() {
        if (this.castVote()) {
            Collection<Throwable> collection = this.failures;
            synchronized (collection) {
                this.resolveResult();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void voteNo(Throwable cause) {
        Collection<Throwable> collection = this.failures;
        synchronized (collection) {
            this.failures.add(cause);
            if (this.castVote()) {
                this.resolveResult();
            }
        }
    }

    private boolean castVote() {
        int votes = VOTES_UPDATER.decrementAndGet(this);
        Verify.verify((votes >= 0 ? 1 : 0) != 0);
        return votes == 0;
    }

    @Holding(value={"failures"})
    private void resolveResult() {
        Iterator<Throwable> it = this.failures.iterator();
        if (!it.hasNext()) {
            this.set(this.result);
            return;
        }
        Throwable t = it.next();
        while (it.hasNext()) {
            t.addSuppressed(it.next());
        }
        this.setException(t);
    }
}

