/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import akka.actor.Props;
import java.util.Objects;
import org.opendaylight.controller.cluster.common.actor.AbstractUntypedActor;
import org.opendaylight.controller.cluster.datastore.messages.DataTreeChanged;
import org.opendaylight.controller.cluster.datastore.messages.DataTreeChangedReply;
import org.opendaylight.controller.cluster.datastore.messages.DataTreeListenerInfo;
import org.opendaylight.controller.cluster.datastore.messages.EnableNotification;
import org.opendaylight.controller.cluster.datastore.messages.GetInfo;
import org.opendaylight.controller.cluster.datastore.messages.OnInitialData;
import org.opendaylight.mdsal.dom.api.DOMDataTreeChangeListener;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;

class DataTreeChangeListenerActor
extends AbstractUntypedActor {
    private final DOMDataTreeChangeListener listener;
    private final YangInstanceIdentifier registeredPath;
    private boolean notificationsEnabled = false;
    private long notificationCount;
    private String logContext = "";

    DataTreeChangeListenerActor(DOMDataTreeChangeListener listener, YangInstanceIdentifier registeredPath) {
        this.listener = Objects.requireNonNull(listener);
        this.registeredPath = Objects.requireNonNull(registeredPath);
    }

    protected final void handleReceive(Object message) {
        if (message instanceof DataTreeChanged) {
            this.dataTreeChanged((DataTreeChanged)message);
        } else if (message instanceof OnInitialData) {
            this.onInitialData((OnInitialData)message);
        } else if (message instanceof EnableNotification) {
            this.enableNotification((EnableNotification)message);
        } else if (message instanceof GetInfo) {
            this.getSender().tell((Object)new DataTreeListenerInfo(this.listener.toString(), this.registeredPath.toString(), this.notificationsEnabled, this.notificationCount), this.getSelf());
        } else {
            this.unknownMessage(message);
        }
    }

    void onInitialData(OnInitialData message) {
        this.LOG.debug("{}: Notifying onInitialData to listener {}", (Object)this.logContext, (Object)this.listener);
        try {
            this.listener.onInitialData();
        }
        catch (Exception e) {
            this.LOG.error("{}: Error notifying listener {}", new Object[]{this.logContext, this.listener, e});
        }
    }

    void dataTreeChanged(DataTreeChanged message) {
        if (!this.notificationsEnabled) {
            this.LOG.debug("{}: Notifications not enabled for listener {} - dropping change notification", (Object)this.logContext, (Object)this.listener);
            return;
        }
        this.LOG.debug("{}: Sending {} change notification(s) {} to listener {}", new Object[]{this.logContext, message.getChanges().size(), message.getChanges(), this.listener});
        ++this.notificationCount;
        try {
            this.listener.onDataTreeChanged(message.getChanges());
        }
        catch (Exception e) {
            this.LOG.error("{}: Error notifying listener {}", new Object[]{this.logContext, this.listener, e});
        }
        if (this.getSender() != null && !this.getContext().system().deadLetters().equals((Object)this.getSender())) {
            this.getSender().tell((Object)DataTreeChangedReply.getInstance(), this.getSelf());
        }
    }

    private void enableNotification(EnableNotification message) {
        this.logContext = message.getLogContext();
        this.notificationsEnabled = message.isEnabled();
        this.LOG.debug("{}: {} notifications for listener {}", new Object[]{this.logContext, this.notificationsEnabled ? "Enabled" : "Disabled", this.listener});
    }

    static Props props(DOMDataTreeChangeListener listener, YangInstanceIdentifier registeredPath) {
        return Props.create(DataTreeChangeListenerActor.class, (Object[])new Object[]{listener, registeredPath});
    }
}

