/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import akka.actor.ActorRef;
import akka.actor.PoisonPill;
import akka.actor.Status;
import akka.util.Timeout;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;
import org.opendaylight.controller.cluster.datastore.CompositeDataTreeCohort;
import org.opendaylight.controller.cluster.datastore.DOMDataTreeCandidateTO;
import org.opendaylight.controller.cluster.datastore.DataTreeCohortActor;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.dom.api.DOMDataTreeCandidate;
import org.opendaylight.mdsal.dom.api.DOMDataTreeIdentifier;
import org.opendaylight.mdsal.dom.spi.AbstractRegistrationTree;
import org.opendaylight.mdsal.dom.spi.RegistrationTreeNode;
import org.opendaylight.mdsal.dom.spi.RegistrationTreeSnapshot;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeCandidate;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeCandidateNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.ModificationType;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DataTreeCohortActorRegistry
extends AbstractRegistrationTree<ActorRef> {
    private static final Logger LOG = LoggerFactory.getLogger(DataTreeCohortActorRegistry.class);
    private final Map<ActorRef, RegistrationTreeNode<ActorRef>> cohortToNode = new HashMap<ActorRef, RegistrationTreeNode<ActorRef>>();

    DataTreeCohortActorRegistry() {
    }

    Collection<ActorRef> getCohortActors() {
        return new ArrayList<ActorRef>(this.cohortToNode.keySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerCohort(ActorRef sender, RegisterCohort cohort) {
        this.takeLock();
        try {
            ActorRef cohortRef = cohort.getCohort();
            RegistrationTreeNode node = this.findNodeFor(cohort.getPath().getRootIdentifier().getPathArguments());
            this.addRegistration(node, cohort.getCohort());
            this.cohortToNode.put(cohortRef, (RegistrationTreeNode<ActorRef>)node);
        }
        catch (Exception e) {
            sender.tell((Object)new Status.Failure((Throwable)e), ActorRef.noSender());
            return;
        }
        finally {
            this.releaseLock();
        }
        sender.tell((Object)new Status.Success(null), ActorRef.noSender());
    }

    void removeCommitCohort(ActorRef sender, RemoveCohort message) {
        ActorRef cohort = message.getCohort();
        RegistrationTreeNode<ActorRef> node = this.cohortToNode.get(cohort);
        if (node != null) {
            this.removeRegistration(node, cohort);
            this.cohortToNode.remove(cohort);
        }
        sender.tell((Object)new Status.Success(null), ActorRef.noSender());
        cohort.tell((Object)PoisonPill.getInstance(), cohort);
    }

    List<DataTreeCohortActor.CanCommit> createCanCommitMessages(TransactionIdentifier txId, DataTreeCandidate candidate, SchemaContext schema) {
        try (RegistrationTreeSnapshot cohorts = this.takeSnapshot();){
            List<DataTreeCohortActor.CanCommit> list = new CanCommitMessageBuilder(txId, candidate, schema).perform((RegistrationTreeNode<ActorRef>)cohorts.getRootNode());
            return list;
        }
    }

    void process(ActorRef sender, CohortRegistryCommand message) {
        if (message instanceof RegisterCohort) {
            this.registerCohort(sender, (RegisterCohort)message);
        } else if (message instanceof RemoveCohort) {
            this.removeCommitCohort(sender, (RemoveCohort)message);
        }
    }

    CompositeDataTreeCohort createCohort(SchemaContext schemaContext, TransactionIdentifier txId, Executor callbackExecutor, Timeout commitStepTimeout) {
        return new CompositeDataTreeCohort(this, txId, schemaContext, callbackExecutor, commitStepTimeout);
    }

    private static class CanCommitMessageBuilder {
        private final Multimap<ActorRef, DOMDataTreeCandidate> actorToCandidates = ArrayListMultimap.create();
        private final TransactionIdentifier txId;
        private final DataTreeCandidate candidate;
        private final SchemaContext schema;

        CanCommitMessageBuilder(TransactionIdentifier txId, DataTreeCandidate candidate, SchemaContext schema) {
            this.txId = Objects.requireNonNull(txId);
            this.candidate = Objects.requireNonNull(candidate);
            this.schema = schema;
        }

        private void lookupAndCreateCanCommits(List<YangInstanceIdentifier.PathArgument> args, int offset, RegistrationTreeNode<ActorRef> node) {
            if (args.size() != offset) {
                YangInstanceIdentifier.PathArgument arg = args.get(offset);
                RegistrationTreeNode exactChild = node.getExactChild(arg);
                if (exactChild != null) {
                    this.lookupAndCreateCanCommits(args, offset + 1, (RegistrationTreeNode<ActorRef>)exactChild);
                }
                for (RegistrationTreeNode c : node.getInexactChildren(arg)) {
                    this.lookupAndCreateCanCommits(args, offset + 1, (RegistrationTreeNode<ActorRef>)c);
                }
            } else {
                this.lookupAndCreateCanCommits(this.candidate.getRootPath(), node, this.candidate.getRootNode());
            }
        }

        private void lookupAndCreateCanCommits(YangInstanceIdentifier path, RegistrationTreeNode<ActorRef> regNode, DataTreeCandidateNode candNode) {
            if (candNode.getModificationType() == ModificationType.UNMODIFIED) {
                LOG.debug("Skipping unmodified candidate {}", (Object)path);
                return;
            }
            Collection regs = regNode.getRegistrations();
            if (!regs.isEmpty()) {
                this.createCanCommits(regs, path, candNode);
            }
            for (DataTreeCandidateNode candChild : candNode.getChildNodes()) {
                if (candChild.getModificationType() == ModificationType.UNMODIFIED) continue;
                RegistrationTreeNode regChild = regNode.getExactChild(candChild.getIdentifier());
                if (regChild != null) {
                    this.lookupAndCreateCanCommits(path.node(candChild.getIdentifier()), (RegistrationTreeNode<ActorRef>)regChild, candChild);
                }
                for (RegistrationTreeNode rc : regNode.getInexactChildren(candChild.getIdentifier())) {
                    this.lookupAndCreateCanCommits(path.node(candChild.getIdentifier()), (RegistrationTreeNode<ActorRef>)rc, candChild);
                }
            }
        }

        private void createCanCommits(Collection<ActorRef> regs, YangInstanceIdentifier path, DataTreeCandidateNode node) {
            DOMDataTreeCandidate domCandidate = DOMDataTreeCandidateTO.create(CanCommitMessageBuilder.treeIdentifier(path), node);
            for (ActorRef reg : regs) {
                this.actorToCandidates.put((Object)reg, (Object)domCandidate);
            }
        }

        private static DOMDataTreeIdentifier treeIdentifier(YangInstanceIdentifier path) {
            return new DOMDataTreeIdentifier(LogicalDatastoreType.CONFIGURATION, path);
        }

        List<DataTreeCohortActor.CanCommit> perform(RegistrationTreeNode<ActorRef> rootNode) {
            List toLookup = this.candidate.getRootPath().getPathArguments();
            this.lookupAndCreateCanCommits(toLookup, 0, rootNode);
            Map mapView = this.actorToCandidates.asMap();
            ArrayList<DataTreeCohortActor.CanCommit> messages = new ArrayList<DataTreeCohortActor.CanCommit>(mapView.size());
            for (Map.Entry entry : mapView.entrySet()) {
                messages.add(new DataTreeCohortActor.CanCommit(this.txId, (Collection)entry.getValue(), this.schema, (ActorRef)entry.getKey()));
            }
            return messages;
        }
    }

    static class RemoveCohort
    extends CohortRegistryCommand {
        RemoveCohort(ActorRef cohort) {
            super(cohort);
        }
    }

    static class RegisterCohort
    extends CohortRegistryCommand {
        private final DOMDataTreeIdentifier path;

        RegisterCohort(DOMDataTreeIdentifier path, ActorRef cohort) {
            super(cohort);
            this.path = path;
        }

        public DOMDataTreeIdentifier getPath() {
            return this.path;
        }
    }

    static abstract class CohortRegistryCommand {
        private final ActorRef cohort;

        CohortRegistryCommand(ActorRef cohort) {
            this.cohort = Objects.requireNonNull(cohort);
        }

        ActorRef getCohort() {
            return this.cohort;
        }
    }
}

