/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import com.google.common.annotations.VisibleForTesting;
import java.util.Objects;
import org.opendaylight.controller.cluster.datastore.DatastoreContext;
import org.opendaylight.controller.cluster.datastore.DatastoreContextIntrospector;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingNormalizedNodeSerializer;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;

public class DatastoreContextIntrospectorFactory {
    private final BindingNormalizedNodeSerializer serializer;

    public DatastoreContextIntrospectorFactory(BindingNormalizedNodeSerializer serializer) {
        this.serializer = Objects.requireNonNull(serializer);
    }

    public DatastoreContextIntrospector newInstance(LogicalDatastoreType datastoreType) {
        return this.newInstance(DatastoreContext.newBuilder().logicalStoreType(datastoreType).tempFileDirectory("./data").build());
    }

    @VisibleForTesting
    DatastoreContextIntrospector newInstance(DatastoreContext context) {
        return new DatastoreContextIntrospector(context, this.serializer);
    }
}

