/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import akka.actor.ActorSystem;
import org.opendaylight.controller.cluster.ActorSystemProvider;
import org.opendaylight.controller.cluster.databroker.ClientBackedDataStore;
import org.opendaylight.controller.cluster.datastore.AbstractDataStore;
import org.opendaylight.controller.cluster.datastore.ClusterWrapperImpl;
import org.opendaylight.controller.cluster.datastore.DatastoreContext;
import org.opendaylight.controller.cluster.datastore.DatastoreContextFactory;
import org.opendaylight.controller.cluster.datastore.DatastoreContextIntrospector;
import org.opendaylight.controller.cluster.datastore.DatastoreContextPropertiesUpdater;
import org.opendaylight.controller.cluster.datastore.DatastoreSnapshotRestore;
import org.opendaylight.controller.cluster.datastore.DistributedDataStore;
import org.opendaylight.controller.cluster.datastore.config.Configuration;
import org.opendaylight.controller.cluster.datastore.config.ConfigurationImpl;
import org.opendaylight.controller.cluster.datastore.persisted.DatastoreSnapshot;
import org.opendaylight.mdsal.dom.api.DOMSchemaService;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContextListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DistributedDataStoreFactory {
    private static final Logger LOG = LoggerFactory.getLogger(DistributedDataStoreFactory.class);
    private static final String DEFAULT_MODULE_SHARDS_PATH = "./configuration/initial/module-shards.conf";
    private static final String DEFAULT_MODULES_PATH = "./configuration/initial/modules.conf";

    private DistributedDataStoreFactory() {
    }

    public static AbstractDataStore createInstance(DOMSchemaService schemaService, DatastoreContext initialDatastoreContext, DatastoreSnapshotRestore datastoreSnapshotRestore, ActorSystemProvider actorSystemProvider, DatastoreContextIntrospector introspector, DatastoreContextPropertiesUpdater updater) {
        return DistributedDataStoreFactory.createInstance(schemaService, initialDatastoreContext, datastoreSnapshotRestore, actorSystemProvider, introspector, updater, null);
    }

    public static AbstractDataStore createInstance(DOMSchemaService schemaService, DatastoreContext initialDatastoreContext, DatastoreSnapshotRestore datastoreSnapshotRestore, ActorSystemProvider actorSystemProvider, DatastoreContextIntrospector introspector, DatastoreContextPropertiesUpdater updater, Configuration orgConfig) {
        AbstractDataStore dataStore;
        String datastoreName = initialDatastoreContext.getDataStoreName();
        LOG.info("Create data store instance of type : {}", (Object)datastoreName);
        ActorSystem actorSystem = actorSystemProvider.getActorSystem();
        DatastoreSnapshot restoreFromSnapshot = datastoreSnapshotRestore.getAndRemove(datastoreName);
        Configuration config = orgConfig == null ? new ConfigurationImpl(DEFAULT_MODULE_SHARDS_PATH, DEFAULT_MODULES_PATH) : orgConfig;
        ClusterWrapperImpl clusterWrapper = new ClusterWrapperImpl(actorSystem);
        DatastoreContextFactory contextFactory = introspector.newContextFactory();
        DatastoreContext datastoreContext = contextFactory.getBaseDatastoreContext();
        if (datastoreContext.isUseTellBasedProtocol()) {
            dataStore = new ClientBackedDataStore(actorSystem, clusterWrapper, config, contextFactory, restoreFromSnapshot);
            LOG.info("Data store {} is using tell-based protocol", (Object)datastoreName);
        } else {
            dataStore = new DistributedDataStore(actorSystem, clusterWrapper, config, contextFactory, restoreFromSnapshot);
            LOG.info("Data store {} is using ask-based protocol", (Object)datastoreName);
        }
        updater.setListener(dataStore);
        schemaService.registerSchemaContextListener((EffectiveModelContextListener)dataStore);
        dataStore.setCloseable(updater);
        dataStore.waitTillReady();
        return dataStore;
    }
}

