/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import akka.actor.ActorSelection;
import akka.dispatch.Futures;
import akka.dispatch.OnComplete;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.SettableFuture;
import java.util.Objects;
import java.util.Optional;
import java.util.SortedSet;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;
import org.opendaylight.controller.cluster.datastore.AbstractTransactionContext;
import org.opendaylight.controller.cluster.datastore.OperationLimiter;
import org.opendaylight.controller.cluster.datastore.TransactionContextCleanup;
import org.opendaylight.controller.cluster.datastore.TransactionReadyReplyMapper;
import org.opendaylight.controller.cluster.datastore.messages.AbstractRead;
import org.opendaylight.controller.cluster.datastore.messages.BatchedModifications;
import org.opendaylight.controller.cluster.datastore.messages.CloseTransaction;
import org.opendaylight.controller.cluster.datastore.modification.AbstractModification;
import org.opendaylight.controller.cluster.datastore.modification.Modification;
import org.opendaylight.controller.cluster.datastore.utils.ActorUtils;
import org.opendaylight.mdsal.common.api.ReadFailedException;
import org.opendaylight.yangtools.yang.common.RpcError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.concurrent.Future;

public class RemoteTransactionContext
extends AbstractTransactionContext {
    private static final Logger LOG = LoggerFactory.getLogger(RemoteTransactionContext.class);
    private final ActorUtils actorUtils;
    private final ActorSelection actor;
    private final OperationLimiter limiter;
    private BatchedModifications batchedModifications;
    private int totalBatchedModificationsSent;
    private int batchPermits;
    private volatile Throwable failedModification;

    protected RemoteTransactionContext(TransactionIdentifier identifier, ActorSelection actor, ActorUtils actorUtils, short remoteTransactionVersion, OperationLimiter limiter) {
        super(identifier, remoteTransactionVersion);
        this.limiter = Objects.requireNonNull(limiter);
        this.actor = actor;
        this.actorUtils = actorUtils;
    }

    private ActorSelection getActor() {
        return this.actor;
    }

    protected ActorUtils getActorUtils() {
        return this.actorUtils;
    }

    @Override
    public void closeTransaction() {
        LOG.debug("Tx {} closeTransaction called", (Object)this.getIdentifier());
        TransactionContextCleanup.untrack(this);
        this.actorUtils.sendOperationAsync(this.getActor(), new CloseTransaction(this.getTransactionVersion()).toSerializable());
    }

    @Override
    public Future<Object> directCommit(Boolean havePermit) {
        LOG.debug("Tx {} directCommit called", (Object)this.getIdentifier());
        this.bumpPermits(havePermit);
        return this.sendBatchedModifications(true, true, Optional.empty());
    }

    @Override
    public Future<ActorSelection> readyTransaction(Boolean havePermit, Optional<SortedSet<String>> participatingShardNames) {
        this.logModificationCount();
        LOG.debug("Tx {} readyTransaction called", (Object)this.getIdentifier());
        this.bumpPermits(havePermit);
        Future<Object> lastModificationsFuture = this.sendBatchedModifications(true, false, participatingShardNames);
        return this.transformReadyReply(lastModificationsFuture);
    }

    private void bumpPermits(Boolean havePermit) {
        if (Boolean.TRUE.equals(havePermit)) {
            ++this.batchPermits;
        }
    }

    protected Future<ActorSelection> transformReadyReply(Future<Object> readyReplyFuture) {
        return TransactionReadyReplyMapper.transform(readyReplyFuture, this.actorUtils, this.getIdentifier());
    }

    private BatchedModifications newBatchedModifications() {
        return new BatchedModifications(this.getIdentifier(), this.getTransactionVersion());
    }

    private void batchModification(Modification modification, boolean havePermit) {
        this.incrementModificationCount();
        if (havePermit) {
            ++this.batchPermits;
        }
        if (this.batchedModifications == null) {
            this.batchedModifications = this.newBatchedModifications();
        }
        this.batchedModifications.addModification(modification);
        if (this.batchedModifications.getModifications().size() >= this.actorUtils.getDatastoreContext().getShardBatchedModificationCount()) {
            this.sendBatchedModifications();
        }
    }

    protected Future<Object> sendBatchedModifications() {
        return this.sendBatchedModifications(false, false, Optional.empty());
    }

    protected Future<Object> sendBatchedModifications(boolean ready, boolean doCommitOnReady, Optional<SortedSet<String>> participatingShardNames) {
        Future<Object> sent = null;
        if (ready || this.batchedModifications != null && !this.batchedModifications.getModifications().isEmpty()) {
            if (this.batchedModifications == null) {
                this.batchedModifications = this.newBatchedModifications();
            }
            LOG.debug("Tx {} sending {} batched modifications, ready: {}", new Object[]{this.getIdentifier(), this.batchedModifications.getModifications().size(), ready});
            this.batchedModifications.setDoCommitOnReady(doCommitOnReady);
            this.batchedModifications.setTotalMessagesSent(++this.totalBatchedModificationsSent);
            BatchedModifications toSend = this.batchedModifications;
            final int permitsToRelease = this.batchPermits;
            this.batchPermits = 0;
            if (ready) {
                this.batchedModifications.setReady(participatingShardNames);
                this.batchedModifications.setDoCommitOnReady(doCommitOnReady);
                this.batchedModifications = null;
            } else {
                this.batchedModifications = this.newBatchedModifications();
                Throwable failure = this.failedModification;
                if (failure != null) {
                    LOG.debug("Tx {} modifications previously failed, not sending a non-ready batch", (Object)this.getIdentifier());
                    this.limiter.release(permitsToRelease);
                    return Futures.failed((Throwable)failure);
                }
            }
            sent = this.actorUtils.executeOperationAsync(this.getActor(), toSend.toSerializable(), this.actorUtils.getTransactionCommitOperationTimeout());
            sent.onComplete((Function1)new OnComplete<Object>(){

                public void onComplete(Throwable failure, Object success) {
                    if (failure != null) {
                        LOG.debug("Tx {} modifications failed", (Object)RemoteTransactionContext.this.getIdentifier(), (Object)failure);
                        RemoteTransactionContext.this.failedModification = failure;
                    } else {
                        LOG.debug("Tx {} modifications completed with {}", (Object)RemoteTransactionContext.this.getIdentifier(), success);
                    }
                    RemoteTransactionContext.this.limiter.release(permitsToRelease);
                }
            }, this.actorUtils.getClientDispatcher());
        }
        return sent;
    }

    @Override
    public void executeModification(AbstractModification modification, Boolean havePermit) {
        LOG.debug("Tx {} executeModification {} called path = {}", new Object[]{this.getIdentifier(), modification.getClass().getSimpleName(), modification.getPath()});
        boolean permitToRelease = havePermit == null ? this.failedModification == null && this.acquireOperation() : havePermit;
        this.batchModification(modification, permitToRelease);
    }

    @Override
    public <T> void executeRead(final AbstractRead<T> readCmd, final SettableFuture<T> returnFuture, Boolean havePermit) {
        LOG.debug("Tx {} executeRead {} called path = {}", new Object[]{this.getIdentifier(), readCmd.getClass().getSimpleName(), readCmd.getPath()});
        Throwable failure = this.failedModification;
        if (failure != null) {
            returnFuture.setException((Throwable)new ReadFailedException("Previous modification failed, cannot " + readCmd.getClass().getSimpleName() + " for path " + readCmd.getPath(), failure, new RpcError[0]));
            return;
        }
        final boolean permitToRelease = havePermit == null ? this.acquireOperation() : havePermit.booleanValue();
        this.sendBatchedModifications();
        OnComplete<Object> onComplete = new OnComplete<Object>(){

            public void onComplete(Throwable failure, Object response) {
                if (permitToRelease) {
                    RemoteTransactionContext.this.limiter.release();
                }
                if (failure != null) {
                    LOG.debug("Tx {} {} operation failed", new Object[]{RemoteTransactionContext.this.getIdentifier(), readCmd.getClass().getSimpleName(), failure});
                    returnFuture.setException((Throwable)new ReadFailedException("Error checking " + readCmd.getClass().getSimpleName() + " for path " + readCmd.getPath(), failure, new RpcError[0]));
                } else {
                    LOG.debug("Tx {} {} operation succeeded", (Object)RemoteTransactionContext.this.getIdentifier(), (Object)readCmd.getClass().getSimpleName());
                    readCmd.processResponse(response, returnFuture);
                }
            }
        };
        Future<Object> future = this.actorUtils.executeOperationAsync(this.getActor(), readCmd.asVersion(this.getTransactionVersion()).toSerializable(), this.actorUtils.getOperationTimeout());
        future.onComplete((Function1)onComplete, this.actorUtils.getClientDispatcher());
    }

    private boolean acquireOperation() {
        Preconditions.checkState((boolean)this.isOperationHandOffComplete(), (String)"Attempted to acquire execute operation permit for transaction %s on actor %s during handoff", (Object)this.getIdentifier(), (Object)this.actor);
        if (this.limiter.acquire()) {
            return true;
        }
        LOG.warn("Failed to acquire execute operation permit for transaction {} on actor {}", (Object)this.getIdentifier(), (Object)this.actor);
        return false;
    }

    @Override
    public boolean usesOperationLimiting() {
        return true;
    }
}

