/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import akka.actor.ActorSelection;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicLong;
import org.opendaylight.controller.cluster.access.concepts.ClientIdentifier;
import org.opendaylight.controller.cluster.access.concepts.LocalHistoryIdentifier;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;
import org.opendaylight.controller.cluster.datastore.AbstractTransactionContextFactory;
import org.opendaylight.controller.cluster.datastore.LocalTransactionFactoryImpl;
import org.opendaylight.controller.cluster.datastore.TransactionChainProxy;
import org.opendaylight.controller.cluster.datastore.messages.PrimaryShardInfo;
import org.opendaylight.controller.cluster.datastore.utils.ActorUtils;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreTransactionChain;
import org.opendaylight.yangtools.yang.data.api.schema.tree.ReadOnlyDataTree;
import scala.concurrent.Future;

final class TransactionContextFactory
extends AbstractTransactionContextFactory<LocalTransactionFactoryImpl> {
    private final AtomicLong nextHistory = new AtomicLong(1L);

    TransactionContextFactory(ActorUtils actorUtils, ClientIdentifier clientId) {
        super(actorUtils, new LocalHistoryIdentifier(clientId, 0L));
    }

    @Override
    public void close() {
    }

    @Override
    protected LocalTransactionFactoryImpl factoryForShard(String shardName, ActorSelection shardLeader, ReadOnlyDataTree dataTree) {
        return new LocalTransactionFactoryImpl(this.getActorUtils(), shardLeader, dataTree);
    }

    @Override
    protected Future<PrimaryShardInfo> findPrimaryShard(String shardName, TransactionIdentifier txId) {
        return this.getActorUtils().findPrimaryShardAsync(shardName);
    }

    @Override
    protected <T> void onTransactionReady(TransactionIdentifier transaction, Collection<Future<T>> cohortFutures) {
    }

    DOMStoreTransactionChain createTransactionChain() {
        return new TransactionChainProxy(this, new LocalHistoryIdentifier(this.getHistoryId().getClientId(), this.nextHistory.getAndIncrement()));
    }

    @Override
    protected void onTransactionContextCreated(TransactionIdentifier transactionId) {
    }
}

