/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.config;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigObject;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.opendaylight.controller.cluster.access.concepts.MemberName;
import org.opendaylight.controller.cluster.datastore.config.Configuration;
import org.opendaylight.controller.cluster.datastore.config.ModuleConfig;
import org.opendaylight.controller.cluster.datastore.config.ModuleShardConfigProvider;
import org.opendaylight.controller.cluster.datastore.shardstrategy.ShardStrategyFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractModuleShardConfigProvider
implements ModuleShardConfigProvider {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractModuleShardConfigProvider.class);

    AbstractModuleShardConfigProvider() {
    }

    static final Config loadConfigFromPath(String configPath) {
        File configFile = new File(configPath);
        Config config = null;
        if (configFile.exists()) {
            LOG.info("Config file exists - reading config from it");
            config = ConfigFactory.parseFile((File)configFile);
        } else {
            LOG.warn("Reading Config from resource");
            config = ConfigFactory.load((String)configPath);
        }
        return config;
    }

    static final void readModulesConfig(Config modulesConfig, Map<String, ModuleConfig.Builder> moduleConfigMap, Configuration configuration) {
        for (ConfigObject o : modulesConfig.getObjectList("modules")) {
            ConfigObjectWrapper wrapper = new ConfigObjectWrapper(o);
            String moduleName = wrapper.stringValue("name");
            ModuleConfig.Builder builder = moduleConfigMap.computeIfAbsent(moduleName, ModuleConfig::builder);
            builder.nameSpace(wrapper.stringValue("namespace"));
            builder.shardStrategy(ShardStrategyFactory.newShardStrategyInstance(moduleName, wrapper.stringValue("shard-strategy"), configuration));
        }
    }

    static final Map<String, ModuleConfig.Builder> readModuleShardsConfig(Config moduleShardsConfig) {
        HashMap<String, ModuleConfig.Builder> moduleConfigMap = new HashMap<String, ModuleConfig.Builder>();
        for (ConfigObject moduleShardConfigObject : moduleShardsConfig.getObjectList("module-shards")) {
            String moduleName = moduleShardConfigObject.get((Object)"name").unwrapped().toString();
            ModuleConfig.Builder builder = ModuleConfig.builder(moduleName);
            for (ConfigObject shard : moduleShardConfigObject.toConfig().getObjectList("shards")) {
                String shardName = shard.get((Object)"name").unwrapped().toString();
                List<MemberName> replicas = shard.toConfig().getStringList("replicas").stream().map(MemberName::forName).collect(Collectors.toList());
                builder.shardConfig(shardName, replicas);
            }
            moduleConfigMap.put(moduleName, builder);
        }
        return moduleConfigMap;
    }

    private static final class ConfigObjectWrapper {
        private final ConfigObject configObject;

        ConfigObjectWrapper(ConfigObject configObject) {
            this.configObject = Objects.requireNonNull(configObject);
        }

        String stringValue(String name) {
            return this.configObject.get((Object)name).unwrapped().toString();
        }
    }
}

