/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.config;

import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.controller.cluster.access.concepts.MemberName;
import org.opendaylight.controller.cluster.datastore.config.ShardConfig;
import org.opendaylight.controller.cluster.datastore.shardstrategy.ShardStrategy;

public final class ModuleConfig {
    private final String name;
    private final String namespace;
    private final ShardStrategy shardStrategy;
    private final Map<String, ShardConfig> shardConfigs;

    ModuleConfig(String name, String namespace, ShardStrategy shardStrategy, Map<String, ShardConfig> shardConfigs) {
        this.name = Objects.requireNonNull(name);
        this.namespace = namespace;
        this.shardStrategy = shardStrategy;
        this.shardConfigs = shardConfigs;
    }

    public @NonNull String getName() {
        return this.name;
    }

    public @Nullable String getNamespace() {
        return this.namespace;
    }

    public @Nullable ShardStrategy getShardStrategy() {
        return this.shardStrategy;
    }

    public @Nullable ShardConfig getShardConfig(String forName) {
        return this.shardConfigs.get(forName);
    }

    public @NonNull Collection<ShardConfig> getShardConfigs() {
        return this.shardConfigs.values();
    }

    public @NonNull Collection<String> getShardNames() {
        return this.shardConfigs.keySet();
    }

    public static Builder builder(String name) {
        return new Builder(name);
    }

    public static Builder builder(ModuleConfig moduleConfig) {
        return new Builder(moduleConfig);
    }

    public static final class Builder {
        private String name;
        private String nameSpace;
        private ShardStrategy shardStrategy;
        private final Map<String, ShardConfig> shardConfigs = new HashMap<String, ShardConfig>();

        Builder(String name) {
            this.name = name;
        }

        private Builder(ModuleConfig moduleConfig) {
            this.name = moduleConfig.getName();
            this.nameSpace = moduleConfig.getNamespace();
            this.shardStrategy = moduleConfig.getShardStrategy();
            for (ShardConfig shardConfig : moduleConfig.getShardConfigs()) {
                this.shardConfigs.put(shardConfig.getName(), shardConfig);
            }
        }

        public Builder name(String newName) {
            this.name = newName;
            return this;
        }

        public Builder nameSpace(String newNameSpace) {
            this.nameSpace = newNameSpace;
            return this;
        }

        public Builder shardStrategy(ShardStrategy newShardStrategy) {
            this.shardStrategy = newShardStrategy;
            return this;
        }

        public Builder shardConfig(String shardName, Collection<MemberName> replicas) {
            this.shardConfigs.put(shardName, new ShardConfig(shardName, replicas));
            return this;
        }

        public ModuleConfig build() {
            return new ModuleConfig(this.name, this.nameSpace, this.shardStrategy, (Map<String, ShardConfig>)ImmutableMap.copyOf(this.shardConfigs));
        }
    }
}

