/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.jmx.mbeans.shard;

import akka.actor.ActorRef;
import com.google.common.base.Joiner;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.checkerframework.checker.lock.qual.GuardedBy;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.controller.cluster.datastore.Shard;
import org.opendaylight.controller.cluster.datastore.jmx.mbeans.shard.OnDemandShardStateCache;
import org.opendaylight.controller.cluster.datastore.jmx.mbeans.shard.ShardStatsMXBean;
import org.opendaylight.controller.cluster.datastore.messages.OnDemandShardState;
import org.opendaylight.controller.cluster.raft.base.messages.InitiateCaptureSnapshot;
import org.opendaylight.controller.cluster.raft.client.messages.FollowerInfo;
import org.opendaylight.controller.cluster.raft.client.messages.OnDemandRaftState;
import org.opendaylight.controller.md.sal.common.util.jmx.AbstractMXBean;

public class ShardStats
extends AbstractMXBean
implements ShardStatsMXBean {
    public static final String JMX_CATEGORY_SHARD = "Shards";
    private static final @GuardedBy(value={"DATE_FORMAT"}) SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    private static final Joiner.MapJoiner MAP_JOINER = Joiner.on((String)", ").withKeyValueSeparator(": ");
    private final Shard shard;
    private final OnDemandShardStateCache stateCache;
    private long committedTransactionsCount;
    private long readOnlyTransactionCount;
    private long readWriteTransactionCount;
    private long lastCommittedTransactionTime;
    private long failedTransactionsCount;
    private final AtomicLong failedReadTransactionsCount = new AtomicLong();
    private long abortTransactionsCount;
    private boolean followerInitialSyncStatus = false;
    private String statRetrievalError;
    private long leadershipChangeCount;
    private long lastLeadershipChangeTime;

    public ShardStats(String shardName, String mxBeanType, @Nullable Shard shard) {
        super(shardName, mxBeanType, JMX_CATEGORY_SHARD);
        this.shard = shard;
        this.stateCache = new OnDemandShardStateCache(shardName, shard != null ? shard.self() : null);
    }

    private OnDemandRaftState getOnDemandRaftState() {
        try {
            OnDemandShardState state = this.stateCache.get();
            this.statRetrievalError = null;
            return state;
        }
        catch (Exception e) {
            this.statRetrievalError = e.getCause().toString();
            return OnDemandRaftState.builder().build();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String formatMillis(long timeMillis) {
        SimpleDateFormat simpleDateFormat = DATE_FORMAT;
        synchronized (simpleDateFormat) {
            return DATE_FORMAT.format(new Date(timeMillis));
        }
    }

    @Override
    public String getShardName() {
        return this.getMBeanName();
    }

    @Override
    public long getCommittedTransactionsCount() {
        return this.committedTransactionsCount;
    }

    @Override
    public String getLeader() {
        return this.getOnDemandRaftState().getLeader();
    }

    @Override
    public String getRaftState() {
        return this.getOnDemandRaftState().getRaftState();
    }

    @Override
    public long getReadOnlyTransactionCount() {
        return this.readOnlyTransactionCount;
    }

    @Override
    public long getReadWriteTransactionCount() {
        return this.readWriteTransactionCount;
    }

    @Override
    public long getLastLogIndex() {
        return this.getOnDemandRaftState().getLastLogIndex();
    }

    @Override
    public long getLastLogTerm() {
        return this.getOnDemandRaftState().getLastLogTerm();
    }

    @Override
    public long getCurrentTerm() {
        return this.getOnDemandRaftState().getCurrentTerm();
    }

    @Override
    public long getCommitIndex() {
        return this.getOnDemandRaftState().getCommitIndex();
    }

    @Override
    public long getLastApplied() {
        return this.getOnDemandRaftState().getLastApplied();
    }

    @Override
    public long getLastIndex() {
        return this.getOnDemandRaftState().getLastIndex();
    }

    @Override
    public long getLastTerm() {
        return this.getOnDemandRaftState().getLastTerm();
    }

    @Override
    public long getSnapshotIndex() {
        return this.getOnDemandRaftState().getSnapshotIndex();
    }

    @Override
    public long getSnapshotTerm() {
        return this.getOnDemandRaftState().getSnapshotTerm();
    }

    @Override
    public long getReplicatedToAllIndex() {
        return this.getOnDemandRaftState().getReplicatedToAllIndex();
    }

    @Override
    public String getVotedFor() {
        return this.getOnDemandRaftState().getVotedFor();
    }

    @Override
    public boolean isVoting() {
        return this.getOnDemandRaftState().isVoting();
    }

    @Override
    public String getPeerVotingStates() {
        return MAP_JOINER.join(this.getOnDemandRaftState().getPeerVotingStates());
    }

    @Override
    public boolean isSnapshotCaptureInitiated() {
        return this.getOnDemandRaftState().isSnapshotCaptureInitiated();
    }

    @Override
    public String getLastCommittedTransactionTime() {
        return ShardStats.formatMillis(this.lastCommittedTransactionTime);
    }

    @Override
    public long getFailedTransactionsCount() {
        return this.failedTransactionsCount;
    }

    @Override
    public long getFailedReadTransactionsCount() {
        return this.failedReadTransactionsCount.get();
    }

    @Override
    public long getAbortTransactionsCount() {
        return this.abortTransactionsCount;
    }

    public long incrementCommittedTransactionCount() {
        return ++this.committedTransactionsCount;
    }

    public long incrementReadOnlyTransactionCount() {
        return ++this.readOnlyTransactionCount;
    }

    public long incrementReadWriteTransactionCount() {
        return ++this.readWriteTransactionCount;
    }

    public long incrementFailedTransactionsCount() {
        return ++this.failedTransactionsCount;
    }

    public long incrementFailedReadTransactionsCount() {
        return this.failedReadTransactionsCount.incrementAndGet();
    }

    public long incrementAbortTransactionsCount() {
        return ++this.abortTransactionsCount;
    }

    public void setLastCommittedTransactionTime(long lastCommittedTransactionTime) {
        this.lastCommittedTransactionTime = lastCommittedTransactionTime;
    }

    @Override
    public long getInMemoryJournalDataSize() {
        return this.getOnDemandRaftState().getInMemoryJournalDataSize();
    }

    @Override
    public long getInMemoryJournalLogSize() {
        return this.getOnDemandRaftState().getInMemoryJournalLogSize();
    }

    @Override
    public void resetTransactionCounters() {
        this.committedTransactionsCount = 0L;
        this.readOnlyTransactionCount = 0L;
        this.readWriteTransactionCount = 0L;
        this.lastCommittedTransactionTime = 0L;
        this.failedTransactionsCount = 0L;
        this.failedReadTransactionsCount.set(0L);
        this.abortTransactionsCount = 0L;
    }

    public void setFollowerInitialSyncStatus(boolean followerInitialSyncStatus) {
        this.followerInitialSyncStatus = followerInitialSyncStatus;
    }

    @Override
    public boolean getFollowerInitialSyncStatus() {
        return this.followerInitialSyncStatus;
    }

    @Override
    public List<FollowerInfo> getFollowerInfo() {
        return this.getOnDemandRaftState().getFollowerInfoList();
    }

    @Override
    public String getPeerAddresses() {
        return MAP_JOINER.join(this.getOnDemandRaftState().getPeerAddresses());
    }

    @Override
    public String getStatRetrievalTime() {
        this.getOnDemandRaftState();
        return this.stateCache.getStatRetrievaelTime();
    }

    @Override
    public String getStatRetrievalError() {
        this.getOnDemandRaftState();
        return this.statRetrievalError;
    }

    @Override
    public long getLeadershipChangeCount() {
        return this.leadershipChangeCount;
    }

    public void incrementLeadershipChangeCount() {
        ++this.leadershipChangeCount;
        this.lastLeadershipChangeTime = System.currentTimeMillis();
    }

    @Override
    public String getLastLeadershipChangeTime() {
        return ShardStats.formatMillis(this.lastLeadershipChangeTime);
    }

    @Override
    public int getPendingTxCommitQueueSize() {
        return this.shard != null ? this.shard.getPendingTxCommitQueueSize() : -1;
    }

    @Override
    public int getTxCohortCacheSize() {
        return this.shard != null ? this.shard.getCohortCacheSize() : -1;
    }

    @Override
    public void captureSnapshot() {
        if (this.shard != null) {
            this.shard.getSelf().tell((Object)new InitiateCaptureSnapshot(), ActorRef.noSender());
        }
    }
}

