/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.messages;

import com.google.common.util.concurrent.FluentFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.opendaylight.controller.cluster.datastore.messages.VersionedExternalizableMessage;
import org.opendaylight.controller.cluster.datastore.node.utils.stream.SerializationUtils;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreReadTransaction;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.codec.binfmt.NormalizedNodeStreamVersion;

public abstract class AbstractRead<T>
extends VersionedExternalizableMessage {
    private static final long serialVersionUID = 1L;
    private YangInstanceIdentifier path;

    protected AbstractRead() {
    }

    public AbstractRead(YangInstanceIdentifier path, short version) {
        super(version);
        this.path = path;
    }

    public YangInstanceIdentifier getPath() {
        return this.path;
    }

    @Override
    public final void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.path = SerializationUtils.readPath((DataInput)in);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        SerializationUtils.writePath((DataOutput)out, (NormalizedNodeStreamVersion)this.getStreamVersion(), (YangInstanceIdentifier)this.path);
    }

    public AbstractRead<T> asVersion(short version) {
        return version == this.getVersion() ? this : this.newInstance(version);
    }

    public abstract FluentFuture<T> apply(DOMStoreReadTransaction var1);

    public abstract void processResponse(Object var1, SettableFuture<T> var2);

    protected abstract AbstractRead<T> newInstance(short var1);
}

