/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.utils;

import java.util.List;
import java.util.Optional;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTree;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeCandidate;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeCandidateTip;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeConfiguration;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeModification;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataValidationFailedException;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.InMemoryDataTreeFactory;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;

public final class NormalizedNodeAggregator {
    private final YangInstanceIdentifier rootIdentifier;
    private final List<Optional<NormalizedNode<?, ?>>> nodes;
    private final DataTree dataTree;

    private NormalizedNodeAggregator(YangInstanceIdentifier rootIdentifier, List<Optional<NormalizedNode<?, ?>>> nodes, EffectiveModelContext schemaContext, LogicalDatastoreType logicalDatastoreType) {
        this.rootIdentifier = rootIdentifier;
        this.nodes = nodes;
        this.dataTree = new InMemoryDataTreeFactory().create(logicalDatastoreType == LogicalDatastoreType.CONFIGURATION ? DataTreeConfiguration.DEFAULT_CONFIGURATION : DataTreeConfiguration.DEFAULT_OPERATIONAL);
        this.dataTree.setEffectiveModelContext(schemaContext);
    }

    public static Optional<NormalizedNode<?, ?>> aggregate(YangInstanceIdentifier rootIdentifier, List<Optional<NormalizedNode<?, ?>>> nodes, EffectiveModelContext schemaContext, LogicalDatastoreType logicalDatastoreType) throws DataValidationFailedException {
        return new NormalizedNodeAggregator(rootIdentifier, nodes, schemaContext, logicalDatastoreType).aggregate();
    }

    private Optional<NormalizedNode<?, ?>> aggregate() throws DataValidationFailedException {
        return this.combine().getRootNode();
    }

    private NormalizedNodeAggregator combine() throws DataValidationFailedException {
        DataTreeModification mod = this.dataTree.takeSnapshot().newModification();
        for (Optional<NormalizedNode<?, ?>> node : this.nodes) {
            if (!node.isPresent()) continue;
            mod.merge(this.rootIdentifier, node.get());
        }
        mod.ready();
        this.dataTree.validate(mod);
        DataTreeCandidateTip candidate = this.dataTree.prepare(mod);
        this.dataTree.commit((DataTreeCandidate)candidate);
        return this;
    }

    private Optional<NormalizedNode<?, ?>> getRootNode() {
        return this.dataTree.takeSnapshot().readNode(this.rootIdentifier);
    }
}

