/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.sharding;

import java.util.Map;
import java.util.Objects;
import org.opendaylight.controller.cluster.sharding.DistributedShardModificationContext;
import org.opendaylight.mdsal.dom.api.DOMDataTreeIdentifier;
import org.opendaylight.mdsal.dom.api.DOMDataTreeWriteCursor;
import org.opendaylight.mdsal.dom.spi.shard.ForeignShardModificationContext;
import org.opendaylight.mdsal.dom.spi.shard.WritableNodeOperation;
import org.opendaylight.mdsal.dom.spi.shard.WriteCursorStrategy;
import org.opendaylight.mdsal.dom.spi.shard.WriteableModificationNode;
import org.opendaylight.mdsal.dom.spi.shard.WriteableNodeWithSubshard;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreThreePhaseCommitCohort;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;

public class DistributedShardModification
extends WriteableNodeWithSubshard {
    private final DistributedShardModificationContext context;
    private final Map<DOMDataTreeIdentifier, ForeignShardModificationContext> childShards;

    public DistributedShardModification(DistributedShardModificationContext context, Map<YangInstanceIdentifier.PathArgument, WriteableModificationNode> subshards, Map<DOMDataTreeIdentifier, ForeignShardModificationContext> childShards) {
        super(subshards);
        this.context = Objects.requireNonNull(context);
        this.childShards = Objects.requireNonNull(childShards);
    }

    public YangInstanceIdentifier.PathArgument getIdentifier() {
        return this.context.getIdentifier().getRootIdentifier().getLastPathArgument();
    }

    public WriteCursorStrategy createOperation(DOMDataTreeWriteCursor parentCursor) {
        return new WritableNodeOperation((WriteableModificationNode)this, this.context.cursor()){

            public void exit() {
                throw new IllegalStateException("Can not exit data tree root");
            }
        };
    }

    void cursorClosed() {
        this.context.closeCursor();
    }

    DOMStoreThreePhaseCommitCohort seal() {
        this.childShards.values().stream().filter(ForeignShardModificationContext::isModified).forEach(ForeignShardModificationContext::ready);
        return this.context.ready();
    }

    DOMDataTreeIdentifier getPrefix() {
        return this.context.getIdentifier();
    }

    Map<DOMDataTreeIdentifier, ForeignShardModificationContext> getChildShards() {
        return this.childShards;
    }
}

