/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.databroker.actors.dds;

import com.google.common.base.MoreObjects;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Objects;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;
import org.opendaylight.controller.cluster.databroker.actors.dds.AbstractClientHistory;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreThreePhaseCommitCohort;

abstract class AbstractTransactionCommitCohort
implements DOMStoreThreePhaseCommitCohort {
    static final ListenableFuture<Boolean> TRUE_FUTURE = Futures.immediateFuture((Object)Boolean.TRUE);
    static final ListenableFuture<Void> VOID_FUTURE = Futures.immediateFuture(null);
    private final AbstractClientHistory parent;
    private final TransactionIdentifier txId;

    AbstractTransactionCommitCohort(AbstractClientHistory parent, TransactionIdentifier txId) {
        this.parent = Objects.requireNonNull(parent);
        this.txId = Objects.requireNonNull(txId);
    }

    final void complete() {
        this.parent.onTransactionComplete(this.txId);
    }

    public final String toString() {
        return MoreObjects.toStringHelper((Object)this).add("txId", (Object)this.txId).toString();
    }
}

