/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Primitives;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.management.ConstructorParameters;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.WordUtils;
import org.checkerframework.checker.lock.qual.GuardedBy;
import org.opendaylight.controller.cluster.datastore.DatastoreContext;
import org.opendaylight.controller.cluster.datastore.DatastoreContextFactory;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.DataStoreProperties;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.DataStorePropertiesContainer;
import org.opendaylight.yangtools.yang.common.Uint16;
import org.opendaylight.yangtools.yang.common.Uint32;
import org.opendaylight.yangtools.yang.common.Uint64;
import org.opendaylight.yangtools.yang.common.Uint8;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatastoreContextIntrospector {
    private static final Logger LOG = LoggerFactory.getLogger(DatastoreContextIntrospector.class);
    private static final Map<String, Map.Entry<Class<?>, Method>> DATA_STORE_PROP_INFO = new HashMap();
    private static final Map<Class<?>, Constructor<?>> CONSTRUCTORS = new HashMap();
    private static final Map<Class<?>, Method> YANG_TYPE_GETTERS = new HashMap();
    private static final Map<String, Method> BUILDER_SETTERS = new HashMap<String, Method>();
    private static final ImmutableMap<Class<?>, Function<String, Object>> UINT_FACTORIES = ImmutableMap.builder().put(Uint8.class, Uint8::valueOf).put(Uint16.class, Uint16::valueOf).put(Uint32.class, Uint32::valueOf).put(Uint64.class, Uint64::valueOf).build();
    private @GuardedBy(value={"this"}) DatastoreContext context;
    private @GuardedBy(value={"this"}) Map<String, Object> currentProperties;

    private static void introspectPrimitiveTypes() {
        ImmutableSet primitives = ImmutableSet.builder().addAll((Iterable)Primitives.allWrapperTypes()).add(String.class).build();
        for (Class primitive : primitives) {
            try {
                DatastoreContextIntrospector.processPropertyType(primitive);
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (IllegalArgumentException | SecurityException e) {
                LOG.error("Error introspect primitive type {}", (Object)primitive, (Object)e);
            }
        }
    }

    private static void introspectDatastoreContextBuilder() {
        for (Method method : DatastoreContext.Builder.class.getMethods()) {
            if (!DatastoreContext.Builder.class.equals(method.getReturnType())) continue;
            BUILDER_SETTERS.put(method.getName(), method);
        }
    }

    private static void introspectDataStoreProperties() {
        for (Method method : DataStoreProperties.class.getDeclaredMethods()) {
            String propertyName = DatastoreContextIntrospector.getPropertyName(method);
            if (propertyName == null) continue;
            DatastoreContextIntrospector.processDataStoreProperty(propertyName, method.getReturnType(), method);
        }
    }

    private static String getPropertyName(Method method) {
        String methodName = method.getName();
        if (Boolean.class.equals(method.getReturnType()) && methodName.startsWith("is")) {
            return WordUtils.uncapitalize((String)methodName.substring(2));
        }
        if (methodName.startsWith("get")) {
            return WordUtils.uncapitalize((String)methodName.substring(3));
        }
        return null;
    }

    private static void processDataStoreProperty(String name, Class<?> propertyType, Method readMethod) {
        Preconditions.checkArgument((boolean)BUILDER_SETTERS.containsKey(name), (String)"DataStoreProperties property \"%s\" does not have corresponding setter in DatastoreContext.Builder", (Object)name);
        try {
            DatastoreContextIntrospector.processPropertyType(propertyType);
            DATA_STORE_PROP_INFO.put(name, new AbstractMap.SimpleImmutableEntry(propertyType, readMethod));
        }
        catch (Exception e) {
            LOG.error("Error finding constructor for type {}", propertyType, (Object)e);
        }
    }

    private static void processPropertyType(Class<?> propertyType) throws NoSuchMethodException, SecurityException {
        Class wrappedType = Primitives.wrap(propertyType);
        if (CONSTRUCTORS.containsKey(wrappedType)) {
            return;
        }
        if (propertyType.isPrimitive() || Primitives.isWrapperType(propertyType) || propertyType.equals(String.class)) {
            CONSTRUCTORS.put(wrappedType, propertyType.getConstructor(String.class));
        } else {
            for (Constructor<?> ctor : propertyType.getConstructors()) {
                ConstructorParameters ctorParAnnotation = ctor.getAnnotation(ConstructorParameters.class);
                if (ctor.getParameterCount() != 1 || ctorParAnnotation == null) continue;
                DatastoreContextIntrospector.findYangTypeGetter(propertyType, ctorParAnnotation.value()[0]);
                CONSTRUCTORS.put(propertyType, ctor);
                break;
            }
        }
    }

    private static void findYangTypeGetter(Class<?> type, String propertyName) {
        for (Method method : type.getDeclaredMethods()) {
            String property = DatastoreContextIntrospector.getPropertyName(method);
            if (property == null || !property.equals(propertyName)) continue;
            YANG_TYPE_GETTERS.put(type, method);
            return;
        }
        throw new IllegalArgumentException(String.format("Getter method for constructor property %s not found for YANG type %s", propertyName, type));
    }

    public DatastoreContextIntrospector(DatastoreContext context, DataStorePropertiesContainer defaultPropsContainer) {
        DatastoreContext.Builder builder = DatastoreContext.newBuilderFrom(context);
        for (Map.Entry<String, Map.Entry<Class<?>, Method>> entry : DATA_STORE_PROP_INFO.entrySet()) {
            Object value;
            try {
                value = entry.getValue().getValue().invoke((Object)defaultPropsContainer, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                LOG.error("Error obtaining default value for property {}", (Object)entry.getKey(), (Object)e);
                value = null;
            }
            if (value == null) continue;
            this.convertValueAndInvokeSetter(entry.getKey(), value, builder);
        }
        this.context = builder.build();
    }

    public synchronized DatastoreContext getContext() {
        return this.context;
    }

    public DatastoreContextFactory newContextFactory() {
        return new DatastoreContextFactory(this);
    }

    public synchronized DatastoreContext getShardDatastoreContext(String forShardName) {
        if (this.currentProperties == null) {
            return this.context;
        }
        DatastoreContext.Builder builder = DatastoreContext.newBuilderFrom(this.context);
        String dataStoreTypePrefix = this.context.getDataStoreName() + ".";
        String shardNamePrefix = forShardName + ".";
        ArrayList<String> keys = DatastoreContextIntrospector.getSortedKeysByDatastoreType(this.currentProperties.keySet(), dataStoreTypePrefix);
        for (String key : keys) {
            Object value = this.currentProperties.get(key);
            if (key.startsWith(dataStoreTypePrefix)) {
                key = key.replaceFirst(dataStoreTypePrefix, "");
            }
            if (!key.startsWith(shardNamePrefix)) continue;
            key = key.replaceFirst(shardNamePrefix, "");
            this.convertValueAndInvokeSetter(key, value.toString(), builder);
        }
        return builder.build();
    }

    public synchronized boolean update(Map<String, Object> properties) {
        this.currentProperties = null;
        if (properties == null || properties.isEmpty()) {
            return false;
        }
        LOG.debug("In update: properties: {}", properties);
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        DatastoreContext.Builder builder = DatastoreContext.newBuilderFrom(this.context);
        String dataStoreTypePrefix = this.context.getDataStoreName() + ".";
        ArrayList<String> keys = DatastoreContextIntrospector.getSortedKeysByDatastoreType(properties.keySet(), dataStoreTypePrefix);
        boolean updated = false;
        for (String key : keys) {
            Object value = properties.get(key);
            mapBuilder.put((Object)key, value);
            if (key.startsWith(dataStoreTypePrefix)) {
                key = key.replaceFirst(dataStoreTypePrefix, "");
            }
            if (!this.convertValueAndInvokeSetter(key, value.toString(), builder)) continue;
            updated = true;
        }
        this.currentProperties = mapBuilder.build();
        if (updated) {
            this.context = builder.build();
        }
        return updated;
    }

    private static ArrayList<String> getSortedKeysByDatastoreType(Collection<String> inKeys, String dataStoreTypePrefix) {
        ArrayList<String> keys = new ArrayList<String>(inKeys);
        keys.sort((key1, key2) -> key1.startsWith(dataStoreTypePrefix) ? 1 : (key2.startsWith(dataStoreTypePrefix) ? -1 : key1.compareTo((String)key2)));
        return keys;
    }

    private boolean convertValueAndInvokeSetter(String inKey, Object inValue, DatastoreContext.Builder builder) {
        String key = DatastoreContextIntrospector.convertToCamelCase(inKey);
        try {
            Object value = this.convertValue(key, inValue);
            if (value == null) {
                return false;
            }
            LOG.debug("Converted value for property {}: {} ({})", new Object[]{key, value, value.getClass().getSimpleName()});
            Method setter = BUILDER_SETTERS.get(key);
            setter.invoke((Object)builder, this.constructorValueRecursively(Primitives.wrap(setter.getParameterTypes()[0]), value.toString()));
            return true;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            LOG.error("Error converting value ({}) for property {}", new Object[]{inValue, key, e});
            return false;
        }
    }

    private static String convertToCamelCase(String inString) {
        String str = inString.trim();
        if (StringUtils.contains((CharSequence)str, (int)45) || StringUtils.contains((CharSequence)str, (int)32)) {
            str = inString.replace('-', ' ');
            str = WordUtils.capitalizeFully((String)str);
            str = StringUtils.deleteWhitespace((String)str);
        }
        return StringUtils.uncapitalize((String)str);
    }

    private Object convertValue(String name, Object from) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Map.Entry<Class<?>, Method> propertyInfo = DATA_STORE_PROP_INFO.get(name);
        if (propertyInfo == null) {
            LOG.debug("Property not found for {}", (Object)name);
            return null;
        }
        Class<?> propertyType = propertyInfo.getKey();
        LOG.debug("Type for property {}: {}, converting value {} ({})", new Object[]{name, propertyType.getSimpleName(), from, from.getClass().getSimpleName()});
        Object converted = this.constructorValueRecursively(propertyType, from);
        Method getter = YANG_TYPE_GETTERS.get(converted.getClass());
        if (getter != null) {
            converted = getter.invoke(converted, new Object[0]);
        }
        return converted;
    }

    private Object constructorValueRecursively(Class<?> toType, Object fromValue) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        LOG.trace("convertValueRecursively - toType: {}, fromValue {} ({})", new Object[]{toType.getSimpleName(), fromValue, fromValue.getClass().getSimpleName()});
        if (toType.equals(fromValue.getClass())) {
            return fromValue;
        }
        Constructor<?> ctor = CONSTRUCTORS.get(toType);
        if (ctor == null) {
            Function factory;
            if (fromValue instanceof String && (factory = (Function)UINT_FACTORIES.get(toType)) != null) {
                return factory.apply((String)fromValue);
            }
            throw new IllegalArgumentException(String.format("Constructor not found for type %s", toType));
        }
        LOG.trace("Found {}", ctor);
        Object value = fromValue;
        if (!ctor.getParameterTypes()[0].equals(fromValue.getClass())) {
            value = this.constructorValueRecursively(ctor.getParameterTypes()[0], fromValue);
        }
        return ctor.newInstance(value);
    }

    static {
        try {
            DatastoreContextIntrospector.introspectDatastoreContextBuilder();
            DatastoreContextIntrospector.introspectDataStoreProperties();
            DatastoreContextIntrospector.introspectPrimitiveTypes();
        }
        catch (IllegalArgumentException e) {
            LOG.error("Error initializing DatastoreContextIntrospector", (Throwable)e);
        }
    }
}

