/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import akka.actor.ActorRef;
import akka.actor.ActorSelection;
import java.io.Serializable;
import java.util.Collection;
import java.util.Objects;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.controller.cluster.datastore.messages.DataTreeChanged;
import org.opendaylight.controller.cluster.datastore.messages.OnInitialData;
import org.opendaylight.mdsal.dom.api.DOMDataTreeChangeListener;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeCandidate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ForwardingDataTreeChangeListener
implements DOMDataTreeChangeListener {
    private static final Logger LOG = LoggerFactory.getLogger(ForwardingDataTreeChangeListener.class);
    private final ActorSelection actor;
    private final ActorRef sendingActor;

    ForwardingDataTreeChangeListener(ActorSelection actor, @Nullable ActorRef sendingActor) {
        this.actor = Objects.requireNonNull(actor, "actor should not be null");
        this.sendingActor = sendingActor;
    }

    public void onDataTreeChanged(Collection<DataTreeCandidate> changes) {
        LOG.debug("Sending DataTreeChanged to {}", (Object)this.actor);
        this.actor.tell((Object)new DataTreeChanged(changes), this.sendingActor);
    }

    public void onInitialData() {
        LOG.debug("Sending OnInitialData to {}", (Object)this.actor);
        this.actor.tell((Object)OnInitialData.INSTANCE, this.sendingActor);
    }

    public String toString() {
        return "ForwardingDataTreeChangeListener [actor=" + this.actor + ", sending actor=" + (Serializable)(this.sendingActor != null ? this.sendingActor : "NO_SENDER") + "]";
    }
}

