/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import akka.actor.ActorRef;
import akka.util.Timeout;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.primitives.UnsignedLong;
import com.google.common.util.concurrent.FutureCallback;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Queue;
import java.util.SortedSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.controller.cluster.access.concepts.LocalHistoryIdentifier;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;
import org.opendaylight.controller.cluster.datastore.AbstractShardDataTreeTransaction;
import org.opendaylight.controller.cluster.datastore.DataTreeCohortActorRegistry;
import org.opendaylight.controller.cluster.datastore.DatastoreContext;
import org.opendaylight.controller.cluster.datastore.DefaultShardDataTreeChangeListenerPublisher;
import org.opendaylight.controller.cluster.datastore.ReadOnlyShardDataTreeTransaction;
import org.opendaylight.controller.cluster.datastore.ReadWriteShardDataTreeTransaction;
import org.opendaylight.controller.cluster.datastore.Shard;
import org.opendaylight.controller.cluster.datastore.ShardDataTreeChangeListenerPublisher;
import org.opendaylight.controller.cluster.datastore.ShardDataTreeCohort;
import org.opendaylight.controller.cluster.datastore.ShardDataTreeMetadata;
import org.opendaylight.controller.cluster.datastore.ShardDataTreeTransactionChain;
import org.opendaylight.controller.cluster.datastore.ShardDataTreeTransactionParent;
import org.opendaylight.controller.cluster.datastore.SimpleShardDataTreeCohort;
import org.opendaylight.controller.cluster.datastore.jmx.mbeans.shard.ShardStats;
import org.opendaylight.controller.cluster.datastore.node.utils.transformer.ReusableNormalizedNodePruner;
import org.opendaylight.controller.cluster.datastore.persisted.AbortTransactionPayload;
import org.opendaylight.controller.cluster.datastore.persisted.AbstractIdentifiablePayload;
import org.opendaylight.controller.cluster.datastore.persisted.CloseLocalHistoryPayload;
import org.opendaylight.controller.cluster.datastore.persisted.CommitTransactionPayload;
import org.opendaylight.controller.cluster.datastore.persisted.CreateLocalHistoryPayload;
import org.opendaylight.controller.cluster.datastore.persisted.DataTreeCandidateInputOutput;
import org.opendaylight.controller.cluster.datastore.persisted.MetadataShardDataTreeSnapshot;
import org.opendaylight.controller.cluster.datastore.persisted.PayloadVersion;
import org.opendaylight.controller.cluster.datastore.persisted.PurgeLocalHistoryPayload;
import org.opendaylight.controller.cluster.datastore.persisted.PurgeTransactionPayload;
import org.opendaylight.controller.cluster.datastore.persisted.ShardDataTreeSnapshot;
import org.opendaylight.controller.cluster.datastore.persisted.ShardDataTreeSnapshotMetadata;
import org.opendaylight.controller.cluster.datastore.persisted.ShardSnapshotState;
import org.opendaylight.controller.cluster.datastore.utils.DataTreeModificationOutput;
import org.opendaylight.controller.cluster.datastore.utils.PruningDataTreeModification;
import org.opendaylight.controller.cluster.raft.base.messages.InitiateCaptureSnapshot;
import org.opendaylight.controller.cluster.raft.protobuff.client.messages.Payload;
import org.opendaylight.mdsal.common.api.OptimisticLockFailedException;
import org.opendaylight.mdsal.common.api.TransactionCommitFailedException;
import org.opendaylight.mdsal.dom.api.DOMDataTreeChangeListener;
import org.opendaylight.yangtools.concepts.Identifier;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.yang.common.RpcError;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.ConflictingModificationAppliedException;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTree;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeCandidate;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeCandidateTip;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeCandidates;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeConfiguration;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeModification;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeSnapshot;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeTip;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataValidationFailedException;
import org.opendaylight.yangtools.yang.data.api.schema.tree.ModificationType;
import org.opendaylight.yangtools.yang.data.api.schema.tree.TreeType;
import org.opendaylight.yangtools.yang.data.codec.binfmt.NormalizedNodeStreamVersion;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.InMemoryDataTreeFactory;
import org.opendaylight.yangtools.yang.data.util.DataSchemaContextTree;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.concurrent.duration.FiniteDuration;

public class ShardDataTree
extends ShardDataTreeTransactionParent {
    private static final Timeout COMMIT_STEP_TIMEOUT = new Timeout(FiniteDuration.create((long)5L, (TimeUnit)TimeUnit.SECONDS));
    private static final Logger LOG = LoggerFactory.getLogger(ShardDataTree.class);
    private static final int MAX_TRANSACTION_BATCH = 100;
    private final Map<LocalHistoryIdentifier, ShardDataTreeTransactionChain> transactionChains = new HashMap<LocalHistoryIdentifier, ShardDataTreeTransactionChain>();
    private final DataTreeCohortActorRegistry cohortRegistry = new DataTreeCohortActorRegistry();
    private final Deque<CommitEntry> pendingTransactions = new ArrayDeque<CommitEntry>();
    private final Queue<CommitEntry> pendingCommits = new ArrayDeque<CommitEntry>();
    private final Queue<CommitEntry> pendingFinishCommits = new ArrayDeque<CommitEntry>();
    private final Map<Payload, Runnable> replicationCallbacks = new HashMap<Payload, Runnable>();
    private final ShardDataTreeChangeListenerPublisher treeChangeListenerPublisher;
    private final Collection<ShardDataTreeMetadata<?>> metadata;
    private final DataTree dataTree;
    private final String logContext;
    private final Shard shard;
    private Runnable runOnPendingTransactionsComplete;
    private DataTreeTip tip;
    private SchemaContext schemaContext;
    private DataSchemaContextTree dataSchemaContext;
    private int currentTransactionBatch;

    ShardDataTree(Shard shard, EffectiveModelContext schemaContext, DataTree dataTree, ShardDataTreeChangeListenerPublisher treeChangeListenerPublisher, String logContext, ShardDataTreeMetadata<?> ... metadata) {
        this.dataTree = Objects.requireNonNull(dataTree);
        this.updateSchemaContext(schemaContext);
        this.shard = Objects.requireNonNull(shard);
        this.treeChangeListenerPublisher = Objects.requireNonNull(treeChangeListenerPublisher);
        this.logContext = Objects.requireNonNull(logContext);
        this.metadata = ImmutableList.copyOf((Object[])metadata);
        this.tip = dataTree;
    }

    ShardDataTree(Shard shard, EffectiveModelContext schemaContext, TreeType treeType, YangInstanceIdentifier root, ShardDataTreeChangeListenerPublisher treeChangeListenerPublisher, String logContext, ShardDataTreeMetadata<?> ... metadata) {
        this(shard, schemaContext, ShardDataTree.createDataTree(treeType, root), treeChangeListenerPublisher, logContext, metadata);
    }

    private static DataTree createDataTree(TreeType treeType, YangInstanceIdentifier root) {
        DataTreeConfiguration baseConfig = DataTreeConfiguration.getDefault((TreeType)treeType);
        return new InMemoryDataTreeFactory().create(new DataTreeConfiguration.Builder(baseConfig.getTreeType()).setMandatoryNodesValidation(baseConfig.isMandatoryNodesValidationEnabled()).setUniqueIndexes(baseConfig.isUniqueIndexEnabled()).setRootPath(root).build());
    }

    @VisibleForTesting
    public ShardDataTree(Shard shard, EffectiveModelContext schemaContext, TreeType treeType) {
        this(shard, schemaContext, treeType, YangInstanceIdentifier.empty(), new DefaultShardDataTreeChangeListenerPublisher(""), "", new ShardDataTreeMetadata[0]);
    }

    final String logContext() {
        return this.logContext;
    }

    final long readTime() {
        return this.shard.ticker().read();
    }

    public DataTree getDataTree() {
        return this.dataTree;
    }

    SchemaContext getSchemaContext() {
        return this.schemaContext;
    }

    void updateSchemaContext(@NonNull EffectiveModelContext newSchemaContext) {
        this.dataTree.setEffectiveModelContext(newSchemaContext);
        this.schemaContext = newSchemaContext;
        this.dataSchemaContext = DataSchemaContextTree.from((EffectiveModelContext)newSchemaContext);
    }

    void resetTransactionBatch() {
        this.currentTransactionBatch = 0;
    }

    @NonNull ShardDataTreeSnapshot takeStateSnapshot() {
        NormalizedNode rootNode = (NormalizedNode)this.dataTree.takeSnapshot().readNode(YangInstanceIdentifier.empty()).get();
        ImmutableMap.Builder metaBuilder = ImmutableMap.builder();
        for (ShardDataTreeMetadata<?> m : this.metadata) {
            Object meta = m.toSnapshot();
            if (meta == null) continue;
            metaBuilder.put(((ShardDataTreeSnapshotMetadata)meta).getType(), meta);
        }
        return new MetadataShardDataTreeSnapshot((NormalizedNode<?, ?>)rootNode, (Map<Class<? extends ShardDataTreeSnapshotMetadata<?>>, ShardDataTreeSnapshotMetadata<?>>)metaBuilder.build());
    }

    private boolean anyPendingTransactions() {
        return !this.pendingTransactions.isEmpty() || !this.pendingCommits.isEmpty() || !this.pendingFinishCommits.isEmpty();
    }

    private void applySnapshot(@NonNull ShardDataTreeSnapshot snapshot, UnaryOperator<DataTreeModification> wrapper) throws DataValidationFailedException {
        Stopwatch elapsed = Stopwatch.createStarted();
        if (this.anyPendingTransactions()) {
            LOG.warn("{}: applying state snapshot with pending transactions", (Object)this.logContext);
        }
        Map<Class<ShardDataTreeSnapshotMetadata<Object>>, ShardDataTreeSnapshotMetadata<Object>> snapshotMeta = snapshot instanceof MetadataShardDataTreeSnapshot ? ((MetadataShardDataTreeSnapshot)snapshot).getMetadata() : ImmutableMap.of();
        for (ShardDataTreeMetadata<?> m : this.metadata) {
            ShardDataTreeSnapshotMetadata s = (ShardDataTreeSnapshotMetadata)snapshotMeta.get(m.getSupportedType());
            if (s != null) {
                m.applySnapshot(s);
                continue;
            }
            m.reset();
        }
        DataTreeModification unwrapped = this.dataTree.takeSnapshot().newModification();
        DataTreeModification mod = (DataTreeModification)wrapper.apply(unwrapped);
        mod.delete(YangInstanceIdentifier.empty());
        Optional<NormalizedNode<?, ?>> maybeNode = snapshot.getRootNode();
        if (maybeNode.isPresent()) {
            mod.write(YangInstanceIdentifier.empty(), maybeNode.get());
        }
        mod.ready();
        this.dataTree.validate(unwrapped);
        DataTreeCandidateTip candidate = this.dataTree.prepare(unwrapped);
        this.dataTree.commit((DataTreeCandidate)candidate);
        this.notifyListeners((DataTreeCandidate)candidate);
        LOG.debug("{}: state snapshot applied in {}", (Object)this.logContext, (Object)elapsed);
    }

    void applySnapshot(@NonNull ShardDataTreeSnapshot snapshot) throws DataValidationFailedException {
        this.applySnapshot(snapshot, UnaryOperator.identity());
    }

    void applyRecoverySnapshot(@NonNull ShardSnapshotState snapshot) throws DataValidationFailedException {
        ReusableNormalizedNodePruner pruner = ReusableNormalizedNodePruner.forDataSchemaContext((DataSchemaContextTree)this.dataSchemaContext);
        if (snapshot.needsMigration()) {
            ReusableNormalizedNodePruner uintPruner = pruner.withUintAdaption();
            this.applySnapshot(snapshot.getSnapshot(), delegate -> new PruningDataTreeModification.Proactive((DataTreeModification)delegate, this.dataTree, uintPruner));
        } else {
            this.applySnapshot(snapshot.getSnapshot(), delegate -> new PruningDataTreeModification.Reactive((DataTreeModification)delegate, this.dataTree, pruner));
        }
    }

    private void applyRecoveryCandidate(CommitTransactionPayload payload) throws IOException {
        Map.Entry<TransactionIdentifier, DataTreeCandidateInputOutput.DataTreeCandidateWithVersion> entry = payload.acquireCandidate();
        DataTreeModification unwrapped = this.dataTree.takeSnapshot().newModification();
        PruningDataTreeModification mod = this.createPruningModification(unwrapped, NormalizedNodeStreamVersion.MAGNESIUM.compareTo((Enum)entry.getValue().getVersion()) > 0);
        DataTreeCandidates.applyToModification((DataTreeModification)mod, (DataTreeCandidate)entry.getValue().getCandidate());
        mod.ready();
        LOG.trace("{}: Applying recovery modification {}", (Object)this.logContext, (Object)unwrapped);
        try {
            this.dataTree.validate(unwrapped);
            this.dataTree.commit((DataTreeCandidate)this.dataTree.prepare(unwrapped));
        }
        catch (Exception e) {
            File file = new File(System.getProperty("karaf.data", "."), "failed-recovery-payload-" + this.logContext + ".out");
            DataTreeModificationOutput.toFile(file, unwrapped);
            throw new IllegalStateException(String.format("%s: Failed to apply recovery payload. Modification data was written to file %s", this.logContext, file), e);
        }
        this.allMetadataCommittedTransaction(entry.getKey());
    }

    private PruningDataTreeModification createPruningModification(DataTreeModification unwrapped, boolean uintAdapting) {
        ReusableNormalizedNodePruner pruner = ReusableNormalizedNodePruner.forDataSchemaContext((DataSchemaContextTree)this.dataSchemaContext);
        return uintAdapting ? new PruningDataTreeModification.Proactive(unwrapped, this.dataTree, pruner.withUintAdaption()) : new PruningDataTreeModification.Reactive(unwrapped, this.dataTree, pruner);
    }

    void applyRecoveryPayload(@NonNull Payload payload) throws IOException {
        if (payload instanceof CommitTransactionPayload) {
            this.applyRecoveryCandidate((CommitTransactionPayload)payload);
        } else if (payload instanceof AbortTransactionPayload) {
            this.allMetadataAbortedTransaction((TransactionIdentifier)((AbortTransactionPayload)payload).getIdentifier());
        } else if (payload instanceof PurgeTransactionPayload) {
            this.allMetadataPurgedTransaction((TransactionIdentifier)((PurgeTransactionPayload)payload).getIdentifier());
        } else if (payload instanceof CreateLocalHistoryPayload) {
            this.allMetadataCreatedLocalHistory((LocalHistoryIdentifier)((CreateLocalHistoryPayload)payload).getIdentifier());
        } else if (payload instanceof CloseLocalHistoryPayload) {
            this.allMetadataClosedLocalHistory((LocalHistoryIdentifier)((CloseLocalHistoryPayload)payload).getIdentifier());
        } else if (payload instanceof PurgeLocalHistoryPayload) {
            this.allMetadataPurgedLocalHistory((LocalHistoryIdentifier)((PurgeLocalHistoryPayload)payload).getIdentifier());
        } else {
            LOG.debug("{}: ignoring unhandled payload {}", (Object)this.logContext, (Object)payload);
        }
    }

    private void applyReplicatedCandidate(CommitTransactionPayload payload) throws DataValidationFailedException, IOException {
        Map.Entry<TransactionIdentifier, DataTreeCandidateInputOutput.DataTreeCandidateWithVersion> entry = payload.getCandidate();
        TransactionIdentifier identifier = entry.getKey();
        LOG.debug("{}: Applying foreign transaction {}", (Object)this.logContext, (Object)identifier);
        DataTreeModification mod = this.dataTree.takeSnapshot().newModification();
        DataTreeCandidates.applyToModification((DataTreeModification)mod, (DataTreeCandidate)entry.getValue().getCandidate());
        mod.ready();
        LOG.trace("{}: Applying foreign modification {}", (Object)this.logContext, (Object)mod);
        this.dataTree.validate(mod);
        DataTreeCandidateTip candidate = this.dataTree.prepare(mod);
        this.dataTree.commit((DataTreeCandidate)candidate);
        this.allMetadataCommittedTransaction(identifier);
        this.notifyListeners((DataTreeCandidate)candidate);
    }

    void applyReplicatedPayload(Identifier identifier, Payload payload) throws IOException, DataValidationFailedException {
        if (payload instanceof CommitTransactionPayload) {
            if (identifier == null) {
                this.applyReplicatedCandidate((CommitTransactionPayload)payload);
            } else {
                Verify.verify((boolean)(identifier instanceof TransactionIdentifier));
                if (!this.payloadReplicationComplete((TransactionIdentifier)identifier)) {
                    this.applyReplicatedCandidate((CommitTransactionPayload)payload);
                }
            }
            this.checkRootOverwrite(((CommitTransactionPayload)payload).acquireCandidate().getValue().getCandidate());
        } else if (payload instanceof AbortTransactionPayload) {
            if (identifier != null) {
                this.payloadReplicationComplete((AbortTransactionPayload)payload);
            }
            this.allMetadataAbortedTransaction((TransactionIdentifier)((AbortTransactionPayload)payload).getIdentifier());
        } else if (payload instanceof PurgeTransactionPayload) {
            if (identifier != null) {
                this.payloadReplicationComplete((PurgeTransactionPayload)payload);
            }
            this.allMetadataPurgedTransaction((TransactionIdentifier)((PurgeTransactionPayload)payload).getIdentifier());
        } else if (payload instanceof CloseLocalHistoryPayload) {
            if (identifier != null) {
                this.payloadReplicationComplete((CloseLocalHistoryPayload)payload);
            }
            this.allMetadataClosedLocalHistory((LocalHistoryIdentifier)((CloseLocalHistoryPayload)payload).getIdentifier());
        } else if (payload instanceof CreateLocalHistoryPayload) {
            if (identifier != null) {
                this.payloadReplicationComplete((CreateLocalHistoryPayload)payload);
            }
            this.allMetadataCreatedLocalHistory((LocalHistoryIdentifier)((CreateLocalHistoryPayload)payload).getIdentifier());
        } else if (payload instanceof PurgeLocalHistoryPayload) {
            if (identifier != null) {
                this.payloadReplicationComplete((PurgeLocalHistoryPayload)payload);
            }
            this.allMetadataPurgedLocalHistory((LocalHistoryIdentifier)((PurgeLocalHistoryPayload)payload).getIdentifier());
        } else {
            LOG.warn("{}: ignoring unhandled identifier {} payload {}", new Object[]{this.logContext, identifier, payload});
        }
    }

    private void checkRootOverwrite(DataTreeCandidate candidate) {
        DatastoreContext datastoreContext = this.shard.getDatastoreContext();
        if (!datastoreContext.isSnapshotOnRootOverwrite()) {
            return;
        }
        if (!datastoreContext.isPersistent()) {
            return;
        }
        if (candidate.getRootNode().getModificationType().equals((Object)ModificationType.UNMODIFIED)) {
            return;
        }
        if (candidate.getRootPath().equals((Object)YangInstanceIdentifier.empty()) && candidate.getRootNode().getModificationType().equals((Object)ModificationType.WRITE)) {
            LOG.debug("{}: shard root overwritten, enqueuing snapshot", (Object)this.logContext);
            this.shard.self().tell((Object)new InitiateCaptureSnapshot(), ActorRef.noSender());
            return;
        }
    }

    private void replicatePayload(Identifier id, Payload payload, @Nullable Runnable callback) {
        if (callback != null) {
            this.replicationCallbacks.put(payload, callback);
        }
        this.shard.persistPayload(id, payload, true);
    }

    private void payloadReplicationComplete(AbstractIdentifiablePayload<?> payload) {
        Runnable callback = this.replicationCallbacks.remove(payload);
        if (callback != null) {
            LOG.debug("{}: replication of {} completed, invoking {}", new Object[]{this.logContext, payload.getIdentifier(), callback});
            callback.run();
        } else {
            LOG.debug("{}: replication of {} has no callback", (Object)this.logContext, payload.getIdentifier());
        }
    }

    private boolean payloadReplicationComplete(TransactionIdentifier txId) {
        CommitEntry current = this.pendingFinishCommits.peek();
        if (current == null) {
            LOG.warn("{}: No outstanding transactions, ignoring consensus on transaction {}", (Object)this.logContext, (Object)txId);
            this.allMetadataCommittedTransaction(txId);
            return false;
        }
        if (!current.cohort.getIdentifier().equals((Object)txId)) {
            LOG.debug("{}: Head of pendingFinishCommits queue is {}, ignoring consensus on transaction {}", new Object[]{this.logContext, current.cohort.getIdentifier(), txId});
            this.allMetadataCommittedTransaction(txId);
            return false;
        }
        this.finishCommit(current.cohort);
        return true;
    }

    private void allMetadataAbortedTransaction(TransactionIdentifier txId) {
        for (ShardDataTreeMetadata<?> m : this.metadata) {
            m.onTransactionAborted(txId);
        }
    }

    private void allMetadataCommittedTransaction(TransactionIdentifier txId) {
        for (ShardDataTreeMetadata<?> m : this.metadata) {
            m.onTransactionCommitted(txId);
        }
    }

    private void allMetadataPurgedTransaction(TransactionIdentifier txId) {
        for (ShardDataTreeMetadata<?> m : this.metadata) {
            m.onTransactionPurged(txId);
        }
    }

    private void allMetadataCreatedLocalHistory(LocalHistoryIdentifier historyId) {
        for (ShardDataTreeMetadata<?> m : this.metadata) {
            m.onHistoryCreated(historyId);
        }
    }

    private void allMetadataClosedLocalHistory(LocalHistoryIdentifier historyId) {
        for (ShardDataTreeMetadata<?> m : this.metadata) {
            m.onHistoryClosed(historyId);
        }
    }

    private void allMetadataPurgedLocalHistory(LocalHistoryIdentifier historyId) {
        for (ShardDataTreeMetadata<?> m : this.metadata) {
            m.onHistoryPurged(historyId);
        }
    }

    ShardDataTreeTransactionChain recreateTransactionChain(LocalHistoryIdentifier historyId, boolean closed) {
        ShardDataTreeTransactionChain ret = new ShardDataTreeTransactionChain(historyId, this);
        ShardDataTreeTransactionChain existing = this.transactionChains.putIfAbsent(historyId, ret);
        Preconditions.checkState((existing == null ? 1 : 0) != 0, (String)"Attempted to recreate chain %s, but %s already exists", (Object)historyId, (Object)existing);
        return ret;
    }

    ShardDataTreeTransactionChain ensureTransactionChain(LocalHistoryIdentifier historyId, @Nullable Runnable callback) {
        ShardDataTreeTransactionChain chain = this.transactionChains.get(historyId);
        if (chain == null) {
            chain = new ShardDataTreeTransactionChain(historyId, this);
            this.transactionChains.put(historyId, chain);
            this.replicatePayload((Identifier)historyId, (Payload)CreateLocalHistoryPayload.create(historyId, this.shard.getDatastoreContext().getInitialPayloadSerializedBufferCapacity()), callback);
        } else if (callback != null) {
            callback.run();
        }
        return chain;
    }

    ReadOnlyShardDataTreeTransaction newReadOnlyTransaction(TransactionIdentifier txId) {
        this.shard.getShardMBean().incrementReadOnlyTransactionCount();
        if (txId.getHistoryId().getHistoryId() == 0L) {
            return new ReadOnlyShardDataTreeTransaction((ShardDataTreeTransactionParent)this, txId, this.dataTree.takeSnapshot());
        }
        return this.ensureTransactionChain(txId.getHistoryId(), null).newReadOnlyTransaction(txId);
    }

    ReadWriteShardDataTreeTransaction newReadWriteTransaction(TransactionIdentifier txId) {
        this.shard.getShardMBean().incrementReadWriteTransactionCount();
        if (txId.getHistoryId().getHistoryId() == 0L) {
            return new ReadWriteShardDataTreeTransaction((ShardDataTreeTransactionParent)this, txId, this.dataTree.takeSnapshot().newModification());
        }
        return this.ensureTransactionChain(txId.getHistoryId(), null).newReadWriteTransaction(txId);
    }

    @VisibleForTesting
    public void notifyListeners(DataTreeCandidate candidate) {
        this.treeChangeListenerPublisher.publishChanges(candidate);
    }

    void purgeLeaderState() {
        for (ShardDataTreeTransactionChain chain : this.transactionChains.values()) {
            chain.close();
        }
        this.transactionChains.clear();
        this.replicationCallbacks.clear();
    }

    void closeTransactionChain(LocalHistoryIdentifier id, @Nullable Runnable callback) {
        if (this.commonCloseTransactionChain(id, callback)) {
            this.replicatePayload((Identifier)id, (Payload)CloseLocalHistoryPayload.create(id, this.shard.getDatastoreContext().getInitialPayloadSerializedBufferCapacity()), callback);
        }
    }

    void closeTransactionChain(LocalHistoryIdentifier id) {
        this.commonCloseTransactionChain(id, null);
    }

    private boolean commonCloseTransactionChain(LocalHistoryIdentifier id, @Nullable Runnable callback) {
        ShardDataTreeTransactionChain chain = this.transactionChains.get(id);
        if (chain == null) {
            LOG.debug("{}: Closing non-existent transaction chain {}", (Object)this.logContext, (Object)id);
            if (callback != null) {
                callback.run();
            }
            return false;
        }
        chain.close();
        return true;
    }

    void purgeTransactionChain(LocalHistoryIdentifier id, @Nullable Runnable callback) {
        ShardDataTreeTransactionChain chain = this.transactionChains.remove(id);
        if (chain == null) {
            LOG.debug("{}: Purging non-existent transaction chain {}", (Object)this.logContext, (Object)id);
            if (callback != null) {
                callback.run();
            }
            return;
        }
        this.replicatePayload((Identifier)id, (Payload)PurgeLocalHistoryPayload.create(id, this.shard.getDatastoreContext().getInitialPayloadSerializedBufferCapacity()), callback);
    }

    Optional<DataTreeCandidate> readCurrentData() {
        return this.dataTree.takeSnapshot().readNode(YangInstanceIdentifier.empty()).map(state -> DataTreeCandidates.fromNormalizedNode((YangInstanceIdentifier)YangInstanceIdentifier.empty(), (NormalizedNode)state));
    }

    public void registerTreeChangeListener(YangInstanceIdentifier path, DOMDataTreeChangeListener listener, Optional<DataTreeCandidate> initialState, Consumer<ListenerRegistration<DOMDataTreeChangeListener>> onRegistration) {
        this.treeChangeListenerPublisher.registerTreeChangeListener(path, listener, initialState, onRegistration);
    }

    int getQueueSize() {
        return this.pendingTransactions.size() + this.pendingCommits.size() + this.pendingFinishCommits.size();
    }

    @Override
    void abortTransaction(AbstractShardDataTreeTransaction<?> transaction, Runnable callback) {
        TransactionIdentifier id = transaction.getIdentifier();
        LOG.debug("{}: aborting transaction {}", (Object)this.logContext, (Object)id);
        this.replicatePayload((Identifier)id, (Payload)AbortTransactionPayload.create(id, this.shard.getDatastoreContext().getInitialPayloadSerializedBufferCapacity()), callback);
    }

    @Override
    void abortFromTransactionActor(AbstractShardDataTreeTransaction<?> transaction) {
    }

    @Override
    ShardDataTreeCohort finishTransaction(ReadWriteShardDataTreeTransaction transaction, Optional<SortedSet<String>> participatingShardNames) {
        DataTreeModification snapshot = (DataTreeModification)transaction.getSnapshot();
        TransactionIdentifier id = transaction.getIdentifier();
        LOG.debug("{}: readying transaction {}", (Object)this.logContext, (Object)id);
        snapshot.ready();
        LOG.debug("{}: transaction {} ready", (Object)this.logContext, (Object)id);
        return this.createReadyCohort(transaction.getIdentifier(), snapshot, participatingShardNames);
    }

    void purgeTransaction(TransactionIdentifier id, Runnable callback) {
        LOG.debug("{}: purging transaction {}", (Object)this.logContext, (Object)id);
        this.replicatePayload((Identifier)id, (Payload)PurgeTransactionPayload.create(id, this.shard.getDatastoreContext().getInitialPayloadSerializedBufferCapacity()), callback);
    }

    public Optional<NormalizedNode<?, ?>> readNode(YangInstanceIdentifier path) {
        return this.dataTree.takeSnapshot().readNode(path);
    }

    DataTreeSnapshot takeSnapshot() {
        return this.dataTree.takeSnapshot();
    }

    @VisibleForTesting
    public DataTreeModification newModification() {
        return this.dataTree.takeSnapshot().newModification();
    }

    public Collection<ShardDataTreeCohort> getAndClearPendingTransactions() {
        ArrayList<ShardDataTreeCohort> ret = new ArrayList<ShardDataTreeCohort>(this.getQueueSize());
        for (CommitEntry entry : this.pendingFinishCommits) {
            ret.add(entry.cohort);
        }
        for (CommitEntry entry : this.pendingCommits) {
            ret.add(entry.cohort);
        }
        for (CommitEntry entry : this.pendingTransactions) {
            ret.add(entry.cohort);
        }
        this.pendingFinishCommits.clear();
        this.pendingCommits.clear();
        this.pendingTransactions.clear();
        this.tip = this.dataTree;
        return ret;
    }

    void resumeNextPendingTransaction() {
        LOG.debug("{}: attempting to resume transaction processing", (Object)this.logContext);
        this.processNextPending();
    }

    private void processNextPendingTransaction() {
        ++this.currentTransactionBatch;
        if (this.currentTransactionBatch > 100) {
            LOG.debug("{}: Already processed {}, scheduling continuation", (Object)this.logContext, (Object)this.currentTransactionBatch);
            this.shard.scheduleNextPendingTransaction();
            return;
        }
        this.processNextPending(this.pendingTransactions, ShardDataTreeCohort.State.CAN_COMMIT_PENDING, entry -> {
            Exception cause;
            SimpleShardDataTreeCohort cohort = entry.cohort;
            DataTreeModification modification = cohort.getDataTreeModification();
            LOG.debug("{}: Validating transaction {}", (Object)this.logContext, (Object)cohort.getIdentifier());
            try {
                this.tip.validate(modification);
                LOG.debug("{}: Transaction {} validated", (Object)this.logContext, (Object)cohort.getIdentifier());
                cohort.successfulCanCommit();
                entry.lastAccess = this.readTime();
                return;
            }
            catch (ConflictingModificationAppliedException e) {
                LOG.warn("{}: Store Tx {}: Conflicting modification for path {}.", new Object[]{this.logContext, cohort.getIdentifier(), e.getPath()});
                cause = new OptimisticLockFailedException("Optimistic lock failed for path " + e.getPath(), (Throwable)e);
            }
            catch (DataValidationFailedException e) {
                LOG.warn("{}: Store Tx {}: Data validation failed for path {}.", new Object[]{this.logContext, cohort.getIdentifier(), e.getPath(), e});
                LOG.debug("{}: Store Tx {}: modifications: {}", new Object[]{this.logContext, cohort.getIdentifier(), modification});
                LOG.trace("{}: Current tree: {}", (Object)this.logContext, (Object)this.dataTree);
                cause = new TransactionCommitFailedException("Data did not pass validation for path " + e.getPath(), (Throwable)e, new RpcError[0]);
            }
            catch (Exception e) {
                LOG.warn("{}: Unexpected failure in validation phase", (Object)this.logContext, (Object)e);
                cause = e;
            }
            this.pendingTransactions.poll().cohort.failedCanCommit(cause);
        });
    }

    private void processNextPending() {
        this.processNextPendingCommit();
        this.processNextPendingTransaction();
    }

    private void processNextPending(Queue<CommitEntry> queue, ShardDataTreeCohort.State allowedState, Consumer<CommitEntry> processor) {
        while (!queue.isEmpty()) {
            CommitEntry entry = queue.peek();
            SimpleShardDataTreeCohort cohort = entry.cohort;
            if (cohort.isFailed()) {
                LOG.debug("{}: Removing failed transaction {}", (Object)this.logContext, (Object)cohort.getIdentifier());
                queue.remove();
                continue;
            }
            if (cohort.getState() != allowedState) break;
            processor.accept(entry);
            break;
        }
        this.maybeRunOperationOnPendingTransactionsComplete();
    }

    private void processNextPendingCommit() {
        this.processNextPending(this.pendingCommits, ShardDataTreeCohort.State.COMMIT_PENDING, entry -> this.startCommit(entry.cohort, (DataTreeCandidate)entry.cohort.getCandidate()));
    }

    private boolean peekNextPendingCommit() {
        CommitEntry first = this.pendingCommits.peek();
        return first != null && first.cohort.getState() == ShardDataTreeCohort.State.COMMIT_PENDING;
    }

    void startCanCommit(SimpleShardDataTreeCohort cohort) {
        CommitEntry head = this.pendingTransactions.peek();
        if (head == null) {
            LOG.warn("{}: No transactions enqueued while attempting to start canCommit on {}", (Object)this.logContext, (Object)cohort);
            return;
        }
        if (!cohort.equals(head.cohort)) {
            Collection<String> precedingShardNames = this.extractPrecedingShardNames(cohort.getParticipatingShardNames());
            if (precedingShardNames.isEmpty()) {
                LOG.debug("{}: Tx {} is scheduled for canCommit step", (Object)this.logContext, (Object)cohort.getIdentifier());
                return;
            }
            LOG.debug("{}: Evaluating tx {} for canCommit -  preceding participating shard names {}", new Object[]{this.logContext, cohort.getIdentifier(), precedingShardNames});
            Iterator<CommitEntry> iter = this.pendingTransactions.iterator();
            int index = -1;
            int moveToIndex = -1;
            while (iter.hasNext()) {
                CommitEntry entry = iter.next();
                ++index;
                if (cohort.equals(entry.cohort)) {
                    if (moveToIndex < 0) {
                        LOG.debug("{}: Not moving tx {} - cannot proceed with canCommit", (Object)this.logContext, (Object)cohort.getIdentifier());
                        return;
                    }
                    LOG.debug("{}: Moving {} to index {} in the pendingTransactions queue", new Object[]{this.logContext, cohort.getIdentifier(), moveToIndex});
                    iter.remove();
                    ShardDataTree.insertEntry(this.pendingTransactions, entry, moveToIndex);
                    if (!cohort.equals(this.pendingTransactions.peek().cohort)) {
                        LOG.debug("{}: Tx {} is not at the head of the queue - cannot proceed with canCommit", (Object)this.logContext, (Object)cohort.getIdentifier());
                        return;
                    }
                    LOG.debug("{}: Tx {} is now at the head of the queue - proceeding with canCommit", (Object)this.logContext, (Object)cohort.getIdentifier());
                    break;
                }
                if (entry.cohort.getState() != ShardDataTreeCohort.State.READY) {
                    LOG.debug("{}: Skipping pending transaction {} in state {}", new Object[]{this.logContext, entry.cohort.getIdentifier(), entry.cohort.getState()});
                    continue;
                }
                Collection<String> pendingPrecedingShardNames = this.extractPrecedingShardNames(entry.cohort.getParticipatingShardNames());
                if (precedingShardNames.equals(pendingPrecedingShardNames)) {
                    if (moveToIndex < 0) {
                        LOG.debug("{}: Preceding shard names {} for pending tx {} match - saving moveToIndex {}", new Object[]{this.logContext, pendingPrecedingShardNames, entry.cohort.getIdentifier(), index});
                        moveToIndex = index;
                        continue;
                    }
                    LOG.debug("{}: Preceding shard names {} for pending tx {} match but moveToIndex already set to {}", new Object[]{this.logContext, pendingPrecedingShardNames, entry.cohort.getIdentifier(), moveToIndex});
                    continue;
                }
                LOG.debug("{}: Preceding shard names {} for pending tx {} differ - skipping", new Object[]{this.logContext, pendingPrecedingShardNames, entry.cohort.getIdentifier()});
            }
        }
        this.processNextPendingTransaction();
    }

    private static void insertEntry(Deque<CommitEntry> queue, CommitEntry entry, int atIndex) {
        if (atIndex == 0) {
            queue.addFirst(entry);
            return;
        }
        LOG.trace("Inserting into Deque at index {}", (Object)atIndex);
        ArrayDeque<CommitEntry> tempStack = new ArrayDeque<CommitEntry>(atIndex);
        for (int i = 0; i < atIndex; ++i) {
            tempStack.push(queue.poll());
        }
        queue.addFirst(entry);
        tempStack.forEach(queue::addFirst);
    }

    private Collection<String> extractPrecedingShardNames(Optional<SortedSet<String>> participatingShardNames) {
        return participatingShardNames.map(set -> set.headSet(this.shard.getShardName())).orElse(Collections.emptyList());
    }

    private void failPreCommit(Throwable cause) {
        this.shard.getShardMBean().incrementFailedTransactionsCount();
        this.pendingTransactions.poll().cohort.failedPreCommit(cause);
        this.processNextPendingTransaction();
    }

    void startPreCommit(final SimpleShardDataTreeCohort cohort) {
        DataTreeCandidateTip candidate;
        final CommitEntry entry = this.pendingTransactions.peek();
        Preconditions.checkState((entry != null ? 1 : 0) != 0, (String)"Attempted to pre-commit of %s when no transactions pending", (Object)cohort);
        SimpleShardDataTreeCohort current = entry.cohort;
        Verify.verify((boolean)cohort.equals(current), (String)"Attempted to pre-commit %s while %s is pending", (Object)cohort, (Object)current);
        final TransactionIdentifier currentId = current.getIdentifier();
        LOG.debug("{}: Preparing transaction {}", (Object)this.logContext, (Object)currentId);
        try {
            candidate = this.tip.prepare(cohort.getDataTreeModification());
            LOG.debug("{}: Transaction {} candidate ready", (Object)this.logContext, (Object)currentId);
        }
        catch (RuntimeException | DataValidationFailedException e) {
            this.failPreCommit(e);
            return;
        }
        cohort.userPreCommit((DataTreeCandidate)candidate, new FutureCallback<Void>(){

            public void onSuccess(Void noop) {
                ShardDataTree.this.tip = (DataTreeTip)Verify.verifyNotNull((Object)candidate);
                entry.lastAccess = ShardDataTree.this.readTime();
                ShardDataTree.this.pendingTransactions.remove();
                ShardDataTree.this.pendingCommits.add(entry);
                LOG.debug("{}: Transaction {} prepared", (Object)ShardDataTree.this.logContext, (Object)currentId);
                cohort.successfulPreCommit(candidate);
                ShardDataTree.this.processNextPendingTransaction();
            }

            public void onFailure(Throwable failure) {
                ShardDataTree.this.failPreCommit(failure);
            }
        });
    }

    private void failCommit(Exception cause) {
        this.shard.getShardMBean().incrementFailedTransactionsCount();
        this.pendingFinishCommits.poll().cohort.failedCommit(cause);
        this.processNextPending();
    }

    private void finishCommit(SimpleShardDataTreeCohort cohort) {
        TransactionIdentifier txId = cohort.getIdentifier();
        DataTreeCandidateTip candidate = cohort.getCandidate();
        LOG.debug("{}: Resuming commit of transaction {}", (Object)this.logContext, (Object)txId);
        if (this.tip == candidate) {
            this.tip = this.dataTree;
        }
        try {
            this.dataTree.commit((DataTreeCandidate)candidate);
        }
        catch (Exception e) {
            LOG.error("{}: Failed to commit transaction {}", new Object[]{this.logContext, txId, e});
            this.failCommit(e);
            return;
        }
        this.allMetadataCommittedTransaction(txId);
        this.shard.getShardMBean().incrementCommittedTransactionCount();
        this.shard.getShardMBean().setLastCommittedTransactionTime(System.currentTimeMillis());
        this.pendingFinishCommits.poll().cohort.successfulCommit(UnsignedLong.ZERO, () -> this.lambda$finishCommit$6(txId, (DataTreeCandidate)candidate));
    }

    void startCommit(SimpleShardDataTreeCohort cohort, DataTreeCandidate candidate) {
        CommitTransactionPayload payload;
        CommitEntry entry = this.pendingCommits.peek();
        Preconditions.checkState((entry != null ? 1 : 0) != 0, (String)"Attempted to start commit of %s when no transactions pending", (Object)cohort);
        SimpleShardDataTreeCohort current = entry.cohort;
        if (!cohort.equals(current)) {
            LOG.debug("{}: Transaction {} scheduled for commit step", (Object)this.logContext, (Object)cohort.getIdentifier());
            return;
        }
        LOG.debug("{}: Starting commit for transaction {}", (Object)this.logContext, (Object)current.getIdentifier());
        TransactionIdentifier txId = cohort.getIdentifier();
        try {
            payload = CommitTransactionPayload.create(txId, candidate, PayloadVersion.current(), this.shard.getDatastoreContext().getInitialPayloadSerializedBufferCapacity());
        }
        catch (IOException e) {
            LOG.error("{}: Failed to encode transaction {} candidate {}", new Object[]{this.logContext, txId, candidate, e});
            this.pendingCommits.poll().cohort.failedCommit(e);
            this.processNextPending();
            return;
        }
        this.processNextPendingTransaction();
        this.pendingCommits.remove();
        this.pendingFinishCommits.add(entry);
        boolean replicationBatchHint = this.peekNextPendingCommit();
        this.shard.persistPayload((Identifier)txId, (Payload)payload, replicationBatchHint);
        entry.lastAccess = this.shard.ticker().read();
        LOG.debug("{}: Transaction {} submitted to persistence", (Object)this.logContext, (Object)txId);
        this.processNextPendingCommit();
    }

    Collection<ActorRef> getCohortActors() {
        return this.cohortRegistry.getCohortActors();
    }

    void processCohortRegistryCommand(ActorRef sender, DataTreeCohortActorRegistry.CohortRegistryCommand message) {
        this.cohortRegistry.process(sender, message);
    }

    @Override
    ShardDataTreeCohort createFailedCohort(TransactionIdentifier txId, DataTreeModification mod, Exception failure) {
        SimpleShardDataTreeCohort cohort = new SimpleShardDataTreeCohort(this, mod, txId, failure);
        this.pendingTransactions.add(new CommitEntry(cohort, this.readTime()));
        return cohort;
    }

    @Override
    ShardDataTreeCohort createReadyCohort(TransactionIdentifier txId, DataTreeModification mod, Optional<SortedSet<String>> participatingShardNames) {
        SimpleShardDataTreeCohort cohort = new SimpleShardDataTreeCohort(this, mod, txId, this.cohortRegistry.createCohort(this.schemaContext, txId, arg_0 -> ((Shard)this.shard).executeInSelf(arg_0), COMMIT_STEP_TIMEOUT), participatingShardNames);
        this.pendingTransactions.add(new CommitEntry(cohort, this.readTime()));
        return cohort;
    }

    ShardDataTreeCohort newReadyCohort(TransactionIdentifier txId, DataTreeModification mod, Optional<SortedSet<String>> participatingShardNames) {
        if (txId.getHistoryId().getHistoryId() == 0L) {
            return this.createReadyCohort(txId, mod, participatingShardNames);
        }
        return this.ensureTransactionChain(txId.getHistoryId(), null).createReadyCohort(txId, mod, participatingShardNames);
    }

    @SuppressFBWarnings(value={"DB_DUPLICATE_SWITCH_CLAUSES"}, justification="See inline comments below.")
    void checkForExpiredTransactions(long transactionCommitTimeoutMillis, Function<SimpleShardDataTreeCohort, OptionalLong> accessTimeUpdater) {
        long timeout = TimeUnit.MILLISECONDS.toNanos(transactionCommitTimeoutMillis);
        long now = this.readTime();
        Queue<CommitEntry> currentQueue = !this.pendingFinishCommits.isEmpty() ? this.pendingFinishCommits : (!this.pendingCommits.isEmpty() ? this.pendingCommits : this.pendingTransactions);
        CommitEntry currentTx = currentQueue.peek();
        if (currentTx == null) {
            return;
        }
        long delta = now - currentTx.lastAccess;
        if (delta < timeout) {
            return;
        }
        OptionalLong updateOpt = accessTimeUpdater.apply(currentTx.cohort);
        if (updateOpt.isPresent()) {
            long newAccess = updateOpt.getAsLong();
            long newDelta = now - newAccess;
            if (newDelta < delta) {
                LOG.debug("{}: Updated current transaction {} access time", (Object)this.logContext, (Object)currentTx.cohort.getIdentifier());
                currentTx.lastAccess = newAccess;
                delta = newDelta;
            }
            if (delta < timeout) {
                return;
            }
        }
        long deltaMillis = TimeUnit.NANOSECONDS.toMillis(delta);
        ShardDataTreeCohort.State state = currentTx.cohort.getState();
        LOG.warn("{}: Current transaction {} has timed out after {} ms in state {}", new Object[]{this.logContext, currentTx.cohort.getIdentifier(), deltaMillis, state});
        boolean processNext = true;
        TimeoutException cohortFailure = new TimeoutException("Backend timeout in state " + state + " after " + deltaMillis + "ms");
        switch (state) {
            case CAN_COMMIT_PENDING: {
                currentQueue.remove().cohort.failedCanCommit(cohortFailure);
                break;
            }
            case CAN_COMMIT_COMPLETE: {
                currentQueue.remove().cohort.reportFailure(cohortFailure);
                break;
            }
            case PRE_COMMIT_PENDING: {
                currentQueue.remove().cohort.failedPreCommit(cohortFailure);
                break;
            }
            case PRE_COMMIT_COMPLETE: {
                currentQueue.remove().cohort.reportFailure(cohortFailure);
                break;
            }
            case COMMIT_PENDING: {
                LOG.warn("{}: Transaction {} is still committing, cannot abort", (Object)this.logContext, (Object)currentTx.cohort.getIdentifier());
                currentTx.lastAccess = now;
                processNext = false;
                return;
            }
            case READY: {
                currentQueue.remove().cohort.reportFailure(cohortFailure);
                break;
            }
            default: {
                currentQueue.remove();
            }
        }
        if (processNext) {
            this.processNextPending();
        }
    }

    boolean startAbort(SimpleShardDataTreeCohort cohort) {
        Iterator<CommitEntry> it = Iterables.concat(this.pendingFinishCommits, this.pendingCommits, this.pendingTransactions).iterator();
        if (!it.hasNext()) {
            LOG.debug("{}: no open transaction while attempting to abort {}", (Object)this.logContext, (Object)cohort.getIdentifier());
            return true;
        }
        CommitEntry first = (CommitEntry)it.next();
        if (cohort.equals(first.cohort)) {
            if (cohort.getState() != ShardDataTreeCohort.State.COMMIT_PENDING) {
                LOG.debug("{}: aborting head of queue {} in state {}", new Object[]{this.logContext, cohort.getIdentifier(), cohort.getIdentifier()});
                it.remove();
                if (cohort.getCandidate() != null) {
                    this.rebaseTransactions(it, (DataTreeTip)this.dataTree);
                }
                this.processNextPending();
                return true;
            }
            LOG.warn("{}: transaction {} is committing, skipping abort", (Object)this.logContext, (Object)cohort.getIdentifier());
            return false;
        }
        DataTreeTip newTip = (DataTreeTip)MoreObjects.firstNonNull((Object)first.cohort.getCandidate(), (Object)this.dataTree);
        while (it.hasNext()) {
            CommitEntry e = (CommitEntry)it.next();
            if (cohort.equals(e.cohort)) {
                LOG.debug("{}: aborting queued transaction {}", (Object)this.logContext, (Object)cohort.getIdentifier());
                it.remove();
                if (cohort.getCandidate() != null) {
                    this.rebaseTransactions(it, newTip);
                }
                return true;
            }
            newTip = (DataTreeTip)MoreObjects.firstNonNull((Object)e.cohort.getCandidate(), (Object)newTip);
        }
        LOG.debug("{}: aborted transaction {} not found in the queue", (Object)this.logContext, (Object)cohort.getIdentifier());
        return true;
    }

    private void rebaseTransactions(Iterator<CommitEntry> iter, @NonNull DataTreeTip newTip) {
        this.tip = Objects.requireNonNull(newTip);
        while (iter.hasNext()) {
            SimpleShardDataTreeCohort cohort = iter.next().cohort;
            if (cohort.getState() == ShardDataTreeCohort.State.CAN_COMMIT_COMPLETE) {
                LOG.debug("{}: Revalidating queued transaction {}", (Object)this.logContext, (Object)cohort.getIdentifier());
                try {
                    this.tip.validate(cohort.getDataTreeModification());
                }
                catch (RuntimeException | DataValidationFailedException e) {
                    LOG.debug("{}: Failed to revalidate queued transaction {}", new Object[]{this.logContext, cohort.getIdentifier(), e});
                    cohort.reportFailure((Exception)e);
                }
                continue;
            }
            if (cohort.getState() != ShardDataTreeCohort.State.PRE_COMMIT_COMPLETE) continue;
            LOG.debug("{}: Repreparing queued transaction {}", (Object)this.logContext, (Object)cohort.getIdentifier());
            try {
                this.tip.validate(cohort.getDataTreeModification());
                DataTreeCandidateTip candidate = this.tip.prepare(cohort.getDataTreeModification());
                cohort.setNewCandidate(candidate);
                this.tip = candidate;
            }
            catch (RuntimeException | DataValidationFailedException e) {
                LOG.debug("{}: Failed to reprepare queued transaction {}", new Object[]{this.logContext, cohort.getIdentifier(), e});
                cohort.reportFailure((Exception)e);
            }
        }
    }

    void setRunOnPendingTransactionsComplete(Runnable operation) {
        this.runOnPendingTransactionsComplete = operation;
        this.maybeRunOperationOnPendingTransactionsComplete();
    }

    private void maybeRunOperationOnPendingTransactionsComplete() {
        if (this.runOnPendingTransactionsComplete != null && !this.anyPendingTransactions()) {
            LOG.debug("{}: Pending transactions complete - running operation {}", (Object)this.logContext, (Object)this.runOnPendingTransactionsComplete);
            this.runOnPendingTransactionsComplete.run();
            this.runOnPendingTransactionsComplete = null;
        }
    }

    ShardStats getStats() {
        return this.shard.getShardMBean();
    }

    Iterator<SimpleShardDataTreeCohort> cohortIterator() {
        return Iterables.transform((Iterable)Iterables.concat(this.pendingFinishCommits, this.pendingCommits, this.pendingTransactions), e -> e.cohort).iterator();
    }

    void removeTransactionChain(LocalHistoryIdentifier id) {
        if (this.transactionChains.remove(id) != null) {
            LOG.debug("{}: Removed transaction chain {}", (Object)this.logContext, (Object)id);
        }
    }

    private /* synthetic */ void lambda$finishCommit$6(TransactionIdentifier txId, DataTreeCandidate candidate) {
        LOG.trace("{}: Transaction {} committed, proceeding to notify", (Object)this.logContext, (Object)txId);
        this.notifyListeners(candidate);
        this.processNextPending();
    }

    private static final class CommitEntry {
        final SimpleShardDataTreeCohort cohort;
        long lastAccess;

        CommitEntry(SimpleShardDataTreeCohort cohort, long now) {
            this.cohort = Objects.requireNonNull(cohort);
            this.lastAccess = now;
        }

        public String toString() {
            return "CommitEntry [tx=" + this.cohort.getIdentifier() + ", state=" + this.cohort.getState() + "]";
        }
    }
}

