/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.exceptions;

import com.google.common.base.Strings;
import org.opendaylight.controller.cluster.datastore.identifiers.ShardIdentifier;

public class NoShardLeaderException
extends RuntimeException {
    private static final long serialVersionUID = 1L;

    public NoShardLeaderException(String message) {
        super(message);
    }

    public NoShardLeaderException(String message, String shardName) {
        super(String.format("%sShard %s currently has no leader. Try again later.", Strings.isNullOrEmpty((String)message) ? "" : message + ". ", shardName));
    }

    public NoShardLeaderException(ShardIdentifier shardId) {
        this("Shard " + shardId + " currently has no leader. Try again later.");
    }
}

