/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.identifiers;

public class ShardManagerIdentifier {
    private final String type;

    public ShardManagerIdentifier(String type) {
        this.type = type;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ShardManagerIdentifier that = (ShardManagerIdentifier)obj;
        return this.type.equals(that.type);
    }

    public int hashCode() {
        return this.type.hashCode();
    }

    public String toString() {
        return "shardmanager-" + this.type;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String type;

        public Builder type(String newType) {
            this.type = newType;
            return this;
        }

        public ShardManagerIdentifier build() {
            return new ShardManagerIdentifier(this.type);
        }
    }
}

