/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.jmx.mbeans;

import java.util.concurrent.TimeUnit;
import org.opendaylight.controller.cluster.datastore.DatastoreContext;
import org.opendaylight.controller.cluster.datastore.jmx.mbeans.DatastoreConfigurationMXBean;
import org.opendaylight.controller.md.sal.common.util.jmx.AbstractMXBean;

public class DatastoreConfigurationMXBeanImpl
extends AbstractMXBean
implements DatastoreConfigurationMXBean {
    public static final String JMX_CATEGORY_CONFIGURATION = "Configuration";
    private DatastoreContext context;

    public DatastoreConfigurationMXBeanImpl(String mxBeanType) {
        super("Datastore", mxBeanType, JMX_CATEGORY_CONFIGURATION);
    }

    public void setContext(DatastoreContext context) {
        this.context = context;
    }

    @Override
    public long getShardTransactionIdleTimeoutInSeconds() {
        return this.context.getShardTransactionIdleTimeout().toSeconds();
    }

    @Override
    public long getOperationTimeoutInSeconds() {
        return TimeUnit.MILLISECONDS.toSeconds(this.context.getOperationTimeoutInMillis());
    }

    @Override
    public long getShardHeartbeatIntervalInMillis() {
        return this.context.getShardRaftConfig().getHeartBeatInterval().toMillis();
    }

    @Override
    public int getShardJournalRecoveryLogBatchSize() {
        return this.context.getShardRaftConfig().getJournalRecoveryLogBatchSize();
    }

    @Override
    public long getShardIsolatedLeaderCheckIntervalInMillis() {
        return this.context.getShardRaftConfig().getIsolatedCheckIntervalInMillis();
    }

    @Override
    public long getShardElectionTimeoutFactor() {
        return this.context.getShardRaftConfig().getElectionTimeoutFactor();
    }

    @Override
    public int getShardSnapshotDataThresholdPercentage() {
        return this.context.getShardRaftConfig().getSnapshotDataThresholdPercentage();
    }

    @Override
    public int getShardSnapshotDataThreshold() {
        return this.context.getShardRaftConfig().getSnapshotDataThreshold();
    }

    @Override
    public long getShardSnapshotBatchCount() {
        return this.context.getShardRaftConfig().getSnapshotBatchCount();
    }

    @Override
    public long getShardTransactionCommitTimeoutInSeconds() {
        return this.context.getShardTransactionCommitTimeoutInSeconds();
    }

    @Override
    public long getShardCommitQueueExpiryTimeoutInSeconds() {
        return TimeUnit.SECONDS.convert(this.context.getShardCommitQueueExpiryTimeoutInMillis(), TimeUnit.MILLISECONDS);
    }

    @Override
    public int getShardTransactionCommitQueueCapacity() {
        return this.context.getShardTransactionCommitQueueCapacity();
    }

    @Override
    public long getShardInitializationTimeoutInSeconds() {
        return this.context.getShardInitializationTimeout().duration().toSeconds();
    }

    @Override
    public long getShardLeaderElectionTimeoutInSeconds() {
        return this.context.getShardLeaderElectionTimeout().duration().toSeconds();
    }

    @Override
    public boolean isPersistent() {
        return this.context.isPersistent();
    }

    @Override
    public long getTransactionCreationInitialRateLimit() {
        return this.context.getTransactionCreationInitialRateLimit();
    }

    @Override
    public boolean getTransactionContextDebugEnabled() {
        return this.context.isTransactionDebugContextEnabled();
    }

    @Override
    @Deprecated(forRemoval=true)
    public int getMaxShardDataChangeExecutorPoolSize() {
        return 0;
    }

    @Override
    @Deprecated(forRemoval=true)
    public int getMaxShardDataChangeExecutorQueueSize() {
        return 0;
    }

    @Override
    @Deprecated(forRemoval=true)
    public int getMaxShardDataChangeListenerQueueSize() {
        return 0;
    }

    @Override
    @Deprecated(forRemoval=true)
    public int getMaxShardDataStoreExecutorQueueSize() {
        return 0;
    }

    @Override
    public int getMaximumMessageSliceSize() {
        return this.context.getMaximumMessageSliceSize();
    }
}

