/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.messages;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.FluentFuture;
import com.google.common.util.concurrent.SettableFuture;
import org.opendaylight.controller.cluster.datastore.messages.AbstractRead;
import org.opendaylight.controller.cluster.datastore.messages.DataExistsReply;
import org.opendaylight.mdsal.common.api.ReadFailedException;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreReadTransaction;
import org.opendaylight.yangtools.yang.common.RpcError;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;

public class DataExists
extends AbstractRead<Boolean> {
    private static final long serialVersionUID = 1L;

    public DataExists() {
    }

    public DataExists(YangInstanceIdentifier path, short version) {
        super(path, version);
    }

    @Override
    public FluentFuture<Boolean> apply(DOMStoreReadTransaction readDelegate) {
        return readDelegate.exists(this.getPath());
    }

    @Override
    public void processResponse(Object response, SettableFuture<Boolean> returnFuture) {
        if (DataExistsReply.isSerializedType(response)) {
            returnFuture.set((Object)DataExistsReply.fromSerializable(response).exists());
        } else {
            returnFuture.setException((Throwable)new ReadFailedException("Invalid response checking exists for path " + this.getPath(), new RpcError[0]));
        }
    }

    @Override
    protected AbstractRead<Boolean> newInstance(short withVersion) {
        return new DataExists(this.getPath(), withVersion);
    }

    public static DataExists fromSerializable(Object serializable) {
        Preconditions.checkArgument((boolean)(serializable instanceof DataExists));
        return (DataExists)serializable;
    }

    public static boolean isSerializedType(Object message) {
        return message instanceof DataExists;
    }
}

