/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.persisted;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.math.IntMath;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import java.util.Iterator;
import org.opendaylight.controller.cluster.datastore.persisted.ChunkedByteArray;
import org.opendaylight.yangtools.concepts.Variant;

final class ChunkedOutputStream
extends OutputStream {
    static final int MAX_ARRAY_SIZE = IntMath.ceilingPowerOfTwo((int)Integer.getInteger("org.opendaylight.controller.cluster.datastore.persisted.max-array-size", 262144));
    private static final int MIN_ARRAY_SIZE = 32;
    private Object result;
    private Deque<byte[]> prevChunks;
    private byte[] currentChunk;
    private int currentOffset;
    private int size;

    ChunkedOutputStream(int requestedInitialCapacity) {
        this.currentChunk = new byte[ChunkedOutputStream.initialCapacity(requestedInitialCapacity)];
    }

    @Override
    public void write(int b) throws IOException {
        this.checkNotClosed();
        this.ensureOneByte();
        this.currentChunk[this.currentOffset] = (byte)b;
        ++this.currentOffset;
        ++this.size;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        int count;
        if (len < 0) {
            throw new IndexOutOfBoundsException();
        }
        this.checkNotClosed();
        int fromOffset = off;
        for (int toCopy = len; toCopy != 0; toCopy -= count) {
            count = this.ensureMoreBytes(toCopy);
            System.arraycopy(b, fromOffset, this.currentChunk, this.currentOffset, count);
            this.currentOffset += count;
            this.size += count;
            fromOffset += count;
        }
    }

    @Override
    public void close() {
        if (this.result == null) {
            this.result = this.computeResult();
            this.prevChunks = null;
            this.currentChunk = null;
        }
    }

    int size() {
        return this.size;
    }

    ChunkedByteArray toChunkedByteArray() {
        this.checkClosed();
        return new ChunkedByteArray(this.size, (ImmutableList<byte[]>)(this.result instanceof byte[] ? ImmutableList.of((Object)((byte[])this.result)) : (ImmutableList)this.result));
    }

    Variant<byte[], ChunkedByteArray> toVariant() {
        this.checkClosed();
        return this.result instanceof byte[] ? Variant.ofFirst((Object)((byte[])this.result)) : Variant.ofSecond((Object)new ChunkedByteArray(this.size, (ImmutableList<byte[]>)((ImmutableList)this.result)));
    }

    private Object computeResult() {
        byte[] chunk;
        if (this.prevChunks == null) {
            return ChunkedOutputStream.trimChunk(this.currentChunk, this.currentOffset);
        }
        if (this.size <= MAX_ARRAY_SIZE) {
            if (this.currentOffset == 0 && this.prevChunks.size() == 1) {
                return this.prevChunks.getFirst();
            }
            byte[] singleChunk = new byte[this.size];
            int offset = 0;
            for (byte[] chunk2 : this.prevChunks) {
                System.arraycopy(chunk2, 0, singleChunk, offset, chunk2.length);
                offset += chunk2.length;
            }
            System.arraycopy(this.currentChunk, 0, singleChunk, offset, this.currentOffset);
            return singleChunk;
        }
        int headSize = 0;
        int headCount = 0;
        Iterator<byte[]> it = this.prevChunks.iterator();
        while ((chunk = it.next()).length != MAX_ARRAY_SIZE) {
            headSize += chunk.length;
            ++headCount;
            if (it.hasNext()) continue;
        }
        byte[] head = new byte[headSize];
        int offset = 0;
        for (int i = 0; i < headCount; ++i) {
            byte[] chunk3 = this.prevChunks.removeFirst();
            System.arraycopy(chunk3, 0, head, offset, chunk3.length);
            offset += chunk3.length;
        }
        Verify.verify((offset == head.length ? 1 : 0) != 0);
        this.prevChunks.addFirst(head);
        if (this.currentOffset == 0) {
            return ImmutableList.copyOf(this.prevChunks);
        }
        ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)(this.prevChunks.size() + 1));
        builder.addAll(this.prevChunks);
        builder.add((Object)ChunkedOutputStream.trimChunk(this.currentChunk, this.currentOffset));
        return builder.build();
    }

    private void ensureOneByte() {
        if (this.currentChunk.length == this.currentOffset) {
            this.nextChunk(ChunkedOutputStream.nextChunkSize(this.currentChunk.length));
        }
    }

    private int ensureMoreBytes(int requested) {
        int count;
        int available = this.currentChunk.length - this.currentOffset;
        if (available == 0) {
            this.nextChunk(ChunkedOutputStream.nextChunkSize(this.currentChunk.length, requested));
            available = this.currentChunk.length;
        }
        Verify.verify(((count = Math.min(requested, available)) > 0 ? 1 : 0) != 0);
        return count;
    }

    private void nextChunk(int chunkSize) {
        if (this.prevChunks == null) {
            this.prevChunks = new ArrayDeque<byte[]>();
        }
        this.prevChunks.addLast(this.currentChunk);
        this.currentChunk = new byte[chunkSize];
        this.currentOffset = 0;
    }

    private void checkClosed() {
        Preconditions.checkState((this.result != null ? 1 : 0) != 0, (Object)"Stream has not been closed yet");
    }

    private void checkNotClosed() throws IOException {
        if (this.result != null) {
            throw new IOException("Stream is already closed");
        }
    }

    private static int nextChunkSize(int currentSize, int requested) {
        return currentSize == MAX_ARRAY_SIZE || requested >= MAX_ARRAY_SIZE ? MAX_ARRAY_SIZE : Math.max(currentSize * 2, IntMath.ceilingPowerOfTwo((int)requested));
    }

    private static int nextChunkSize(int currentSize) {
        return currentSize < MAX_ARRAY_SIZE ? currentSize * 2 : MAX_ARRAY_SIZE;
    }

    private static int initialCapacity(int requestedSize) {
        if (requestedSize < 32) {
            return 32;
        }
        if (requestedSize > MAX_ARRAY_SIZE) {
            return MAX_ARRAY_SIZE;
        }
        return IntMath.ceilingPowerOfTwo((int)requestedSize);
    }

    private static byte[] trimChunk(byte[] chunk, int length) {
        return chunk.length == length ? chunk : Arrays.copyOf(chunk, length);
    }
}

