/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.persisted;

import com.google.common.annotations.Beta;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Verify;
import com.google.common.io.ByteStreams;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.util.AbstractMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;
import org.opendaylight.controller.cluster.datastore.persisted.ChunkedByteArray;
import org.opendaylight.controller.cluster.datastore.persisted.ChunkedOutputStream;
import org.opendaylight.controller.cluster.datastore.persisted.DataTreeCandidateInputOutput;
import org.opendaylight.controller.cluster.datastore.persisted.PayloadVersion;
import org.opendaylight.controller.cluster.raft.protobuff.client.messages.IdentifiablePayload;
import org.opendaylight.yangtools.concepts.Variant;
import org.opendaylight.yangtools.yang.data.api.schema.stream.ReusableStreamReceiver;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeCandidate;
import org.opendaylight.yangtools.yang.data.impl.schema.ReusableImmutableNormalizedNodeStreamWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public abstract class CommitTransactionPayload
extends IdentifiablePayload<TransactionIdentifier>
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(CommitTransactionPayload.class);
    private static final long serialVersionUID = 1L;
    private volatile Map.Entry<TransactionIdentifier, DataTreeCandidateInputOutput.DataTreeCandidateWithVersion> candidate = null;

    CommitTransactionPayload() {
    }

    public static @NonNull CommitTransactionPayload create(TransactionIdentifier transactionId, DataTreeCandidate candidate, PayloadVersion version, int initialSerializedBufferCapacity) throws IOException {
        ChunkedOutputStream cos = new ChunkedOutputStream(initialSerializedBufferCapacity);
        try (DataOutputStream dos = new DataOutputStream(cos);){
            transactionId.writeTo((DataOutput)dos);
            DataTreeCandidateInputOutput.writeDataTreeCandidate(dos, version, candidate);
        }
        Variant<byte[], ChunkedByteArray> source = cos.toVariant();
        LOG.debug("Initial buffer capacity {}, actual serialized size {}", (Object)initialSerializedBufferCapacity, (Object)cos.size());
        return source.isFirst() ? new Simple((byte[])source.getFirst()) : new Chunked((ChunkedByteArray)source.getSecond());
    }

    @VisibleForTesting
    public static @NonNull CommitTransactionPayload create(TransactionIdentifier transactionId, DataTreeCandidate candidate, PayloadVersion version) throws IOException {
        return CommitTransactionPayload.create(transactionId, candidate, version, 512);
    }

    @VisibleForTesting
    public static @NonNull CommitTransactionPayload create(TransactionIdentifier transactionId, DataTreeCandidate candidate) throws IOException {
        return CommitTransactionPayload.create(transactionId, candidate, PayloadVersion.current());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public  @NonNull Map.Entry<TransactionIdentifier, DataTreeCandidateInputOutput.DataTreeCandidateWithVersion> getCandidate() throws IOException {
        Map.Entry<TransactionIdentifier, DataTreeCandidateInputOutput.DataTreeCandidateWithVersion> localCandidate = this.candidate;
        if (localCandidate == null) {
            CommitTransactionPayload commitTransactionPayload = this;
            synchronized (commitTransactionPayload) {
                localCandidate = this.candidate;
                if (localCandidate == null) {
                    this.candidate = localCandidate = this.getCandidate((ReusableStreamReceiver)ReusableImmutableNormalizedNodeStreamWriter.create());
                }
            }
        }
        return localCandidate;
    }

    public final  @NonNull Map.Entry<TransactionIdentifier, DataTreeCandidateInputOutput.DataTreeCandidateWithVersion> getCandidate(ReusableStreamReceiver receiver) throws IOException {
        DataInput in = this.newDataInput();
        return new AbstractMap.SimpleImmutableEntry<TransactionIdentifier, DataTreeCandidateInputOutput.DataTreeCandidateWithVersion>(TransactionIdentifier.readFrom((DataInput)in), DataTreeCandidateInputOutput.readDataTreeCandidate(in, receiver));
    }

    public TransactionIdentifier getIdentifier() {
        try {
            return this.getCandidate().getKey();
        }
        catch (IOException e) {
            throw new IllegalStateException("Candidate deserialization failed.", e);
        }
    }

    public Map.Entry<TransactionIdentifier, DataTreeCandidateInputOutput.DataTreeCandidateWithVersion> acquireCandidate() throws IOException {
        Map.Entry<TransactionIdentifier, DataTreeCandidateInputOutput.DataTreeCandidateWithVersion> localCandidate = this.getCandidate();
        this.candidate = null;
        return localCandidate;
    }

    abstract void writeBytes(ObjectOutput var1) throws IOException;

    abstract DataInput newDataInput();

    final Object writeReplace() {
        return new Proxy(this);
    }

    private static final class Proxy
    implements Externalizable {
        private static final long serialVersionUID = 1L;
        private CommitTransactionPayload payload;

        public Proxy() {
        }

        Proxy(CommitTransactionPayload payload) {
            this.payload = Objects.requireNonNull(payload);
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.payload.size());
            this.payload.writeBytes(out);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException {
            int length = in.readInt();
            if (length < 0) {
                throw new StreamCorruptedException("Invalid payload length " + length);
            }
            if (length < ChunkedOutputStream.MAX_ARRAY_SIZE) {
                byte[] serialized = new byte[length];
                in.readFully(serialized);
                this.payload = new Simple(serialized);
            } else {
                this.payload = new Chunked(ChunkedByteArray.readFrom(in, length, ChunkedOutputStream.MAX_ARRAY_SIZE));
            }
        }

        private Object readResolve() {
            return Verify.verifyNotNull((Object)this.payload);
        }
    }

    private static final class Chunked
    extends CommitTransactionPayload {
        private static final long serialVersionUID = 1L;
        @SuppressFBWarnings(value={"SE_BAD_FIELD"}, justification="Handled via serialization proxy")
        private final ChunkedByteArray source;

        Chunked(ChunkedByteArray source) {
            this.source = Objects.requireNonNull(source);
        }

        @Override
        void writeBytes(ObjectOutput out) throws IOException {
            this.source.copyTo(out);
        }

        public int size() {
            return this.source.size();
        }

        @Override
        DataInput newDataInput() {
            return new DataInputStream(this.source.openStream());
        }
    }

    private static final class Simple
    extends CommitTransactionPayload {
        private static final long serialVersionUID = 1L;
        private final byte[] serialized;

        Simple(byte[] serialized) {
            this.serialized = Objects.requireNonNull(serialized);
        }

        public int size() {
            return this.serialized.length;
        }

        @Override
        DataInput newDataInput() {
            return ByteStreams.newDataInput((byte[])this.serialized);
        }

        @Override
        void writeBytes(ObjectOutput out) throws IOException {
            out.write(this.serialized);
        }
    }
}

