/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.shardstrategy;

import com.google.common.base.Preconditions;
import java.util.Objects;
import org.opendaylight.controller.cluster.datastore.config.Configuration;
import org.opendaylight.controller.cluster.datastore.shardstrategy.DefaultShardStrategy;
import org.opendaylight.controller.cluster.datastore.shardstrategy.ModuleShardStrategy;
import org.opendaylight.controller.cluster.datastore.shardstrategy.ShardStrategy;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.dom.api.DOMDataTreeIdentifier;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;

public class ShardStrategyFactory {
    private static final String UNKNOWN_MODULE_NAME = "unknown";
    private final Configuration configuration;
    private final LogicalDatastoreType logicalStoreType;

    public ShardStrategyFactory(Configuration configuration, LogicalDatastoreType logicalStoreType) {
        Preconditions.checkState((configuration != null ? 1 : 0) != 0, (Object)"configuration should not be missing");
        this.configuration = configuration;
        this.logicalStoreType = Objects.requireNonNull(logicalStoreType);
    }

    public ShardStrategy getStrategy(YangInstanceIdentifier path) {
        String moduleName = this.getModuleName(Objects.requireNonNull(path, "path should not be null"));
        ShardStrategy shardStrategy = this.configuration.getStrategyForModule(moduleName);
        if (shardStrategy == null) {
            ShardStrategy strategyForPrefix = this.configuration.getStrategyForPrefix(new DOMDataTreeIdentifier(this.logicalStoreType, path));
            if (strategyForPrefix == null) {
                return DefaultShardStrategy.getInstance();
            }
            return strategyForPrefix;
        }
        return shardStrategy;
    }

    public static ShardStrategy newShardStrategyInstance(String moduleName, String strategyName, Configuration configuration) {
        if ("module".equals(strategyName)) {
            return new ModuleShardStrategy(moduleName, configuration);
        }
        return DefaultShardStrategy.getInstance();
    }

    private String getModuleName(YangInstanceIdentifier path) {
        if (path.isEmpty()) {
            return UNKNOWN_MODULE_NAME;
        }
        String namespace = ((YangInstanceIdentifier.PathArgument)path.getPathArguments().get(0)).getNodeType().getNamespace().toASCIIString();
        String moduleName = this.configuration.getModuleNameFromNameSpace(namespace);
        return moduleName != null ? moduleName : UNKNOWN_MODULE_NAME;
    }
}

