/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.sharding;

import org.opendaylight.controller.cluster.databroker.actors.dds.ClientTransaction;
import org.opendaylight.mdsal.dom.api.DOMDataTreeIdentifier;
import org.opendaylight.mdsal.dom.api.DOMDataTreeWriteCursor;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreThreePhaseCommitCohort;

public class DistributedShardModificationContext {
    private ClientTransaction transaction;
    private DOMDataTreeIdentifier identifier;
    private DOMDataTreeWriteCursor cursor;

    public DistributedShardModificationContext(ClientTransaction transaction, DOMDataTreeIdentifier identifier) {
        this.transaction = transaction;
        this.identifier = identifier;
    }

    public DOMDataTreeIdentifier getIdentifier() {
        return this.identifier;
    }

    DOMDataTreeWriteCursor cursor() {
        if (this.cursor == null) {
            this.cursor = this.transaction.openCursor();
        }
        return this.cursor;
    }

    DOMStoreThreePhaseCommitCohort ready() {
        if (this.cursor != null) {
            this.cursor.close();
            this.cursor = null;
        }
        return this.transaction.ready();
    }

    void closeCursor() {
        if (this.cursor != null) {
            this.cursor.close();
            this.cursor = null;
        }
    }
}

