/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.sharding;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.PoisonPill;
import akka.actor.Props;
import akka.dispatch.Mapper;
import akka.dispatch.OnComplete;
import akka.pattern.Patterns;
import akka.util.Timeout;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ClassToInstanceMap;
import com.google.common.collect.ForwardingObject;
import com.google.common.collect.ImmutableClassToInstanceMap;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import com.google.common.util.concurrent.Uninterruptibles;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.checkerframework.checker.lock.qual.GuardedBy;
import org.opendaylight.controller.cluster.ActorSystemProvider;
import org.opendaylight.controller.cluster.access.concepts.MemberName;
import org.opendaylight.controller.cluster.databroker.actors.dds.DataStoreClient;
import org.opendaylight.controller.cluster.databroker.actors.dds.SimpleDataStoreClientActor;
import org.opendaylight.controller.cluster.datastore.DistributedDataStoreInterface;
import org.opendaylight.controller.cluster.datastore.Shard;
import org.opendaylight.controller.cluster.datastore.config.Configuration;
import org.opendaylight.controller.cluster.datastore.config.ModuleShardConfiguration;
import org.opendaylight.controller.cluster.datastore.messages.CreateShard;
import org.opendaylight.controller.cluster.datastore.utils.ActorUtils;
import org.opendaylight.controller.cluster.datastore.utils.ClusterUtils;
import org.opendaylight.controller.cluster.dom.api.CDSDataTreeProducer;
import org.opendaylight.controller.cluster.dom.api.CDSShardAccess;
import org.opendaylight.controller.cluster.sharding.CDSShardAccessImpl;
import org.opendaylight.controller.cluster.sharding.DOMDataTreeShardCreationFailedException;
import org.opendaylight.controller.cluster.sharding.DistributedShardFactory;
import org.opendaylight.controller.cluster.sharding.DistributedShardFrontend;
import org.opendaylight.controller.cluster.sharding.DistributedShardRegistration;
import org.opendaylight.controller.cluster.sharding.PrefixedShardConfigUpdateHandler;
import org.opendaylight.controller.cluster.sharding.PrefixedShardConfigWriter;
import org.opendaylight.controller.cluster.sharding.ShardedDataTreeActor;
import org.opendaylight.controller.cluster.sharding.messages.InitConfigListener;
import org.opendaylight.controller.cluster.sharding.messages.LookupPrefixShard;
import org.opendaylight.controller.cluster.sharding.messages.PrefixShardRemovalLookup;
import org.opendaylight.controller.cluster.sharding.messages.ProducerCreated;
import org.opendaylight.controller.cluster.sharding.messages.ProducerRemoved;
import org.opendaylight.controller.cluster.sharding.messages.StartConfigShardLookup;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.dom.api.DOMDataTreeCursorAwareTransaction;
import org.opendaylight.mdsal.dom.api.DOMDataTreeIdentifier;
import org.opendaylight.mdsal.dom.api.DOMDataTreeListener;
import org.opendaylight.mdsal.dom.api.DOMDataTreeLoopException;
import org.opendaylight.mdsal.dom.api.DOMDataTreeProducer;
import org.opendaylight.mdsal.dom.api.DOMDataTreeProducerException;
import org.opendaylight.mdsal.dom.api.DOMDataTreeService;
import org.opendaylight.mdsal.dom.api.DOMDataTreeServiceExtension;
import org.opendaylight.mdsal.dom.api.DOMDataTreeShard;
import org.opendaylight.mdsal.dom.api.DOMDataTreeShardingConflictException;
import org.opendaylight.mdsal.dom.api.DOMDataTreeShardingService;
import org.opendaylight.mdsal.dom.broker.DOMDataTreeShardRegistration;
import org.opendaylight.mdsal.dom.broker.ShardedDOMDataTree;
import org.opendaylight.mdsal.dom.spi.DOMDataTreePrefixTable;
import org.opendaylight.mdsal.dom.spi.DOMDataTreePrefixTableEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.clustering.prefix.shard.configuration.rev170110.PrefixShards;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.compat.java8.FutureConverters;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.duration.FiniteDuration;

public class DistributedShardedDOMDataTree
implements DOMDataTreeService,
DOMDataTreeShardingService,
DistributedShardFactory {
    private static final Logger LOG = LoggerFactory.getLogger(DistributedShardedDOMDataTree.class);
    private static final int MAX_ACTOR_CREATION_RETRIES = 100;
    private static final int ACTOR_RETRY_DELAY = 100;
    private static final TimeUnit ACTOR_RETRY_TIME_UNIT = TimeUnit.MILLISECONDS;
    private static final int LOOKUP_TASK_MAX_RETRIES = 100;
    static final FiniteDuration SHARD_FUTURE_TIMEOUT_DURATION = new FiniteDuration(30000L, TimeUnit.SECONDS);
    static final Timeout SHARD_FUTURE_TIMEOUT = new Timeout(SHARD_FUTURE_TIMEOUT_DURATION);
    static final String ACTOR_ID = "ShardedDOMDataTreeFrontend";
    private final ShardedDOMDataTree shardedDOMDataTree;
    private final ActorSystem actorSystem;
    private final DistributedDataStoreInterface distributedOperDatastore;
    private final DistributedDataStoreInterface distributedConfigDatastore;
    private final ActorRef shardedDataTreeActor;
    private final MemberName memberName;
    private final @GuardedBy(value={"shards"}) DOMDataTreePrefixTable<DOMDataTreeShardRegistration<DOMDataTreeShard>> shards = DOMDataTreePrefixTable.create();
    private final EnumMap<LogicalDatastoreType, Map.Entry<DataStoreClient, ActorRef>> configurationShardMap = new EnumMap(LogicalDatastoreType.class);
    private final EnumMap<LogicalDatastoreType, PrefixedShardConfigWriter> writerMap = new EnumMap(LogicalDatastoreType.class);
    private final PrefixedShardConfigUpdateHandler updateHandler;

    public DistributedShardedDOMDataTree(ActorSystemProvider actorSystemProvider, DistributedDataStoreInterface distributedOperDatastore, DistributedDataStoreInterface distributedConfigDatastore) {
        this.actorSystem = Objects.requireNonNull(actorSystemProvider).getActorSystem();
        this.distributedOperDatastore = Objects.requireNonNull(distributedOperDatastore);
        this.distributedConfigDatastore = Objects.requireNonNull(distributedConfigDatastore);
        this.shardedDOMDataTree = new ShardedDOMDataTree();
        this.shardedDataTreeActor = DistributedShardedDOMDataTree.createShardedDataTreeActor(this.actorSystem, new ShardedDataTreeActor.ShardedDataTreeActorCreator().setShardingService(this).setActorSystem(this.actorSystem).setClusterWrapper(distributedConfigDatastore.getActorUtils().getClusterWrapper()).setDistributedConfigDatastore(distributedConfigDatastore).setDistributedOperDatastore(distributedOperDatastore).setLookupTaskMaxRetries(100), ACTOR_ID);
        this.memberName = distributedConfigDatastore.getActorUtils().getCurrentMemberName();
        this.updateHandler = new PrefixedShardConfigUpdateHandler(this.shardedDataTreeActor, distributedConfigDatastore.getActorUtils().getCurrentMemberName());
        LOG.debug("{} - Starting prefix configuration shards", (Object)this.memberName);
        DistributedShardedDOMDataTree.createPrefixConfigShard(distributedConfigDatastore);
        DistributedShardedDOMDataTree.createPrefixConfigShard(distributedOperDatastore);
    }

    private static void createPrefixConfigShard(DistributedDataStoreInterface dataStore) {
        Configuration configuration = dataStore.getActorUtils().getConfiguration();
        Collection<MemberName> memberNames = configuration.getUniqueMemberNamesForAllShards();
        CreateShard createShardMessage = new CreateShard(new ModuleShardConfiguration(PrefixShards.QNAME.getNamespace(), "prefix-shard-configuration", "prefix-configuration-shard", "module", memberNames), Shard.builder(), dataStore.getActorUtils().getDatastoreContext());
        dataStore.getActorUtils().getShardManager().tell((Object)createShardMessage, ActorRef.noSender());
    }

    public void init() {
        try {
            LOG.debug("{} - starting config shard lookup.", (Object)this.memberName);
            this.handleConfigShardLookup().get(SHARD_FUTURE_TIMEOUT_DURATION.length(), SHARD_FUTURE_TIMEOUT_DURATION.unit());
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            throw new IllegalStateException("Prefix config shards not found", e);
        }
        try {
            LOG.debug("{}: Prefix configuration shards ready - creating clients", (Object)this.memberName);
            this.configurationShardMap.put(LogicalDatastoreType.CONFIGURATION, this.createDatastoreClient("prefix-configuration-shard", this.distributedConfigDatastore.getActorUtils()));
        }
        catch (DOMDataTreeShardCreationFailedException e) {
            throw new IllegalStateException("Unable to create datastoreClient for config DS prefix configuration shard.", e);
        }
        try {
            this.configurationShardMap.put(LogicalDatastoreType.OPERATIONAL, this.createDatastoreClient("prefix-configuration-shard", this.distributedOperDatastore.getActorUtils()));
        }
        catch (DOMDataTreeShardCreationFailedException e) {
            throw new IllegalStateException("Unable to create datastoreClient for oper DS prefix configuration shard.", e);
        }
        this.writerMap.put(LogicalDatastoreType.CONFIGURATION, new PrefixedShardConfigWriter(this.configurationShardMap.get(LogicalDatastoreType.CONFIGURATION).getKey()));
        this.writerMap.put(LogicalDatastoreType.OPERATIONAL, new PrefixedShardConfigWriter(this.configurationShardMap.get(LogicalDatastoreType.OPERATIONAL).getKey()));
        this.updateHandler.initListener(this.distributedConfigDatastore, LogicalDatastoreType.CONFIGURATION);
        this.updateHandler.initListener(this.distributedOperDatastore, LogicalDatastoreType.OPERATIONAL);
        this.distributedConfigDatastore.getActorUtils().getShardManager().tell((Object)InitConfigListener.INSTANCE, ActorRef.noSender());
        this.distributedOperDatastore.getActorUtils().getShardManager().tell((Object)InitConfigListener.INSTANCE, ActorRef.noSender());
        this.initDefaultShard(LogicalDatastoreType.CONFIGURATION);
        this.initDefaultShard(LogicalDatastoreType.OPERATIONAL);
    }

    private ListenableFuture<List<Void>> handleConfigShardLookup() {
        ListenableFuture<Void> configFuture = this.lookupConfigShard(LogicalDatastoreType.CONFIGURATION);
        ListenableFuture<Void> operFuture = this.lookupConfigShard(LogicalDatastoreType.OPERATIONAL);
        return Futures.allAsList((ListenableFuture[])new ListenableFuture[]{configFuture, operFuture});
    }

    private ListenableFuture<Void> lookupConfigShard(LogicalDatastoreType type) {
        final SettableFuture future = SettableFuture.create();
        Future ask = Patterns.ask((ActorRef)this.shardedDataTreeActor, (Object)new StartConfigShardLookup(type), (Timeout)SHARD_FUTURE_TIMEOUT);
        ask.onComplete((Function1)new OnComplete<Object>(){

            public void onComplete(Throwable throwable, Object result) {
                if (throwable != null) {
                    future.setException(throwable);
                } else {
                    future.set(null);
                }
            }
        }, (ExecutionContext)this.actorSystem.dispatcher());
        return future;
    }

    public <T extends DOMDataTreeListener> ListenerRegistration<T> registerListener(T listener, Collection<DOMDataTreeIdentifier> subtrees, boolean allowRxMerges, Collection<DOMDataTreeProducer> producers) throws DOMDataTreeLoopException {
        return this.shardedDOMDataTree.registerListener(listener, subtrees, allowRxMerges, producers);
    }

    public ClassToInstanceMap<DOMDataTreeServiceExtension> getExtensions() {
        return ImmutableClassToInstanceMap.of();
    }

    public DOMDataTreeProducer createProducer(Collection<DOMDataTreeIdentifier> subtrees) {
        LOG.debug("{} - Creating producer for {}", (Object)this.memberName, subtrees);
        DOMDataTreeProducer producer = this.shardedDOMDataTree.createProducer(subtrees);
        Object response = this.distributedConfigDatastore.getActorUtils().executeOperation(this.shardedDataTreeActor, (Object)new ProducerCreated(subtrees));
        if (response == null) {
            LOG.debug("{} - Received success from remote nodes, creating producer:{}", (Object)this.memberName, subtrees);
            return new ProxyProducer(producer, subtrees, this.shardedDataTreeActor, this.distributedConfigDatastore.getActorUtils(), this.shards);
        }
        DistributedShardedDOMDataTree.closeProducer(producer);
        if (response instanceof Throwable) {
            Throwables.throwIfUnchecked((Throwable)((Throwable)response));
            throw new RuntimeException((Throwable)response);
        }
        throw new RuntimeException("Unexpected response to create producer received." + response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletionStage<DistributedShardRegistration> createDistributedShard(final DOMDataTreeIdentifier prefix, Collection<MemberName> replicaMembers) throws DOMDataTreeShardingConflictException {
        DOMDataTreePrefixTable<DOMDataTreeShardRegistration<DOMDataTreeShard>> dOMDataTreePrefixTable = this.shards;
        synchronized (dOMDataTreePrefixTable) {
            DOMDataTreePrefixTableEntry lookup = this.shards.lookup(prefix);
            if (lookup != null && ((DOMDataTreeShardRegistration)lookup.getValue()).getPrefix().equals((Object)prefix)) {
                throw new DOMDataTreeShardingConflictException("Prefix " + prefix + " is already occupied by another shard.");
            }
        }
        PrefixedShardConfigWriter writer = this.writerMap.get(prefix.getDatastoreType());
        ListenableFuture<Void> writeFuture = writer.writeConfig(prefix.getRootIdentifier(), replicaMembers);
        final Promise shardRegistrationPromise = akka.dispatch.Futures.promise();
        Futures.addCallback(writeFuture, (FutureCallback)new FutureCallback<Void>(){

            public void onSuccess(Void result) {
                Future ask = Patterns.ask((ActorRef)DistributedShardedDOMDataTree.this.shardedDataTreeActor, (Object)new LookupPrefixShard(prefix), (Timeout)SHARD_FUTURE_TIMEOUT);
                shardRegistrationPromise.completeWith(ask.transform((Function1)new Mapper<Object, DistributedShardRegistration>(){

                    public DistributedShardRegistration apply(Object parameter) {
                        return new DistributedShardRegistrationImpl(prefix, DistributedShardedDOMDataTree.this.shardedDataTreeActor, DistributedShardedDOMDataTree.this);
                    }
                }, (Function1)new Mapper<Throwable, Throwable>(){

                    public Throwable apply(Throwable throwable) {
                        return new DOMDataTreeShardCreationFailedException("Unable to create a cds shard.", throwable);
                    }
                }, (ExecutionContext)DistributedShardedDOMDataTree.this.actorSystem.dispatcher()));
            }

            public void onFailure(Throwable throwable) {
                shardRegistrationPromise.failure((Throwable)new DOMDataTreeShardCreationFailedException("Unable to create a cds shard.", throwable));
            }
        }, (Executor)MoreExecutors.directExecutor());
        return FutureConverters.toJava((Future)shardRegistrationPromise.future());
    }

    void resolveShardAdditions(Set<DOMDataTreeIdentifier> additions) {
        LOG.debug("{}: Resolving additions : {}", (Object)this.memberName, additions);
        additions.stream().sorted(Comparator.comparingInt(o -> o.getRootIdentifier().getPathArguments().size())).forEachOrdered(this::createShardFrontend);
    }

    void resolveShardRemovals(Set<DOMDataTreeIdentifier> removals) {
        LOG.debug("{}: Resolving removals : {}", (Object)this.memberName, removals);
        removals.forEach(this::despawnShardFrontend);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createShardFrontend(DOMDataTreeIdentifier prefix) {
        LOG.debug("{}: Creating CDS shard for prefix: {}", (Object)this.memberName, (Object)prefix);
        String shardName = ClusterUtils.getCleanShardName(prefix.getRootIdentifier());
        DistributedDataStoreInterface distributedDataStore = prefix.getDatastoreType().equals((Object)LogicalDatastoreType.CONFIGURATION) ? this.distributedConfigDatastore : this.distributedOperDatastore;
        try (DOMDataTreeProducer producer = this.localCreateProducer(Collections.singletonList(prefix));){
            Map.Entry<DataStoreClient, ActorRef> entry = this.createDatastoreClient(shardName, distributedDataStore.getActorUtils());
            DistributedShardFrontend shard = new DistributedShardFrontend(distributedDataStore, entry.getKey(), prefix);
            DOMDataTreeShardRegistration reg = this.shardedDOMDataTree.registerDataTreeShard(prefix, (DOMDataTreeShard)shard, producer);
            DOMDataTreePrefixTable<DOMDataTreeShardRegistration<DOMDataTreeShard>> dOMDataTreePrefixTable = this.shards;
            synchronized (dOMDataTreePrefixTable) {
                this.shards.store(prefix, (Object)reg);
            }
        }
        catch (DOMDataTreeShardingConflictException e) {
            LOG.error("{}: Prefix {} is already occupied by another shard", new Object[]{this.distributedConfigDatastore.getActorUtils().getClusterWrapper().getCurrentMemberName(), prefix, e});
        }
        catch (DOMDataTreeProducerException e) {
            LOG.error("Unable to close producer", (Throwable)e);
        }
        catch (DOMDataTreeShardCreationFailedException e) {
            LOG.error("Unable to create datastore client for shard {}", (Object)prefix, (Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void despawnShardFrontend(final DOMDataTreeIdentifier prefix) {
        DOMDataTreePrefixTableEntry lookup;
        LOG.debug("{}: Removing CDS shard for prefix: {}", (Object)this.memberName, (Object)prefix);
        DOMDataTreePrefixTable<DOMDataTreeShardRegistration<DOMDataTreeShard>> dOMDataTreePrefixTable = this.shards;
        synchronized (dOMDataTreePrefixTable) {
            lookup = this.shards.lookup(prefix);
        }
        if (lookup == null || !((DOMDataTreeShardRegistration)lookup.getValue()).getPrefix().equals((Object)prefix)) {
            LOG.debug("{}: Received despawn for non-existing CDS shard frontend, prefix: {}, ignoring..", (Object)this.memberName, (Object)prefix);
            return;
        }
        ((DOMDataTreeShardRegistration)lookup.getValue()).close();
        dOMDataTreePrefixTable = this.shards;
        synchronized (dOMDataTreePrefixTable) {
            this.shards.remove(prefix);
        }
        PrefixedShardConfigWriter writer = this.writerMap.get(prefix.getDatastoreType());
        ListenableFuture<Void> future = writer.removeConfig(prefix.getRootIdentifier());
        Futures.addCallback(future, (FutureCallback)new FutureCallback<Void>(){

            public void onSuccess(Void result) {
                LOG.debug("{} - Succesfuly removed shard for {}", (Object)DistributedShardedDOMDataTree.this.memberName, (Object)prefix);
            }

            public void onFailure(Throwable throwable) {
                LOG.error("Removal of shard {} from configuration failed.", (Object)prefix, (Object)throwable);
            }
        }, (Executor)MoreExecutors.directExecutor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DOMDataTreePrefixTableEntry<DOMDataTreeShardRegistration<DOMDataTreeShard>> lookupShardFrontend(DOMDataTreeIdentifier prefix) {
        DOMDataTreePrefixTable<DOMDataTreeShardRegistration<DOMDataTreeShard>> dOMDataTreePrefixTable = this.shards;
        synchronized (dOMDataTreePrefixTable) {
            return this.shards.lookup(prefix);
        }
    }

    DOMDataTreeProducer localCreateProducer(Collection<DOMDataTreeIdentifier> prefix) {
        return this.shardedDOMDataTree.createProducer(prefix);
    }

    public <T extends DOMDataTreeShard> ListenerRegistration<T> registerDataTreeShard(DOMDataTreeIdentifier prefix, T shard, DOMDataTreeProducer producer) throws DOMDataTreeShardingConflictException {
        LOG.debug("Registering shard[{}] at prefix: {}", shard, (Object)prefix);
        if (producer instanceof ProxyProducer) {
            return this.shardedDOMDataTree.registerDataTreeShard(prefix, shard, ((ProxyProducer)producer).delegate());
        }
        return this.shardedDOMDataTree.registerDataTreeShard(prefix, shard, producer);
    }

    private Map.Entry<DataStoreClient, ActorRef> createDatastoreClient(String shardName, ActorUtils actorUtils) throws DOMDataTreeShardCreationFailedException {
        LOG.debug("{}: Creating distributed datastore client for shard {}", (Object)this.memberName, (Object)shardName);
        Props distributedDataStoreClientProps = SimpleDataStoreClientActor.props(this.memberName, "Shard-" + shardName, actorUtils, shardName);
        ActorRef clientActor = this.actorSystem.actorOf(distributedDataStoreClientProps);
        try {
            return new AbstractMap.SimpleEntry<DataStoreClient, ActorRef>(SimpleDataStoreClientActor.getDistributedDataStoreClient(clientActor, 30L, TimeUnit.SECONDS), clientActor);
        }
        catch (Exception e) {
            LOG.error("{}: Failed to get actor for {}", new Object[]{distributedDataStoreClientProps, this.memberName, e});
            clientActor.tell((Object)PoisonPill.getInstance(), ActorRef.noSender());
            throw new DOMDataTreeShardCreationFailedException("Unable to create datastore client for shard{" + shardName + "}", e);
        }
    }

    private void initDefaultShard(LogicalDatastoreType logicalDatastoreType) {
        PrefixedShardConfigWriter writer = this.writerMap.get(logicalDatastoreType);
        if (writer.checkDefaultIsPresent()) {
            LOG.debug("{}: Default shard for {} is already present in the config. Possibly saved in snapshot.", (Object)this.memberName, (Object)logicalDatastoreType);
        } else {
            try {
                ActorUtils actorUtils = logicalDatastoreType == LogicalDatastoreType.CONFIGURATION ? this.distributedConfigDatastore.getActorUtils() : this.distributedOperDatastore.getActorUtils();
                Optional<ActorRef> defaultLocalShardOptional = actorUtils.findLocalShard(ClusterUtils.getCleanShardName(YangInstanceIdentifier.empty()));
                if (defaultLocalShardOptional.isPresent()) {
                    LOG.debug("{}: Default shard for {} is already started, creating just frontend", (Object)this.memberName, (Object)logicalDatastoreType);
                    this.createShardFrontend(new DOMDataTreeIdentifier(logicalDatastoreType, YangInstanceIdentifier.empty()));
                }
            }
            catch (Exception e) {
                LOG.error("{}: Default shard initialization for {} failed", new Object[]{this.memberName, logicalDatastoreType, e});
                throw new RuntimeException(e);
            }
        }
    }

    private static void closeProducer(DOMDataTreeProducer producer) {
        try {
            producer.close();
        }
        catch (DOMDataTreeProducerException e) {
            LOG.error("Unable to close producer", (Throwable)e);
        }
    }

    private static ActorRef createShardedDataTreeActor(ActorSystem actorSystem, ShardedDataTreeActor.ShardedDataTreeActorCreator creator, String shardDataTreeActorId) {
        Exception lastException = null;
        for (int i = 0; i < 100; ++i) {
            try {
                return actorSystem.actorOf(creator.props(), shardDataTreeActorId);
            }
            catch (Exception e) {
                lastException = e;
                Uninterruptibles.sleepUninterruptibly((long)100L, (TimeUnit)ACTOR_RETRY_TIME_UNIT);
                LOG.debug("Could not create actor {} because of {} - waiting for sometime before retrying (retry count = {})", new Object[]{shardDataTreeActorId, e.getMessage(), i});
                continue;
            }
        }
        throw new IllegalStateException("Failed to create actor for ShardedDOMDataTree", lastException);
    }

    private static final class ProxyProducer
    extends ForwardingObject
    implements CDSDataTreeProducer {
        private final DOMDataTreeProducer delegate;
        private final Collection<DOMDataTreeIdentifier> subtrees;
        private final ActorRef shardDataTreeActor;
        private final ActorUtils actorUtils;
        private final @GuardedBy(value={"shardAccessMap"}) Map<DOMDataTreeIdentifier, CDSShardAccessImpl> shardAccessMap = new HashMap<DOMDataTreeIdentifier, CDSShardAccessImpl>();
        private final DOMDataTreePrefixTable<DOMDataTreeShardRegistration<DOMDataTreeShard>> shardTable;

        ProxyProducer(DOMDataTreeProducer delegate, Collection<DOMDataTreeIdentifier> subtrees, ActorRef shardDataTreeActor, ActorUtils actorUtils, DOMDataTreePrefixTable<DOMDataTreeShardRegistration<DOMDataTreeShard>> shardLayout) {
            this.delegate = Objects.requireNonNull(delegate);
            this.subtrees = Objects.requireNonNull(subtrees);
            this.shardDataTreeActor = Objects.requireNonNull(shardDataTreeActor);
            this.actorUtils = Objects.requireNonNull(actorUtils);
            this.shardTable = Objects.requireNonNull(shardLayout);
        }

        public DOMDataTreeCursorAwareTransaction createTransaction(boolean isolated) {
            return this.delegate.createTransaction(isolated);
        }

        public DOMDataTreeProducer createProducer(Collection<DOMDataTreeIdentifier> subtrees) {
            return this.delegate.createProducer(subtrees);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws DOMDataTreeProducerException {
            this.delegate.close();
            Map<DOMDataTreeIdentifier, CDSShardAccessImpl> map = this.shardAccessMap;
            synchronized (map) {
                this.shardAccessMap.values().forEach(CDSShardAccessImpl::close);
            }
            Object o = this.actorUtils.executeOperation(this.shardDataTreeActor, (Object)new ProducerRemoved(this.subtrees));
            if (o instanceof DOMDataTreeProducerException) {
                throw (DOMDataTreeProducerException)o;
            }
            if (o instanceof Throwable) {
                throw new DOMDataTreeProducerException("Unable to close producer", (Throwable)o);
            }
        }

        protected DOMDataTreeProducer delegate() {
            return this.delegate;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CDSShardAccess getShardAccess(DOMDataTreeIdentifier subtree) {
            Preconditions.checkArgument((boolean)this.subtrees.stream().anyMatch(dataTreeIdentifier -> dataTreeIdentifier.contains(subtree)), (String)"Subtree %s is not controlled by this producer %s", (Object)subtree, (Object)((Object)this));
            DOMDataTreePrefixTableEntry lookup = this.shardTable.lookup(subtree);
            Preconditions.checkState((lookup != null ? 1 : 0) != 0, (String)"Subtree %s is not contained in any registered shard.", (Object)subtree);
            DOMDataTreeIdentifier lookupId = ((DOMDataTreeShardRegistration)lookup.getValue()).getPrefix();
            Map<DOMDataTreeIdentifier, CDSShardAccessImpl> map = this.shardAccessMap;
            synchronized (map) {
                if (this.shardAccessMap.get(lookupId) != null) {
                    return this.shardAccessMap.get(lookupId);
                }
                CDSShardAccessImpl shardAccess = new CDSShardAccessImpl(lookupId, this.actorUtils);
                this.shardAccessMap.put(lookupId, shardAccess);
                return shardAccess;
            }
        }
    }

    private class DistributedShardRegistrationImpl
    implements DistributedShardRegistration {
        private final DOMDataTreeIdentifier prefix;
        private final ActorRef shardedDataTreeActor;
        private final DistributedShardedDOMDataTree distributedShardedDOMDataTree;

        DistributedShardRegistrationImpl(DOMDataTreeIdentifier prefix, ActorRef shardedDataTreeActor, DistributedShardedDOMDataTree distributedShardedDOMDataTree2) {
            this.prefix = prefix;
            this.shardedDataTreeActor = shardedDataTreeActor;
            this.distributedShardedDOMDataTree = distributedShardedDOMDataTree2;
        }

        @Override
        public CompletionStage<Void> close() {
            this.distributedShardedDOMDataTree.despawnShardFrontend(this.prefix);
            Future ask = Patterns.ask((ActorRef)this.shardedDataTreeActor, (Object)new PrefixShardRemovalLookup(this.prefix), (Timeout)SHARD_FUTURE_TIMEOUT);
            Future closeFuture = ask.transform((Function1)new Mapper<Object, Void>(){

                public Void apply(Object parameter) {
                    return null;
                }
            }, (Function1)new Mapper<Throwable, Throwable>(){

                public Throwable apply(Throwable throwable) {
                    return throwable;
                }
            }, (ExecutionContext)DistributedShardedDOMDataTree.this.actorSystem.dispatcher());
            return FutureConverters.toJava((Future)closeFuture);
        }
    }
}

