/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.sharding;

import com.google.common.collect.ClassToInstanceMap;
import java.util.Collection;
import java.util.concurrent.CompletionStage;
import org.opendaylight.controller.cluster.ActorSystemProvider;
import org.opendaylight.controller.cluster.access.concepts.MemberName;
import org.opendaylight.controller.cluster.datastore.DistributedDataStoreInterface;
import org.opendaylight.controller.cluster.sharding.DistributedShardFactory;
import org.opendaylight.controller.cluster.sharding.DistributedShardRegistration;
import org.opendaylight.controller.cluster.sharding.DistributedShardedDOMDataTree;
import org.opendaylight.mdsal.dom.api.DOMDataTreeIdentifier;
import org.opendaylight.mdsal.dom.api.DOMDataTreeListener;
import org.opendaylight.mdsal.dom.api.DOMDataTreeLoopException;
import org.opendaylight.mdsal.dom.api.DOMDataTreeProducer;
import org.opendaylight.mdsal.dom.api.DOMDataTreeService;
import org.opendaylight.mdsal.dom.api.DOMDataTreeServiceExtension;
import org.opendaylight.mdsal.dom.api.DOMDataTreeShard;
import org.opendaylight.mdsal.dom.api.DOMDataTreeShardingConflictException;
import org.opendaylight.mdsal.dom.api.DOMDataTreeShardingService;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, property={"type=default"})
public final class OSGiDistributedShardedDOMDataTree
implements DOMDataTreeService,
DOMDataTreeShardingService,
DistributedShardFactory {
    private static final Logger LOG = LoggerFactory.getLogger(OSGiDistributedShardedDOMDataTree.class);
    @Reference
    ActorSystemProvider actorSystemProvider = null;
    @Reference(target="(type=distributed-config)")
    DistributedDataStoreInterface configDatastore = null;
    @Reference(target="(type=distributed-operational)")
    DistributedDataStoreInterface operDatastore = null;
    private DistributedShardedDOMDataTree delegate;

    public DOMDataTreeProducer createProducer(Collection<DOMDataTreeIdentifier> subtrees) {
        return this.delegate.createProducer(subtrees);
    }

    public ClassToInstanceMap<DOMDataTreeServiceExtension> getExtensions() {
        return this.delegate.getExtensions();
    }

    @Override
    public CompletionStage<DistributedShardRegistration> createDistributedShard(DOMDataTreeIdentifier prefix, Collection<MemberName> replicaMembers) throws DOMDataTreeShardingConflictException {
        return this.delegate.createDistributedShard(prefix, replicaMembers);
    }

    public <T extends DOMDataTreeShard> ListenerRegistration<T> registerDataTreeShard(DOMDataTreeIdentifier prefix, T shard, DOMDataTreeProducer producer) throws DOMDataTreeShardingConflictException {
        return this.delegate.registerDataTreeShard(prefix, shard, producer);
    }

    public <T extends DOMDataTreeListener> ListenerRegistration<T> registerListener(T listener, Collection<DOMDataTreeIdentifier> subtrees, boolean allowRxMerges, Collection<DOMDataTreeProducer> producers) throws DOMDataTreeLoopException {
        return this.delegate.registerListener(listener, subtrees, allowRxMerges, producers);
    }

    @Activate
    void activate() {
        LOG.info("Distributed DOM Data Tree Service starting");
        this.delegate = new DistributedShardedDOMDataTree(this.actorSystemProvider, this.operDatastore, this.configDatastore);
        this.delegate.init();
        LOG.info("Distributed DOM Data Tree Service started");
    }

    @Deactivate
    void deactivate() {
        LOG.info("Distributed DOM Data Tree Service stopping");
        this.delegate = null;
        LOG.info("Distributed DOM Data Tree Service stopped");
    }
}

