/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.clustering.prefix.shard.configuration.rev170110.prefix.shards;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.clustering.prefix.shard.configuration.rev170110.prefix.shards.Shard;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.clustering.prefix.shard.configuration.rev170110.prefix.shards.ShardKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.clustering.prefix.shard.configuration.rev170110.prefix.shards.shard.Replicas;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;

public class ShardBuilder
implements Builder<Shard> {
    private InstanceIdentifier<?> _prefix;
    private Replicas _replicas;
    private ShardKey key;
    Map<Class<? extends Augmentation<Shard>>, Augmentation<Shard>> augmentation = Collections.emptyMap();

    public ShardBuilder() {
    }

    public ShardBuilder(Shard base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Shard>>, Augmentation<Shard>>(aug);
        }
        this.key = base.key();
        this._prefix = base.getPrefix();
        this._replicas = base.getReplicas();
    }

    public ShardKey key() {
        return this.key;
    }

    public InstanceIdentifier<?> getPrefix() {
        return this._prefix;
    }

    public Replicas getReplicas() {
        return this._replicas;
    }

    public <E$$ extends Augmentation<Shard>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public ShardBuilder withKey(ShardKey key) {
        this.key = key;
        return this;
    }

    public ShardBuilder setPrefix(InstanceIdentifier<?> value) {
        this._prefix = value;
        return this;
    }

    public ShardBuilder setReplicas(Replicas value) {
        this._replicas = value;
        return this;
    }

    public ShardBuilder addAugmentation(Augmentation<Shard> augmentation) {
        Class augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Shard>>, Augmentation<Shard>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public ShardBuilder removeAugmentation(Class<? extends Augmentation<Shard>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Shard build() {
        return new ShardImpl(this);
    }

    private static final class ShardImpl
    extends AbstractAugmentable<Shard>
    implements Shard {
        private final InstanceIdentifier<?> _prefix;
        private final Replicas _replicas;
        private final ShardKey key;
        private int hash = 0;
        private volatile boolean hashValid = false;

        ShardImpl(ShardBuilder base) {
            super(base.augmentation);
            this.key = base.key() != null ? base.key() : new ShardKey(base.getPrefix());
            this._prefix = this.key.getPrefix();
            this._replicas = base.getReplicas();
        }

        @Override
        public ShardKey key() {
            return this.key;
        }

        @Override
        public InstanceIdentifier<?> getPrefix() {
            return this._prefix;
        }

        @Override
        public Replicas getReplicas() {
            return this._replicas;
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = Shard.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return Shard.bindingEquals(this, obj);
        }

        public String toString() {
            return Shard.bindingToString(this);
        }
    }
}

