/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.databroker;

import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;
import org.opendaylight.controller.cluster.access.concepts.ClientIdentifier;
import org.opendaylight.controller.cluster.access.concepts.FrontendIdentifier;
import org.opendaylight.controller.cluster.access.concepts.FrontendType;
import org.opendaylight.controller.cluster.access.concepts.LocalHistoryIdentifier;
import org.opendaylight.controller.cluster.access.concepts.MemberName;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;
import org.opendaylight.controller.cluster.databroker.ClientBackedDataStore;
import org.opendaylight.controller.cluster.databroker.actors.dds.ClientLocalHistory;
import org.opendaylight.controller.cluster.databroker.actors.dds.ClientSnapshot;
import org.opendaylight.controller.cluster.databroker.actors.dds.ClientTransaction;
import org.opendaylight.controller.cluster.databroker.actors.dds.DataStoreClient;
import org.opendaylight.controller.cluster.datastore.DatastoreContext;
import org.opendaylight.controller.cluster.datastore.utils.ActorUtils;
import org.opendaylight.controller.md.cluster.datastore.model.TestModel;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreReadTransaction;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreReadWriteTransaction;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreTransactionChain;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreWriteTransaction;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;

public class ClientBackedDataStoreTest {
    private static final ClientIdentifier UNKNOWN_ID = ClientIdentifier.create((FrontendIdentifier)FrontendIdentifier.create((MemberName)MemberName.forName((String)"local"), (FrontendType)FrontendType.forName((String)"unknown")), (long)0L);
    private static final FrontendIdentifier FRONTEND_IDENTIFIER = FrontendIdentifier.create((MemberName)MemberName.forName((String)"member"), (FrontendType)FrontendType.forName((String)"frontend"));
    private static final ClientIdentifier CLIENT_IDENTIFIER = ClientIdentifier.create((FrontendIdentifier)FRONTEND_IDENTIFIER, (long)0L);
    private static final LocalHistoryIdentifier HISTORY_ID = new LocalHistoryIdentifier(CLIENT_IDENTIFIER, 0L);
    private static final TransactionIdentifier TRANSACTION_IDENTIFIER = new TransactionIdentifier(HISTORY_ID, 0L);
    private static EffectiveModelContext SCHEMA_CONTEXT;
    @Mock
    private DataStoreClient clientActor;
    @Mock
    private ActorUtils actorUtils;
    @Mock
    private ClientLocalHistory clientLocalHistory;
    @Mock
    private ClientTransaction clientTransaction;
    @Mock
    private ClientSnapshot clientSnapshot;

    @BeforeClass
    public static void beforeClass() {
        SCHEMA_CONTEXT = TestModel.createTestContext();
    }

    @AfterClass
    public static void afterClass() {
        SCHEMA_CONTEXT = null;
    }

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.actorUtils.getSchemaContext()).thenReturn((Object)SCHEMA_CONTEXT);
        Mockito.when((Object)this.actorUtils.getDatastoreContext()).thenReturn((Object)DatastoreContext.newBuilder().build());
        Mockito.when((Object)this.clientTransaction.getIdentifier()).thenReturn((Object)TRANSACTION_IDENTIFIER);
        Mockito.when((Object)this.clientSnapshot.getIdentifier()).thenReturn((Object)TRANSACTION_IDENTIFIER);
        Mockito.when((Object)((ClientIdentifier)this.clientActor.getIdentifier())).thenReturn((Object)CLIENT_IDENTIFIER);
        Mockito.when((Object)this.clientActor.createTransaction()).thenReturn((Object)this.clientTransaction);
        Mockito.when((Object)this.clientActor.createLocalHistory()).thenReturn((Object)this.clientLocalHistory);
        Mockito.when((Object)this.clientActor.createSnapshot()).thenReturn((Object)this.clientSnapshot);
    }

    @Test
    public void testCreateTransactionChain() {
        try (ClientBackedDataStore clientBackedDataStore = new ClientBackedDataStore(this.actorUtils, UNKNOWN_ID, this.clientActor);){
            DOMStoreTransactionChain txChain = clientBackedDataStore.createTransactionChain();
            Assert.assertNotNull((Object)txChain);
            ((DataStoreClient)Mockito.verify((Object)this.clientActor, (VerificationMode)Mockito.times((int)1))).createLocalHistory();
        }
    }

    @Test
    public void testNewReadOnlyTransaction() {
        try (ClientBackedDataStore clientBackedDataStore = new ClientBackedDataStore(this.actorUtils, UNKNOWN_ID, this.clientActor);){
            DOMStoreReadTransaction tx = clientBackedDataStore.newReadOnlyTransaction();
            Assert.assertNotNull((Object)tx);
            ((DataStoreClient)Mockito.verify((Object)this.clientActor, (VerificationMode)Mockito.times((int)1))).createSnapshot();
        }
    }

    @Test
    public void testNewWriteOnlyTransaction() {
        try (ClientBackedDataStore clientBackedDataStore = new ClientBackedDataStore(this.actorUtils, UNKNOWN_ID, this.clientActor);){
            DOMStoreWriteTransaction tx = clientBackedDataStore.newWriteOnlyTransaction();
            Assert.assertNotNull((Object)tx);
            ((DataStoreClient)Mockito.verify((Object)this.clientActor, (VerificationMode)Mockito.times((int)1))).createTransaction();
        }
    }

    @Test
    public void testNewReadWriteTransaction() {
        try (ClientBackedDataStore clientBackedDataStore = new ClientBackedDataStore(this.actorUtils, UNKNOWN_ID, this.clientActor);){
            DOMStoreReadWriteTransaction tx = clientBackedDataStore.newReadWriteTransaction();
            Assert.assertNotNull((Object)tx);
            ((DataStoreClient)Mockito.verify((Object)this.clientActor, (VerificationMode)Mockito.times((int)1))).createTransaction();
        }
    }
}

