/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.databroker;

import com.google.common.util.concurrent.FluentFuture;
import java.util.Optional;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.opendaylight.controller.cluster.databroker.ClientBackedReadWriteTransaction;
import org.opendaylight.controller.cluster.databroker.ClientBackedTransactionTest;
import org.opendaylight.controller.cluster.databroker.actors.dds.ClientTransaction;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreThreePhaseCommitCohort;
import org.opendaylight.yangtools.util.concurrent.FluentFutures;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;

public class ClientBackedReadWriteTransactionTest
extends ClientBackedTransactionTest<ClientBackedReadWriteTransaction> {
    private ClientBackedReadWriteTransaction object;
    @Mock
    private ClientTransaction delegate;
    @Mock
    private NormalizedNode<?, ?> data;
    @Mock
    private DOMStoreThreePhaseCommitCohort readyCohort;

    @Override
    ClientBackedReadWriteTransaction object() {
        return this.object;
    }

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        ((ClientTransaction)Mockito.doReturn((Object)TRANSACTION_ID).when((Object)this.delegate)).getIdentifier();
        ((ClientTransaction)Mockito.doReturn((Object)this.readyCohort).when((Object)this.delegate)).ready();
        ((ClientTransaction)Mockito.doReturn((Object)FluentFutures.immediateTrueFluentFuture()).when((Object)this.delegate)).exists(YangInstanceIdentifier.empty());
        ((ClientTransaction)Mockito.doReturn((Object)FluentFutures.immediateFluentFuture(Optional.of(this.data))).when((Object)this.delegate)).read(YangInstanceIdentifier.empty());
        this.object = new ClientBackedReadWriteTransaction(this.delegate, null);
    }

    @Test
    public void testRead() throws Exception {
        FluentFuture result = this.object().read(YangInstanceIdentifier.empty());
        Optional resultData = (Optional)result.get();
        Assert.assertTrue((boolean)resultData.isPresent());
        Assert.assertEquals(this.data, resultData.get());
    }

    @Test
    public void testExists() throws Exception {
        Assert.assertEquals((Object)Boolean.TRUE, (Object)this.object().exists(YangInstanceIdentifier.empty()).get());
    }
}

