/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.databroker;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;
import org.opendaylight.controller.cluster.access.concepts.ClientIdentifier;
import org.opendaylight.controller.cluster.access.concepts.FrontendIdentifier;
import org.opendaylight.controller.cluster.access.concepts.FrontendType;
import org.opendaylight.controller.cluster.access.concepts.LocalHistoryIdentifier;
import org.opendaylight.controller.cluster.access.concepts.MemberName;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;
import org.opendaylight.controller.cluster.databroker.ClientBackedTransactionChain;
import org.opendaylight.controller.cluster.databroker.actors.dds.ClientLocalHistory;
import org.opendaylight.controller.cluster.databroker.actors.dds.ClientSnapshot;
import org.opendaylight.controller.cluster.databroker.actors.dds.ClientTransaction;

public class ClientBackedTransactionChainTest {
    private ClientBackedTransactionChain chain;
    @Mock
    private ClientLocalHistory history;
    @Mock
    private ClientSnapshot snapshot;
    @Mock
    private ClientTransaction transaction;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        FrontendIdentifier frontendId = FrontendIdentifier.create((MemberName)MemberName.forName((String)"member"), (FrontendType)FrontendType.forName((String)"frontend"));
        ClientIdentifier clientId = ClientIdentifier.create((FrontendIdentifier)frontendId, (long)0L);
        LocalHistoryIdentifier historyId = new LocalHistoryIdentifier(clientId, 0L);
        TransactionIdentifier transactionId = new TransactionIdentifier(historyId, 0L);
        Mockito.when((Object)this.history.getIdentifier()).thenReturn((Object)historyId);
        Mockito.when((Object)this.transaction.getIdentifier()).thenReturn((Object)transactionId);
        Mockito.when((Object)this.snapshot.getIdentifier()).thenReturn((Object)transactionId);
        Mockito.when((Object)this.history.takeSnapshot()).thenReturn((Object)this.snapshot);
        Mockito.when((Object)this.history.createTransaction()).thenReturn((Object)this.transaction);
        this.chain = new ClientBackedTransactionChain(this.history, false);
    }

    @Test
    public void testNewReadOnlyTransaction() {
        Assert.assertNotNull((Object)this.chain.newReadOnlyTransaction());
        ((ClientLocalHistory)Mockito.verify((Object)this.history)).takeSnapshot();
    }

    @Test
    public void testNewReadWriteTransaction() {
        Assert.assertNotNull((Object)this.chain.newReadWriteTransaction());
        ((ClientLocalHistory)Mockito.verify((Object)this.history)).createTransaction();
    }

    @Test
    public void testNewWriteOnlyTransaction() {
        Assert.assertNotNull((Object)this.chain.newWriteOnlyTransaction());
        ((ClientLocalHistory)Mockito.verify((Object)this.history)).createTransaction();
    }

    @Test
    public void testClose() {
        this.chain.newReadOnlyTransaction();
        this.chain.close();
        ((ClientSnapshot)Mockito.verify((Object)this.snapshot)).abort();
        ((ClientLocalHistory)Mockito.verify((Object)this.history)).close();
    }

    @Test
    public void testSnapshotClosed() {
        this.chain.snapshotClosed(this.snapshot);
        this.chain.close();
        ((ClientSnapshot)Mockito.verify((Object)this.snapshot, (VerificationMode)Mockito.never())).abort();
        ((ClientLocalHistory)Mockito.verify((Object)this.history)).close();
    }
}

