/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.databroker;

import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.opendaylight.controller.cluster.access.concepts.ClientIdentifier;
import org.opendaylight.controller.cluster.access.concepts.FrontendIdentifier;
import org.opendaylight.controller.cluster.access.concepts.FrontendType;
import org.opendaylight.controller.cluster.access.concepts.LocalHistoryIdentifier;
import org.opendaylight.controller.cluster.access.concepts.MemberName;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;
import org.opendaylight.controller.cluster.databroker.ClientBackedTransaction;
import org.opendaylight.controller.cluster.databroker.actors.dds.AbstractClientHandle;

public abstract class ClientBackedTransactionTest<T extends ClientBackedTransaction<?>> {
    private static FrontendIdentifier FRONTEND_ID = FrontendIdentifier.create((MemberName)MemberName.forName((String)"member"), (FrontendType)FrontendType.forName((String)"frontend"));
    protected static final ClientIdentifier CLIENT_ID = ClientIdentifier.create((FrontendIdentifier)FRONTEND_ID, (long)0L);
    private static LocalHistoryIdentifier HISTORY_ID = new LocalHistoryIdentifier(CLIENT_ID, 0L);
    protected static final TransactionIdentifier TRANSACTION_ID = new TransactionIdentifier(HISTORY_ID, 0L);

    abstract T object();

    @Test
    public void testClose() {
        AbstractClientHandle delegate = this.object().delegate();
        this.object().close();
        ((AbstractClientHandle)Mockito.verify((Object)delegate, (VerificationMode)Mockito.times((int)2))).abort();
    }
}

