/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.databroker.actors.dds;

import akka.actor.ActorRef;
import akka.actor.ActorSelection;
import akka.actor.ActorSystem;
import com.google.common.primitives.UnsignedLong;
import java.util.Optional;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.opendaylight.controller.cluster.access.ABIVersion;
import org.opendaylight.controller.cluster.access.client.AccessClientUtil;
import org.opendaylight.controller.cluster.access.client.BackendInfo;
import org.opendaylight.controller.cluster.access.client.ClientActorContext;
import org.opendaylight.controller.cluster.access.client.ConnectedClientConnection;
import org.opendaylight.controller.cluster.access.concepts.LocalHistoryIdentifier;
import org.opendaylight.controller.cluster.databroker.actors.dds.AbstractClientHistory;
import org.opendaylight.controller.cluster.databroker.actors.dds.AbstractProxyTransaction;
import org.opendaylight.controller.cluster.databroker.actors.dds.ClientSnapshot;
import org.opendaylight.controller.cluster.databroker.actors.dds.ClientTransaction;
import org.opendaylight.controller.cluster.databroker.actors.dds.HistoryReconnectCohort;
import org.opendaylight.controller.cluster.databroker.actors.dds.ProxyHistory;
import org.opendaylight.controller.cluster.databroker.actors.dds.ShardBackendInfo;
import org.opendaylight.controller.cluster.databroker.actors.dds.TestUtils;
import org.opendaylight.controller.cluster.datastore.messages.PrimaryShardInfo;
import org.opendaylight.controller.cluster.datastore.utils.ActorUtils;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTree;
import scala.concurrent.impl.Promise;

public abstract class AbstractClientHistoryTest<T extends AbstractClientHistory> {
    protected static final String SHARD_NAME = "default";
    protected static final String PERSISTENCE_ID = "per-1";
    protected static final LocalHistoryIdentifier HISTORY_ID = new LocalHistoryIdentifier(TestUtils.CLIENT_ID, 1L);
    @Mock
    private DataTree tree;

    protected abstract T object();

    protected abstract ClientActorContext clientActorContext();

    @Test
    public abstract void testDoCreateSnapshot();

    @Test
    public abstract void testDoCreateTransaction();

    @Test
    public abstract void testCreateHistoryProxy();

    @Test
    public abstract void testOnTransactionComplete();

    @Test
    public abstract void testOnTransactionAbort();

    @Test
    public abstract void testOnTransactionReady();

    @Test
    public abstract void testOnTransactionReadyDuplicate();

    @Test
    public void testCreateSnapshotProxy() {
        AbstractProxyTransaction snapshotProxy = this.object().createSnapshotProxy(TestUtils.TRANSACTION_ID, Long.valueOf(0L));
        Assert.assertNotNull((Object)snapshotProxy);
        Assert.assertNotEquals((Object)TestUtils.TRANSACTION_ID, (Object)snapshotProxy.getIdentifier());
    }

    @Test
    public void testCreateTransactionProxy() {
        AbstractProxyTransaction transactionProxy = this.object().createTransactionProxy(TestUtils.TRANSACTION_ID, Long.valueOf(0L));
        Assert.assertNotNull((Object)transactionProxy);
        Assert.assertNotEquals((Object)TestUtils.TRANSACTION_ID, (Object)transactionProxy.getIdentifier());
    }

    @Test
    public void testState() {
        Assert.assertEquals((Object)AbstractClientHistory.State.IDLE, (Object)this.object().state());
    }

    @Test
    public void testUpdateState() {
        this.object().updateState(AbstractClientHistory.State.IDLE, AbstractClientHistory.State.CLOSED);
        Assert.assertEquals((Object)AbstractClientHistory.State.CLOSED, (Object)this.object().state());
    }

    @Test
    public void testDoClose() {
        this.object().createTransactionProxy(TestUtils.TRANSACTION_ID, Long.valueOf(0L));
        this.object().doClose();
        Assert.assertEquals((Object)AbstractClientHistory.State.CLOSED, (Object)this.object().state());
    }

    @Test
    public void testGetIdentifier() {
        Assert.assertEquals((Object)HISTORY_ID, (Object)this.object().getIdentifier());
    }

    @Test
    public void testNextTx() {
        Assert.assertTrue((this.object().nextTx() + 1L == this.object().nextTx() ? 1 : 0) != 0);
    }

    @Test
    public void testResolveShardForPath() {
        Long shardForPath = this.object().resolveShardForPath(YangInstanceIdentifier.empty());
        Assert.assertEquals((long)0L, (long)shardForPath);
    }

    @Test
    public void testLocalAbort() {
        this.object().localAbort(new Throwable());
        Assert.assertEquals((Object)AbstractClientHistory.State.CLOSED, (Object)this.object().state());
    }

    @Test
    public void testOnProxyDestroyed() {
        ProxyHistory proxyHistory = (ProxyHistory)Mockito.mock(ProxyHistory.class);
        Mockito.when((Object)proxyHistory.getIdentifier()).thenReturn((Object)HISTORY_ID);
        this.object().onProxyDestroyed(proxyHistory);
        ((ProxyHistory)Mockito.verify((Object)proxyHistory)).getIdentifier();
    }

    @Test
    public void testCreateTransaction() {
        ClientTransaction transaction = this.object().createTransaction();
        Assert.assertNotNull((Object)transaction);
    }

    @Test
    public void testTakeSnapshot() {
        ClientSnapshot clientSnapshot = this.object().takeSnapshot();
        Assert.assertEquals((Object)this.object().getIdentifier(), (Object)clientSnapshot.getIdentifier().getHistoryId());
    }

    @Test
    public void testStartReconnect() {
        Long cookie;
        Long shard = cookie = Long.valueOf(0L);
        ShardBackendInfo info = new ShardBackendInfo(this.clientActorContext().self(), 0L, ABIVersion.current(), SHARD_NAME, UnsignedLong.ZERO, Optional.of(this.tree), 10);
        ConnectedClientConnection newConn = AccessClientUtil.createConnectedConnection((ClientActorContext)this.clientActorContext(), (Long)cookie, (BackendInfo)info);
        this.object().createSnapshotProxy(TestUtils.TRANSACTION_ID, shard);
        HistoryReconnectCohort reconnectCohort = this.object().startReconnect(newConn);
        Assert.assertNotNull((Object)reconnectCohort);
    }

    @Test
    public void testStartReconnectMissingOldProxy() {
        Long cookie = 1L;
        Long shard = 0L;
        ShardBackendInfo info = new ShardBackendInfo(this.clientActorContext().self(), 0L, ABIVersion.current(), SHARD_NAME, UnsignedLong.ZERO, Optional.of(this.tree), 10);
        ConnectedClientConnection newConn = AccessClientUtil.createConnectedConnection((ClientActorContext)this.clientActorContext(), (Long)cookie, (BackendInfo)info);
        this.object().createSnapshotProxy(TestUtils.TRANSACTION_ID, shard);
        HistoryReconnectCohort reconnectCohort = this.object().startReconnect(newConn);
        Assert.assertNull((Object)reconnectCohort);
    }

    protected static ActorUtils createActorUtilsMock(ActorSystem system, ActorRef actor) {
        ActorUtils mock = (ActorUtils)Mockito.mock(ActorUtils.class);
        Promise.DefaultPromise promise = new Promise.DefaultPromise();
        ActorSelection selection = system.actorSelection(actor.path());
        PrimaryShardInfo shardInfo = new PrimaryShardInfo(selection, 0);
        promise.success((Object)shardInfo);
        Mockito.when((Object)mock.findPrimaryShardAsync((String)ArgumentMatchers.any())).thenReturn((Object)promise.future());
        return mock;
    }
}

