/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.databroker.actors.dds;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.testkit.TestProbe;
import akka.testkit.javadsl.TestKit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;
import org.opendaylight.controller.cluster.access.client.AbstractClientConnection;
import org.opendaylight.controller.cluster.access.client.AccessClientUtil;
import org.opendaylight.controller.cluster.access.client.ClientActorContext;
import org.opendaylight.controller.cluster.access.concepts.ClientIdentifier;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;
import org.opendaylight.controller.cluster.databroker.actors.dds.AbstractClientHistory;
import org.opendaylight.controller.cluster.databroker.actors.dds.AbstractClientHistoryTest;
import org.opendaylight.controller.cluster.databroker.actors.dds.AbstractDataStoreClientBehavior;
import org.opendaylight.controller.cluster.databroker.actors.dds.AbstractTransactionCommitCohort;
import org.opendaylight.controller.cluster.databroker.actors.dds.ClientLocalHistory;
import org.opendaylight.controller.cluster.databroker.actors.dds.ClientSnapshot;
import org.opendaylight.controller.cluster.databroker.actors.dds.ClientTransaction;
import org.opendaylight.controller.cluster.databroker.actors.dds.ProxyHistory;
import org.opendaylight.controller.cluster.databroker.actors.dds.SimpleDataStoreClientBehavior;
import org.opendaylight.controller.cluster.databroker.actors.dds.TestUtils;
import org.opendaylight.controller.cluster.datastore.utils.ActorUtils;

public class ClientLocalHistoryTest
extends AbstractClientHistoryTest<ClientLocalHistory> {
    private ActorSystem system;
    private AbstractDataStoreClientBehavior behavior;
    private ClientActorContext clientActorContext;
    private ClientLocalHistory object;
    @Mock
    private AbstractTransactionCommitCohort cohort;
    @Mock
    private ClientTransaction transaction;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.system = ActorSystem.apply();
        TestProbe clientContextProbe = new TestProbe(this.system, "client");
        TestProbe actorContextProbe = new TestProbe(this.system, "actor-context");
        this.clientActorContext = AccessClientUtil.createClientActorContext((ActorSystem)this.system, (ActorRef)clientContextProbe.ref(), (ClientIdentifier)TestUtils.CLIENT_ID, (String)"per-1");
        ActorUtils actorUtilsMock = ClientLocalHistoryTest.createActorUtilsMock(this.system, actorContextProbe.ref());
        this.behavior = new SimpleDataStoreClientBehavior(this.clientActorContext, actorUtilsMock, "default");
        this.object = new ClientLocalHistory(this.behavior, HISTORY_ID);
    }

    @After
    public void tearDown() {
        TestKit.shutdownActorSystem((ActorSystem)this.system);
    }

    @Override
    protected ClientLocalHistory object() {
        return this.object;
    }

    @Override
    protected ClientActorContext clientActorContext() {
        return this.clientActorContext;
    }

    @Test
    public void testClose() {
        this.object().close();
        Assert.assertEquals((Object)AbstractClientHistory.State.CLOSED, (Object)this.object().state());
    }

    @Override
    @Test
    public void testDoCreateTransaction() {
        ClientTransaction clientTransaction = this.object().doCreateTransaction();
        Assert.assertEquals((Object)this.object().getIdentifier(), (Object)clientTransaction.getIdentifier().getHistoryId());
    }

    @Override
    @Test
    public void testOnTransactionAbort() {
        ClientSnapshot clientSnapshot = this.object().doCreateSnapshot();
        Assert.assertTrue((boolean)clientSnapshot.abort());
    }

    @Override
    @Test
    public void testCreateHistoryProxy() {
        AbstractClientConnection clientConnection = this.behavior.getConnection(Long.valueOf(0L));
        ProxyHistory historyProxy = this.object().createHistoryProxy(HISTORY_ID, clientConnection);
        Assert.assertEquals((Object)this.object().getIdentifier(), (Object)historyProxy.getIdentifier());
    }

    @Override
    @Test
    public void testDoCreateSnapshot() {
        ClientSnapshot clientSnapshot = this.object().doCreateSnapshot();
        Assert.assertEquals((Object)new TransactionIdentifier(this.object().getIdentifier(), this.object().nextTx()).getHistoryId(), (Object)clientSnapshot.getIdentifier().getHistoryId());
    }

    @Override
    @Test
    public void testOnTransactionComplete() {
        ClientTransaction tx = this.object().createTransaction();
        this.object().onTransactionReady(tx, this.cohort);
        Assert.assertEquals((Object)AbstractClientHistory.State.IDLE, (Object)this.object.state());
        this.object().onTransactionComplete(tx.getIdentifier());
        Assert.assertEquals((Object)AbstractClientHistory.State.IDLE, (Object)this.object.state());
    }

    @Override
    @Test
    public void testOnTransactionReady() {
        AbstractTransactionCommitCohort result = this.object().onTransactionReady(this.object().createTransaction(), this.cohort);
        Assert.assertEquals((Object)result, (Object)this.cohort);
    }

    @Override
    @Test(expected=IllegalStateException.class)
    public void testOnTransactionReadyDuplicate() {
        ClientTransaction tx = this.object().createTransaction();
        this.object().onTransactionReady(tx, this.cohort);
        this.object().onTransactionReady(tx, this.cohort);
    }

    @Test
    public void testOnTransactionReadyAndComplete() {
        this.object().updateState(AbstractClientHistory.State.IDLE, AbstractClientHistory.State.TX_OPEN);
        AbstractTransactionCommitCohort transactionCommitCohort = this.object().onTransactionReady(this.transaction, this.cohort);
        Assert.assertEquals((Object)this.cohort, (Object)transactionCommitCohort);
    }

    @Test
    public void testOnTransactionReadyAndCompleteStateClosed() {
        this.object().updateState(AbstractClientHistory.State.IDLE, AbstractClientHistory.State.CLOSED);
        AbstractTransactionCommitCohort transactionCommitCohort = this.object().onTransactionReady(this.transaction, this.cohort);
        Assert.assertEquals((Object)this.cohort, (Object)transactionCommitCohort);
    }

    @Test(expected=IllegalStateException.class)
    public void testOnTransactionReadyAndCompleteIdleFail() {
        this.object().onTransactionReady(this.transaction, this.cohort);
    }
}

