/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.databroker.actors.dds;

import com.google.common.util.concurrent.FluentFuture;
import java.util.Optional;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.opendaylight.controller.cluster.databroker.actors.dds.AbstractClientHandleTest;
import org.opendaylight.controller.cluster.databroker.actors.dds.AbstractClientHistory;
import org.opendaylight.controller.cluster.databroker.actors.dds.ClientSnapshot;
import org.opendaylight.controller.cluster.databroker.actors.dds.TestUtils;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeSnapshot;

public class ClientSnapshotTest
extends AbstractClientHandleTest<ClientSnapshot> {
    private static final YangInstanceIdentifier PATH = YangInstanceIdentifier.empty();

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        Mockito.when((Object)this.getDataTreeSnapshot().readNode(PATH)).thenReturn(Optional.empty());
    }

    @Override
    protected ClientSnapshot createHandle(AbstractClientHistory parent) {
        return parent.takeSnapshot();
    }

    @Override
    protected void doHandleOperation(ClientSnapshot snapshot) {
        snapshot.read(PATH);
    }

    @Test
    public void testExists() throws Exception {
        FluentFuture exists = ((ClientSnapshot)this.getHandle()).exists(PATH);
        ((DataTreeSnapshot)Mockito.verify((Object)this.getDataTreeSnapshot())).readNode(PATH);
        Assert.assertEquals((Object)Boolean.FALSE, TestUtils.getWithTimeout(exists));
    }

    @Test
    public void testRead() throws Exception {
        FluentFuture exists = ((ClientSnapshot)this.getHandle()).read(PATH);
        ((DataTreeSnapshot)Mockito.verify((Object)this.getDataTreeSnapshot())).readNode(PATH);
        Assert.assertFalse((boolean)((Optional)TestUtils.getWithTimeout(exists)).isPresent());
    }
}

