/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.databroker.actors.dds;

import java.util.Arrays;
import java.util.stream.Collectors;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.opendaylight.controller.cluster.databroker.actors.dds.ClientTransaction;
import org.opendaylight.controller.cluster.databroker.actors.dds.ClientTransactionCursor;
import org.opendaylight.mdsal.dom.api.DOMDataTreeCursor;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.impl.schema.Builders;

public class ClientTransactionCursorTest {
    private static final QName NODE_1 = QName.create((String)"ns-1", (String)"node-1");
    private static final QName NODE_2 = QName.create((QName)NODE_1, (String)"node-2");
    private static final QName NODE_3 = QName.create((QName)NODE_1, (String)"node-3");
    @Mock
    private ClientTransaction transaction;
    private ClientTransactionCursor cursor;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.cursor = new ClientTransactionCursor(this.transaction);
    }

    @Test
    public void testEnterOneNode() {
        this.cursor.enter((YangInstanceIdentifier.PathArgument)YangInstanceIdentifier.NodeIdentifier.create((QName)NODE_1));
        this.cursor.delete((YangInstanceIdentifier.PathArgument)YangInstanceIdentifier.NodeIdentifier.create((QName)NODE_2));
        YangInstanceIdentifier expected = ClientTransactionCursorTest.createId(NODE_1, NODE_2);
        ((ClientTransaction)Mockito.verify((Object)this.transaction)).delete(expected);
    }

    @Test
    public void testEnterNodeIterables() {
        Iterable<YangInstanceIdentifier.PathArgument> collect = ClientTransactionCursorTest.toPathArg(NODE_1, NODE_2);
        this.cursor.enter(collect);
        this.cursor.delete((YangInstanceIdentifier.PathArgument)YangInstanceIdentifier.NodeIdentifier.create((QName)NODE_3));
        YangInstanceIdentifier expected = ClientTransactionCursorTest.createId(NODE_1, NODE_2, NODE_3);
        ((ClientTransaction)Mockito.verify((Object)this.transaction)).delete(expected);
    }

    @Test
    public void testEnterNodeVarargs() {
        this.cursor.enter(new YangInstanceIdentifier.PathArgument[]{YangInstanceIdentifier.NodeIdentifier.create((QName)NODE_1), YangInstanceIdentifier.NodeIdentifier.create((QName)NODE_2)});
        this.cursor.delete((YangInstanceIdentifier.PathArgument)YangInstanceIdentifier.NodeIdentifier.create((QName)NODE_3));
        YangInstanceIdentifier expected = ClientTransactionCursorTest.createId(NODE_1, NODE_2, NODE_3);
        ((ClientTransaction)Mockito.verify((Object)this.transaction)).delete(expected);
    }

    @Test
    public void testExitOneLevel() {
        this.cursor.enter(ClientTransactionCursorTest.toPathArg(NODE_1, NODE_2));
        this.cursor.exit();
        this.cursor.delete((YangInstanceIdentifier.PathArgument)YangInstanceIdentifier.NodeIdentifier.create((QName)NODE_2));
        YangInstanceIdentifier expected = ClientTransactionCursorTest.createId(NODE_1, NODE_2);
        ((ClientTransaction)Mockito.verify((Object)this.transaction)).delete(expected);
    }

    @Test
    public void testExitTwoLevels() {
        this.cursor.enter(ClientTransactionCursorTest.toPathArg(NODE_1, NODE_2, NODE_3));
        this.cursor.exit(2);
        this.cursor.delete((YangInstanceIdentifier.PathArgument)YangInstanceIdentifier.NodeIdentifier.create((QName)NODE_2));
        YangInstanceIdentifier expected = ClientTransactionCursorTest.createId(NODE_1, NODE_2);
        ((ClientTransaction)Mockito.verify((Object)this.transaction)).delete(expected);
    }

    @Test
    public void testClose() {
        this.cursor.close();
        ((ClientTransaction)Mockito.verify((Object)this.transaction)).closeCursor((DOMDataTreeCursor)this.cursor);
    }

    @Test
    public void testDelete() {
        this.cursor.delete((YangInstanceIdentifier.PathArgument)YangInstanceIdentifier.NodeIdentifier.create((QName)NODE_1));
        YangInstanceIdentifier expected = ClientTransactionCursorTest.createId(NODE_1);
        ((ClientTransaction)Mockito.verify((Object)this.transaction)).delete(expected);
    }

    @Test
    public void testMerge() {
        YangInstanceIdentifier.NodeIdentifier path = YangInstanceIdentifier.NodeIdentifier.create((QName)NODE_1);
        ContainerNode data = ClientTransactionCursorTest.createData(path.getNodeType());
        this.cursor.merge((YangInstanceIdentifier.PathArgument)path, (NormalizedNode)data);
        YangInstanceIdentifier expected = ClientTransactionCursorTest.createId(NODE_1);
        ((ClientTransaction)Mockito.verify((Object)this.transaction)).merge(expected, (NormalizedNode)data);
    }

    @Test
    public void testWrite() {
        YangInstanceIdentifier.NodeIdentifier path = YangInstanceIdentifier.NodeIdentifier.create((QName)NODE_1);
        ContainerNode data = ClientTransactionCursorTest.createData(path.getNodeType());
        this.cursor.write((YangInstanceIdentifier.PathArgument)path, (NormalizedNode)data);
        YangInstanceIdentifier expected = ClientTransactionCursorTest.createId(NODE_1);
        ((ClientTransaction)Mockito.verify((Object)this.transaction)).write(expected, (NormalizedNode)data);
    }

    private static Iterable<YangInstanceIdentifier.PathArgument> toPathArg(QName ... pathArguments) {
        return Arrays.stream(pathArguments).map(YangInstanceIdentifier.NodeIdentifier::create).collect(Collectors.toList());
    }

    private static YangInstanceIdentifier createId(QName ... pathArguments) {
        return YangInstanceIdentifier.create(ClientTransactionCursorTest.toPathArg(pathArguments));
    }

    private static ContainerNode createData(QName id) {
        return (ContainerNode)Builders.containerBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)YangInstanceIdentifier.NodeIdentifier.create((QName)id)).build();
    }
}

