/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.databroker.actors.dds;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.testkit.TestProbe;
import akka.testkit.javadsl.TestKit;
import com.google.common.primitives.UnsignedLong;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Optional;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.opendaylight.controller.cluster.access.ABIVersion;
import org.opendaylight.controller.cluster.access.client.AbstractClientConnection;
import org.opendaylight.controller.cluster.access.client.AccessClientUtil;
import org.opendaylight.controller.cluster.access.client.BackendInfo;
import org.opendaylight.controller.cluster.access.client.ClientActorContext;
import org.opendaylight.controller.cluster.access.client.ConnectedClientConnection;
import org.opendaylight.controller.cluster.access.commands.ModifyTransactionRequest;
import org.opendaylight.controller.cluster.access.commands.PersistenceProtocol;
import org.opendaylight.controller.cluster.access.commands.TransactionCommitSuccess;
import org.opendaylight.controller.cluster.access.concepts.ClientIdentifier;
import org.opendaylight.controller.cluster.access.concepts.LocalHistoryIdentifier;
import org.opendaylight.controller.cluster.access.concepts.RequestSuccess;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;
import org.opendaylight.controller.cluster.databroker.actors.dds.AbstractClientHistory;
import org.opendaylight.controller.cluster.databroker.actors.dds.DirectTransactionCommitCohort;
import org.opendaylight.controller.cluster.databroker.actors.dds.ProxyHistory;
import org.opendaylight.controller.cluster.databroker.actors.dds.RemoteProxyTransaction;
import org.opendaylight.controller.cluster.databroker.actors.dds.ShardBackendInfo;
import org.opendaylight.controller.cluster.databroker.actors.dds.TestUtils;
import org.opendaylight.controller.cluster.databroker.actors.dds.TransactionTester;

public class DirectTransactionCommitCohortTest {
    private static final String PERSISTENCE_ID = "per-1";
    @Mock
    private AbstractClientHistory history;
    private ActorSystem system;
    private TransactionTester<?> transaction;
    private DirectTransactionCommitCohort cohort;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.system = ActorSystem.apply();
        TestProbe clientContextProbe = new TestProbe(this.system, "clientContext");
        ClientActorContext context = AccessClientUtil.createClientActorContext((ActorSystem)this.system, (ActorRef)clientContextProbe.ref(), (ClientIdentifier)TestUtils.CLIENT_ID, (String)PERSISTENCE_ID);
        this.transaction = DirectTransactionCommitCohortTest.createTransactionTester(new TestProbe(this.system, "backend"), context, this.history);
        Object proxy = this.transaction.getTransaction();
        proxy.seal();
        this.cohort = new DirectTransactionCommitCohort(this.history, TestUtils.TRANSACTION_ID, proxy);
    }

    @After
    public void tearDown() {
        TestKit.shutdownActorSystem((ActorSystem)this.system);
    }

    @Test
    public void testCanCommit() throws Exception {
        ListenableFuture canCommit = this.cohort.canCommit();
        ModifyTransactionRequest request = this.transaction.expectTransactionRequest(ModifyTransactionRequest.class);
        Assert.assertTrue((boolean)request.getPersistenceProtocol().isPresent());
        Assert.assertEquals((Object)PersistenceProtocol.SIMPLE, request.getPersistenceProtocol().get());
        TransactionCommitSuccess success = new TransactionCommitSuccess((TransactionIdentifier)this.transaction.getTransaction().getIdentifier(), this.transaction.getLastReceivedMessage().getSequence());
        this.transaction.replySuccess((RequestSuccess<?, ?>)success);
        Assert.assertEquals((Object)Boolean.TRUE, TestUtils.getWithTimeout(canCommit));
    }

    @Test
    public void testPreCommit() throws Exception {
        ListenableFuture preCommit = this.cohort.preCommit();
        Assert.assertNull(TestUtils.getWithTimeout(preCommit));
    }

    @Test
    public void testAbort() throws Exception {
        ListenableFuture abort = this.cohort.abort();
        ((AbstractClientHistory)Mockito.verify((Object)this.history)).onTransactionComplete((TransactionIdentifier)this.transaction.getTransaction().getIdentifier());
        Assert.assertNull(TestUtils.getWithTimeout(abort));
    }

    @Test
    public void testCommit() throws Exception {
        ListenableFuture commit = this.cohort.commit();
        ((AbstractClientHistory)Mockito.verify((Object)this.history)).onTransactionComplete((TransactionIdentifier)this.transaction.getTransaction().getIdentifier());
        Assert.assertNull(TestUtils.getWithTimeout(commit));
    }

    private static TransactionTester<?> createTransactionTester(TestProbe backendProbe, ClientActorContext context, AbstractClientHistory history) {
        ShardBackendInfo backend = new ShardBackendInfo(backendProbe.ref(), 0L, ABIVersion.BORON, "default", UnsignedLong.ZERO, Optional.empty(), 3);
        ConnectedClientConnection connection = AccessClientUtil.createConnectedConnection((ClientActorContext)context, (Long)0L, (BackendInfo)backend);
        ProxyHistory proxyHistory = ProxyHistory.createClient((AbstractClientHistory)history, (AbstractClientConnection)connection, (LocalHistoryIdentifier)TestUtils.HISTORY_ID);
        RemoteProxyTransaction transaction = new RemoteProxyTransaction(proxyHistory, TestUtils.TRANSACTION_ID, false, false, false);
        return new TransactionTester<RemoteProxyTransaction>(transaction, (AbstractClientConnection<ShardBackendInfo>)connection, backendProbe);
    }
}

