/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.databroker.actors.dds;

import com.google.common.util.concurrent.ListenableFuture;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.opendaylight.controller.cluster.databroker.actors.dds.AbstractClientHistory;
import org.opendaylight.controller.cluster.databroker.actors.dds.EmptyTransactionCommitCohort;
import org.opendaylight.controller.cluster.databroker.actors.dds.TestUtils;

public class EmptyTransactionCommitCohortTest {
    @Mock
    private AbstractClientHistory history;
    private EmptyTransactionCommitCohort cohort;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.cohort = new EmptyTransactionCommitCohort(this.history, TestUtils.TRANSACTION_ID);
    }

    @Test
    public void testCanCommit() throws Exception {
        ListenableFuture canCommit = this.cohort.canCommit();
        Assert.assertEquals((Object)Boolean.TRUE, TestUtils.getWithTimeout(canCommit));
    }

    @Test
    public void testPreCommit() throws Exception {
        ListenableFuture preCommit = this.cohort.preCommit();
        Assert.assertNull(TestUtils.getWithTimeout(preCommit));
    }

    @Test
    public void testAbort() throws Exception {
        ListenableFuture abort = this.cohort.abort();
        ((AbstractClientHistory)Mockito.verify((Object)this.history)).onTransactionComplete(TestUtils.TRANSACTION_ID);
        Assert.assertNull(TestUtils.getWithTimeout(abort));
    }

    @Test
    public void testCommit() throws Exception {
        ListenableFuture commit = this.cohort.commit();
        ((AbstractClientHistory)Mockito.verify((Object)this.history)).onTransactionComplete(TestUtils.TRANSACTION_ID);
        Assert.assertNull(TestUtils.getWithTimeout(commit));
    }
}

