/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.databroker.actors.dds;

import akka.testkit.TestProbe;
import com.google.common.base.Ticker;
import java.util.Optional;
import java.util.function.Consumer;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.opendaylight.controller.cluster.access.client.ClientActorBehavior;
import org.opendaylight.controller.cluster.access.client.ClientActorContext;
import org.opendaylight.controller.cluster.access.client.InternalCommand;
import org.opendaylight.controller.cluster.access.commands.AbortLocalTransactionRequest;
import org.opendaylight.controller.cluster.access.commands.CommitLocalTransactionRequest;
import org.opendaylight.controller.cluster.access.commands.ExistsTransactionRequest;
import org.opendaylight.controller.cluster.access.commands.ExistsTransactionSuccess;
import org.opendaylight.controller.cluster.access.commands.ModifyTransactionRequest;
import org.opendaylight.controller.cluster.access.commands.PersistenceProtocol;
import org.opendaylight.controller.cluster.access.commands.ReadTransactionRequest;
import org.opendaylight.controller.cluster.access.commands.ReadTransactionSuccess;
import org.opendaylight.controller.cluster.access.commands.TransactionPurgeRequest;
import org.opendaylight.controller.cluster.access.commands.TransactionRequest;
import org.opendaylight.controller.cluster.access.concepts.Response;
import org.opendaylight.controller.cluster.databroker.actors.dds.AbstractProxyTransactionTest;
import org.opendaylight.controller.cluster.databroker.actors.dds.LocalProxyTransaction;
import org.opendaylight.controller.cluster.databroker.actors.dds.LocalReadWriteProxyTransaction;
import org.opendaylight.controller.cluster.databroker.actors.dds.TestUtils;
import org.opendaylight.controller.cluster.databroker.actors.dds.TransactionTester;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.CursorAwareDataTreeModification;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeModification;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeModificationCursor;

public abstract class LocalProxyTransactionTest<T extends LocalProxyTransaction>
extends AbstractProxyTransactionTest<T> {
    @Override
    @Test
    public void testExists() throws Exception {
        TestUtils.assertFutureEquals(Boolean.TRUE, ((LocalProxyTransaction)this.transaction).exists(PATH_1));
        TestUtils.assertFutureEquals(Boolean.FALSE, ((LocalProxyTransaction)this.transaction).exists(PATH_3));
    }

    @Override
    @Test
    public void testRead() throws Exception {
        TestUtils.assertFutureEquals(Optional.of(DATA_1), ((LocalProxyTransaction)this.transaction).read(PATH_1));
        TestUtils.assertFutureEquals(Optional.empty(), ((LocalProxyTransaction)this.transaction).read(PATH_3));
    }

    @Test
    public void testAbort() {
        ((LocalProxyTransaction)this.transaction).abort();
        this.getTester().expectTransactionRequest(AbortLocalTransactionRequest.class);
    }

    private void setupExecuteInActor() {
        ((ClientActorContext)Mockito.doAnswer(inv -> {
            ((InternalCommand)inv.getArgument(0)).execute((ClientActorBehavior)Mockito.mock(ClientActorBehavior.class));
            return null;
        }).when((Object)this.context)).executeInActor((InternalCommand)ArgumentMatchers.any(InternalCommand.class));
    }

    @Test
    public void testHandleForwardedRemoteReadRequest() {
        TestProbe probe = this.createProbe();
        ReadTransactionRequest request = new ReadTransactionRequest(TRANSACTION_ID, 0L, probe.ref(), PATH_1, true);
        Consumer callback = LocalProxyTransactionTest.createCallbackMock();
        this.setupExecuteInActor();
        ((LocalProxyTransaction)this.transaction).handleReplayedRemoteRequest((TransactionRequest)request, callback, Ticker.systemTicker().read());
        ArgumentCaptor captor = ArgumentCaptor.forClass(Response.class);
        ((Consumer)Mockito.verify(callback)).accept((Response)captor.capture());
        Response value = (Response)captor.getValue();
        Assert.assertTrue((boolean)(value instanceof ReadTransactionSuccess));
        ReadTransactionSuccess success = (ReadTransactionSuccess)value;
        Assert.assertTrue((boolean)success.getData().isPresent());
        Assert.assertEquals((Object)DATA_1, success.getData().get());
    }

    @Test
    public void testHandleForwardedRemoteExistsRequest() {
        TestProbe probe = this.createProbe();
        ExistsTransactionRequest request = new ExistsTransactionRequest(TRANSACTION_ID, 0L, probe.ref(), PATH_1, true);
        Consumer callback = LocalProxyTransactionTest.createCallbackMock();
        this.setupExecuteInActor();
        ((LocalProxyTransaction)this.transaction).handleReplayedRemoteRequest((TransactionRequest)request, callback, Ticker.systemTicker().read());
        ArgumentCaptor captor = ArgumentCaptor.forClass(Response.class);
        ((Consumer)Mockito.verify(callback)).accept((Response)captor.capture());
        Response value = (Response)captor.getValue();
        Assert.assertTrue((boolean)(value instanceof ExistsTransactionSuccess));
        ExistsTransactionSuccess success = (ExistsTransactionSuccess)value;
        Assert.assertTrue((boolean)success.getExists());
    }

    @Test
    public void testHandleForwardedRemotePurgeRequest() {
        TestProbe probe = this.createProbe();
        TransactionPurgeRequest request = new TransactionPurgeRequest(TRANSACTION_ID, 0L, probe.ref());
        this.testHandleForwardedRemoteRequest(request);
    }

    @Override
    @Test
    public void testForwardToRemoteAbort() {
        TestProbe probe = this.createProbe();
        AbortLocalTransactionRequest request = new AbortLocalTransactionRequest(TRANSACTION_ID, probe.ref());
        ModifyTransactionRequest modifyRequest = this.testForwardToRemote((TransactionRequest<?>)request, ModifyTransactionRequest.class);
        Assert.assertTrue((boolean)modifyRequest.getPersistenceProtocol().isPresent());
        Assert.assertEquals((Object)PersistenceProtocol.ABORT, modifyRequest.getPersistenceProtocol().get());
    }

    @Override
    @Test
    public void testForwardToRemoteCommit() {
        TestProbe probe = this.createProbe();
        CursorAwareDataTreeModification modification = (CursorAwareDataTreeModification)Mockito.mock(CursorAwareDataTreeModification.class);
        CommitLocalTransactionRequest request = new CommitLocalTransactionRequest(TRANSACTION_ID, 0L, probe.ref(), (DataTreeModification)modification, null, true);
        ((CursorAwareDataTreeModification)Mockito.doAnswer(LocalProxyTransactionTest::applyToCursorAnswer).when((Object)modification)).applyToCursor((DataTreeModificationCursor)ArgumentMatchers.any());
        ModifyTransactionRequest modifyRequest = this.testForwardToRemote((TransactionRequest<?>)request, ModifyTransactionRequest.class);
        ((CursorAwareDataTreeModification)Mockito.verify((Object)modification)).applyToCursor((DataTreeModificationCursor)ArgumentMatchers.any());
        Assert.assertTrue((boolean)modifyRequest.getPersistenceProtocol().isPresent());
        Assert.assertEquals((Object)PersistenceProtocol.THREE_PHASE, modifyRequest.getPersistenceProtocol().get());
        this.checkModifications(modifyRequest);
    }

    @Test
    public void testForwardToLocalAbort() {
        TestProbe probe = this.createProbe();
        AbortLocalTransactionRequest request = new AbortLocalTransactionRequest(TRANSACTION_ID, probe.ref());
        this.testForwardToLocal((TransactionRequest<?>)request, (Class)AbortLocalTransactionRequest.class);
    }

    @Test
    public void testForwardToLocalPurge() {
        TestProbe probe = this.createProbe();
        TransactionPurgeRequest request = new TransactionPurgeRequest(TRANSACTION_ID, 0L, probe.ref());
        this.testForwardToLocal((TransactionRequest<?>)request, (Class)TransactionPurgeRequest.class);
    }

    protected <R extends TransactionRequest<R>> R testForwardToLocal(TransactionRequest<?> toForward, Class<R> expectedMessageClass) {
        Consumer callback = LocalProxyTransactionTest.createCallbackMock();
        TransactionTester<LocalReadWriteProxyTransaction> transactionTester = this.createLocalProxy();
        LocalReadWriteProxyTransaction successor = transactionTester.getTransaction();
        ((LocalProxyTransaction)this.transaction).forwardToLocal((LocalProxyTransaction)successor, toForward, callback);
        return transactionTester.expectTransactionRequest(expectedMessageClass);
    }

    protected static final <T> Answer<T> applyToCursorAnswer(InvocationOnMock invocation) {
        DataTreeModificationCursor cursor = (DataTreeModificationCursor)invocation.getArgument(0);
        cursor.write(PATH_1.getLastPathArgument(), (NormalizedNode)DATA_1);
        cursor.merge(PATH_2.getLastPathArgument(), (NormalizedNode)DATA_2);
        cursor.delete(PATH_3.getLastPathArgument());
        return null;
    }
}

