/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.databroker.actors.dds;

import akka.testkit.TestProbe;
import com.google.common.base.Ticker;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Optional;
import java.util.function.Consumer;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.opendaylight.controller.cluster.access.commands.AbortLocalTransactionRequest;
import org.opendaylight.controller.cluster.access.commands.CommitLocalTransactionRequest;
import org.opendaylight.controller.cluster.access.commands.ModifyTransactionRequest;
import org.opendaylight.controller.cluster.access.commands.ModifyTransactionRequestBuilder;
import org.opendaylight.controller.cluster.access.commands.TransactionAbortRequest;
import org.opendaylight.controller.cluster.access.commands.TransactionCanCommitSuccess;
import org.opendaylight.controller.cluster.access.commands.TransactionCommitSuccess;
import org.opendaylight.controller.cluster.access.commands.TransactionDelete;
import org.opendaylight.controller.cluster.access.commands.TransactionDoCommitRequest;
import org.opendaylight.controller.cluster.access.commands.TransactionMerge;
import org.opendaylight.controller.cluster.access.commands.TransactionModification;
import org.opendaylight.controller.cluster.access.commands.TransactionPreCommitRequest;
import org.opendaylight.controller.cluster.access.commands.TransactionPreCommitSuccess;
import org.opendaylight.controller.cluster.access.commands.TransactionRequest;
import org.opendaylight.controller.cluster.access.commands.TransactionWrite;
import org.opendaylight.controller.cluster.access.concepts.RequestSuccess;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;
import org.opendaylight.controller.cluster.databroker.actors.dds.AbstractProxyTransaction;
import org.opendaylight.controller.cluster.databroker.actors.dds.LocalProxyTransactionTest;
import org.opendaylight.controller.cluster.databroker.actors.dds.LocalReadWriteProxyTransaction;
import org.opendaylight.controller.cluster.databroker.actors.dds.ProxyHistory;
import org.opendaylight.controller.cluster.databroker.actors.dds.RemoteProxyTransaction;
import org.opendaylight.controller.cluster.databroker.actors.dds.TestUtils;
import org.opendaylight.controller.cluster.databroker.actors.dds.TransactionTester;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.CursorAwareDataTreeModification;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeModification;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeModificationCursor;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeSnapshot;

public class LocalReadWriteProxyTransactionTest
extends LocalProxyTransactionTest<LocalReadWriteProxyTransaction> {
    @Mock
    private CursorAwareDataTreeModification modification;

    @Override
    protected LocalReadWriteProxyTransaction createTransaction(ProxyHistory parent, TransactionIdentifier id, DataTreeSnapshot snapshot) {
        Mockito.when((Object)snapshot.newModification()).thenReturn((Object)this.modification);
        Mockito.when((Object)this.modification.readNode(PATH_1)).thenReturn(Optional.of(DATA_1));
        Mockito.when((Object)this.modification.readNode(PATH_3)).thenReturn(Optional.empty());
        return new LocalReadWriteProxyTransaction(parent, TestUtils.TRANSACTION_ID, snapshot);
    }

    @Test
    public void testIsSnapshotOnly() {
        Assert.assertFalse((boolean)((LocalReadWriteProxyTransaction)this.transaction).isSnapshotOnly());
    }

    @Test
    public void testReadOnlyView() {
        Assert.assertEquals((Object)this.modification, (Object)((LocalReadWriteProxyTransaction)this.transaction).readOnlyView());
    }

    @Override
    @Test
    public void testDelete() {
        ((LocalReadWriteProxyTransaction)this.transaction).delete(PATH_1);
        ((CursorAwareDataTreeModification)Mockito.verify((Object)this.modification)).delete(PATH_1);
    }

    @Override
    @Test
    public void testDirectCommit() throws Exception {
        ((LocalReadWriteProxyTransaction)this.transaction).seal();
        ListenableFuture result = ((LocalReadWriteProxyTransaction)this.transaction).directCommit();
        TransactionTester tester = this.getTester();
        CommitLocalTransactionRequest req = tester.expectTransactionRequest(CommitLocalTransactionRequest.class);
        tester.replySuccess((RequestSuccess<?, ?>)new TransactionCommitSuccess(TRANSACTION_ID, req.getSequence()));
        TestUtils.assertFutureEquals(Boolean.TRUE, result);
    }

    @Override
    @Test
    public void testCanCommit() {
        this.testRequestResponse(arg_0 -> ((LocalReadWriteProxyTransaction)((LocalReadWriteProxyTransaction)this.transaction)).canCommit(arg_0), CommitLocalTransactionRequest.class, TransactionCanCommitSuccess::new);
    }

    @Override
    @Test
    public void testPreCommit() {
        this.testRequestResponse(arg_0 -> ((LocalReadWriteProxyTransaction)((LocalReadWriteProxyTransaction)this.transaction)).preCommit(arg_0), TransactionPreCommitRequest.class, TransactionPreCommitSuccess::new);
    }

    @Override
    @Test
    public void testDoCommit() {
        this.testRequestResponse(arg_0 -> ((LocalReadWriteProxyTransaction)((LocalReadWriteProxyTransaction)this.transaction)).doCommit(arg_0), TransactionDoCommitRequest.class, TransactionCommitSuccess::new);
    }

    @Override
    @Test
    public void testMerge() {
        ((LocalReadWriteProxyTransaction)this.transaction).merge(PATH_1, (NormalizedNode)DATA_1);
        ((CursorAwareDataTreeModification)Mockito.verify((Object)this.modification)).merge(PATH_1, (NormalizedNode)DATA_1);
    }

    @Override
    @Test
    public void testWrite() {
        ((LocalReadWriteProxyTransaction)this.transaction).write(PATH_1, (NormalizedNode)DATA_1);
        ((CursorAwareDataTreeModification)Mockito.verify((Object)this.modification)).write(PATH_1, (NormalizedNode)DATA_1);
    }

    @Test
    public void testCommitRequest() {
        ((LocalReadWriteProxyTransaction)this.transaction).doWrite(PATH_1, (NormalizedNode)DATA_1);
        boolean coordinated = true;
        CommitLocalTransactionRequest request = ((LocalReadWriteProxyTransaction)this.transaction).commitRequest(true);
        Assert.assertEquals((Object)true, (Object)request.isCoordinated());
        Assert.assertEquals((Object)this.modification, (Object)request.getModification());
    }

    @Test
    public void testModifyAfterCommitRequest() throws Exception {
        ((LocalReadWriteProxyTransaction)this.transaction).doWrite(PATH_1, (NormalizedNode)DATA_1);
        boolean coordinated = true;
        ((LocalReadWriteProxyTransaction)this.transaction).commitRequest(true);
        TestUtils.assertOperationThrowsException(() -> ((LocalReadWriteProxyTransaction)this.transaction).doMerge(PATH_1, (NormalizedNode)DATA_1), IllegalStateException.class);
    }

    @Test
    public void testSealOnly() throws Exception {
        TestUtils.assertOperationThrowsException(() -> ((LocalReadWriteProxyTransaction)this.transaction).getSnapshot(), IllegalStateException.class);
        ((LocalReadWriteProxyTransaction)this.transaction).sealOnly();
        Assert.assertEquals((Object)this.modification, (Object)((LocalReadWriteProxyTransaction)this.transaction).getSnapshot());
    }

    @Test
    public void testFlushState() {
        TransactionTester<RemoteProxyTransaction> transactionTester = this.createRemoteProxyTransactionTester();
        RemoteProxyTransaction successor = transactionTester.getTransaction();
        ((CursorAwareDataTreeModification)Mockito.doAnswer(LocalProxyTransactionTest::applyToCursorAnswer).when((Object)this.modification)).applyToCursor((DataTreeModificationCursor)ArgumentMatchers.any());
        ((LocalReadWriteProxyTransaction)this.transaction).sealOnly();
        TransactionRequest request = (TransactionRequest)((LocalReadWriteProxyTransaction)this.transaction).flushState().get();
        ((LocalReadWriteProxyTransaction)this.transaction).forwardToSuccessor((AbstractProxyTransaction)successor, request, null);
        ((CursorAwareDataTreeModification)Mockito.verify((Object)this.modification)).applyToCursor((DataTreeModificationCursor)ArgumentMatchers.any());
        transactionTester.getTransaction().seal();
        transactionTester.getTransaction().directCommit();
        ModifyTransactionRequest modifyRequest = transactionTester.expectTransactionRequest(ModifyTransactionRequest.class);
        this.checkModifications(modifyRequest);
    }

    @Test
    public void testApplyModifyTransactionRequestCoordinated() {
        this.applyModifyTransactionRequest(true);
    }

    @Test
    public void testApplyModifyTransactionRequestSimple() {
        this.applyModifyTransactionRequest(false);
    }

    @Test
    public void testApplyModifyTransactionRequestAbort() {
        TestProbe probe = this.createProbe();
        ModifyTransactionRequestBuilder builder = new ModifyTransactionRequestBuilder(TRANSACTION_ID, probe.ref());
        builder.setSequence(0L);
        builder.setAbort();
        ModifyTransactionRequest request = builder.build();
        Consumer callback = LocalReadWriteProxyTransactionTest.createCallbackMock();
        ((LocalReadWriteProxyTransaction)this.transaction).replayModifyTransactionRequest(request, callback, Ticker.systemTicker().read());
        this.getTester().expectTransactionRequest(AbortLocalTransactionRequest.class);
    }

    @Test
    public void testHandleForwardedRemotePreCommitRequest() {
        TestProbe probe = this.createProbe();
        TransactionPreCommitRequest request = new TransactionPreCommitRequest(TRANSACTION_ID, 0L, probe.ref());
        this.testHandleForwardedRemoteRequest(request);
    }

    @Test
    public void testHandleForwardedRemoteDoCommitRequest() {
        TestProbe probe = this.createProbe();
        TransactionDoCommitRequest request = new TransactionDoCommitRequest(TRANSACTION_ID, 0L, probe.ref());
        this.testHandleForwardedRemoteRequest(request);
    }

    @Test
    public void testHandleForwardedRemoteAbortRequest() {
        TestProbe probe = this.createProbe();
        TransactionAbortRequest request = new TransactionAbortRequest(TRANSACTION_ID, 0L, probe.ref());
        this.testHandleForwardedRemoteRequest(request);
    }

    @Test
    public void testForwardToLocalCommit() {
        TestProbe probe = this.createProbe();
        DataTreeModification mod = (DataTreeModification)Mockito.mock(DataTreeModification.class);
        CommitLocalTransactionRequest request = new CommitLocalTransactionRequest(TRANSACTION_ID, 0L, probe.ref(), mod, null, false);
        this.testForwardToLocal((TransactionRequest<?>)request, CommitLocalTransactionRequest.class);
    }

    @Test
    public void testSendAbort() throws Exception {
        TestProbe probe = this.createProbe();
        AbortLocalTransactionRequest request = new AbortLocalTransactionRequest(TRANSACTION_ID, probe.ref());
        ((LocalReadWriteProxyTransaction)this.transaction).sendAbort((TransactionRequest)request, LocalReadWriteProxyTransactionTest.createCallbackMock());
        TestUtils.assertOperationThrowsException(() -> ((LocalReadWriteProxyTransaction)this.transaction).delete(PATH_1), IllegalStateException.class);
    }

    private void applyModifyTransactionRequest(boolean coordinated) {
        TestProbe probe = this.createProbe();
        ModifyTransactionRequestBuilder builder = new ModifyTransactionRequestBuilder(TRANSACTION_ID, probe.ref());
        TransactionWrite write = new TransactionWrite(PATH_1, (NormalizedNode)DATA_1);
        TransactionMerge merge = new TransactionMerge(PATH_2, (NormalizedNode)DATA_2);
        TransactionDelete delete = new TransactionDelete(PATH_3);
        builder.addModification((TransactionModification)write);
        builder.addModification((TransactionModification)merge);
        builder.addModification((TransactionModification)delete);
        builder.setSequence(0L);
        builder.setCommit(coordinated);
        ModifyTransactionRequest request = builder.build();
        Consumer callback = LocalReadWriteProxyTransactionTest.createCallbackMock();
        ((LocalReadWriteProxyTransaction)this.transaction).replayModifyTransactionRequest(request, callback, Ticker.systemTicker().read());
        ((CursorAwareDataTreeModification)Mockito.verify((Object)this.modification)).write(PATH_1, (NormalizedNode)DATA_1);
        ((CursorAwareDataTreeModification)Mockito.verify((Object)this.modification)).merge(PATH_2, (NormalizedNode)DATA_2);
        ((CursorAwareDataTreeModification)Mockito.verify((Object)this.modification)).delete(PATH_3);
        CommitLocalTransactionRequest commitRequest = this.getTester().expectTransactionRequest(CommitLocalTransactionRequest.class);
        Assert.assertEquals((Object)this.modification, (Object)commitRequest.getModification());
        Assert.assertEquals((Object)coordinated, (Object)commitRequest.isCoordinated());
    }
}

