/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.databroker.actors.dds;

import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.opendaylight.controller.cluster.access.concepts.ClientIdentifier;
import org.opendaylight.controller.cluster.access.concepts.FrontendIdentifier;
import org.opendaylight.controller.cluster.access.concepts.FrontendType;
import org.opendaylight.controller.cluster.access.concepts.LocalHistoryIdentifier;
import org.opendaylight.controller.cluster.access.concepts.MemberName;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;

final class TestUtils {
    static final MemberName MEMBER_NAME = MemberName.forName((String)"member-1");
    static final FrontendType FRONTEND_TYPE = FrontendType.forName((String)"type-1");
    static final FrontendIdentifier FRONTEND_ID = FrontendIdentifier.create((MemberName)MEMBER_NAME, (FrontendType)FRONTEND_TYPE);
    static final ClientIdentifier CLIENT_ID = ClientIdentifier.create((FrontendIdentifier)FRONTEND_ID, (long)0L);
    static final LocalHistoryIdentifier HISTORY_ID = new LocalHistoryIdentifier(CLIENT_ID, 0L);
    static final TransactionIdentifier TRANSACTION_ID = new TransactionIdentifier(HISTORY_ID, 0L);
    private static final long TIMEOUT = 3L;

    private TestUtils() {
    }

    static <T> void assertFutureEquals(T expected, Future<T> actual) throws Exception {
        Assert.assertEquals(expected, TestUtils.getWithTimeout(actual));
    }

    static <T> T getWithTimeout(Future<T> future) throws Exception {
        return future.get(3L, TimeUnit.SECONDS);
    }

    static <T extends Throwable> T assertOperationThrowsException(RunnableWithException operation, Class<T> expectedException, String message) throws Exception {
        try {
            operation.run();
            throw new AssertionError((Object)(message + expectedException));
        }
        catch (Throwable e) {
            if (!e.getClass().equals(expectedException)) {
                throw e;
            }
            return (T)((Throwable)expectedException.cast(e));
        }
    }

    static <T extends Throwable> T assertOperationThrowsException(RunnableWithException operation, Class<T> expectedException) throws Exception {
        return TestUtils.assertOperationThrowsException(operation, expectedException, "Operation should throw exception: ");
    }

    @FunctionalInterface
    public static interface RunnableWithException {
        public void run() throws Exception;
    }
}

