/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.PoisonPill;
import akka.actor.Props;
import akka.dispatch.Dispatchers;
import akka.japi.Creator;
import akka.pattern.Patterns;
import akka.testkit.TestActorRef;
import akka.util.Timeout;
import com.google.common.primitives.UnsignedLong;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Uninterruptibles;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.opendaylight.controller.cluster.access.concepts.MemberName;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;
import org.opendaylight.controller.cluster.datastore.AbstractActorTest;
import org.opendaylight.controller.cluster.datastore.DatastoreContext;
import org.opendaylight.controller.cluster.datastore.ReadWriteShardDataTreeTransaction;
import org.opendaylight.controller.cluster.datastore.Shard;
import org.opendaylight.controller.cluster.datastore.ShardDataTree;
import org.opendaylight.controller.cluster.datastore.ShardDataTreeCohort;
import org.opendaylight.controller.cluster.datastore.ShardDataTreeMocking;
import org.opendaylight.controller.cluster.datastore.identifiers.ShardIdentifier;
import org.opendaylight.controller.cluster.datastore.messages.BatchedModifications;
import org.opendaylight.controller.cluster.datastore.messages.ForwardedReadyTransaction;
import org.opendaylight.controller.cluster.datastore.modification.MergeModification;
import org.opendaylight.controller.cluster.datastore.modification.Modification;
import org.opendaylight.controller.cluster.datastore.modification.MutableCompositeModification;
import org.opendaylight.controller.cluster.datastore.modification.WriteModification;
import org.opendaylight.controller.cluster.datastore.persisted.CommitTransactionPayload;
import org.opendaylight.controller.cluster.datastore.persisted.MetadataShardDataTreeSnapshot;
import org.opendaylight.controller.cluster.datastore.persisted.ShardDataTreeSnapshot;
import org.opendaylight.controller.cluster.datastore.persisted.ShardSnapshotState;
import org.opendaylight.controller.cluster.raft.TestActorFactory;
import org.opendaylight.controller.cluster.raft.persisted.Snapshot;
import org.opendaylight.controller.cluster.raft.utils.InMemoryJournal;
import org.opendaylight.controller.cluster.raft.utils.InMemorySnapshotStore;
import org.opendaylight.controller.md.cluster.datastore.model.CarsModel;
import org.opendaylight.controller.md.cluster.datastore.model.TestModel;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerChild;
import org.opendaylight.yangtools.yang.data.api.schema.MapEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTree;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeCandidate;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeCandidateNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeCandidateTip;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeConfiguration;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeModification;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataValidationFailedException;
import org.opendaylight.yangtools.yang.data.api.schema.tree.ModificationType;
import org.opendaylight.yangtools.yang.data.impl.schema.ImmutableNodes;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.InMemoryDataTreeFactory;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import scala.concurrent.Await;
import scala.concurrent.Awaitable;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;

public abstract class AbstractShardTest
extends AbstractActorTest {
    protected static final EffectiveModelContext SCHEMA_CONTEXT = TestModel.createTestContext();
    private static final AtomicInteger NEXT_SHARD_NUM = new AtomicInteger();
    protected static final int HEARTBEAT_MILLIS = 100;
    protected final ShardIdentifier shardID = ShardIdentifier.create((String)"inventory", (MemberName)MemberName.forName((String)"member-1"), (String)("config" + NEXT_SHARD_NUM.getAndIncrement()));
    protected final DatastoreContext.Builder dataStoreContextBuilder = DatastoreContext.newBuilder().shardJournalRecoveryLogBatchSize(3).shardSnapshotBatchCount(5000).shardHeartbeatIntervalInMillis(100);
    protected final TestActorFactory actorFactory = new TestActorFactory(AbstractShardTest.getSystem());

    @Before
    public void setUp() {
        InMemorySnapshotStore.clear();
        InMemoryJournal.clear();
    }

    @After
    public void tearDown() {
        InMemorySnapshotStore.clear();
        InMemoryJournal.clear();
        this.actorFactory.close();
    }

    protected DatastoreContext newDatastoreContext() {
        return this.dataStoreContextBuilder.build();
    }

    protected Props newShardProps() {
        return this.newShardBuilder().props();
    }

    protected Shard.Builder newShardBuilder() {
        return (Shard.Builder)((Shard.Builder)((Shard.Builder)Shard.builder().id(this.shardID)).datastoreContext(this.newDatastoreContext())).schemaContextProvider(() -> SCHEMA_CONTEXT);
    }

    protected void testRecovery(Set<Integer> listEntryKeys) throws Exception {
        int nListEntries = listEntryKeys.size();
        final CountDownLatch recoveryComplete = new CountDownLatch(1);
        Creator & Serializable creator = (Creator & Serializable)() -> new Shard((Shard.AbstractBuilder)this.newShardBuilder()){

            protected void onRecoveryComplete() {
                try {
                    super.onRecoveryComplete();
                }
                finally {
                    recoveryComplete.countDown();
                }
            }
        };
        TestActorRef shard = TestActorRef.create((ActorSystem)AbstractShardTest.getSystem(), (Props)Props.create(Shard.class, (Creator)new DelegatingShardCreator((Creator<Shard>)creator)).withDispatcher(Dispatchers.DefaultDispatcherId()), (String)"testRecovery");
        Assert.assertTrue((String)"Recovery complete", (boolean)recoveryComplete.await(5L, TimeUnit.SECONDS));
        NormalizedNode<?, ?> outerList = AbstractShardTest.readStore((TestActorRef<? extends Shard>)shard, TestModel.OUTER_LIST_PATH);
        Assert.assertNotNull((String)(TestModel.OUTER_LIST_QNAME.getLocalName() + " not found"), outerList);
        Assert.assertTrue((String)(TestModel.OUTER_LIST_QNAME.getLocalName() + " value is not Iterable"), (boolean)(outerList.getValue() instanceof Iterable));
        for (Object entry : (Iterable)outerList.getValue()) {
            Assert.assertTrue((String)(TestModel.OUTER_LIST_QNAME.getLocalName() + " entry is not MapEntryNode"), (boolean)(entry instanceof MapEntryNode));
            MapEntryNode mapEntry = (MapEntryNode)entry;
            Optional idLeaf = mapEntry.getChild((YangInstanceIdentifier.PathArgument)new YangInstanceIdentifier.NodeIdentifier(TestModel.ID_QNAME));
            Assert.assertTrue((String)("Missing leaf " + TestModel.ID_QNAME.getLocalName()), (boolean)idLeaf.isPresent());
            Object value = ((DataContainerChild)idLeaf.get()).getValue();
            Assert.assertTrue((String)("Unexpected value for leaf " + TestModel.ID_QNAME.getLocalName() + ": " + value), (boolean)listEntryKeys.remove(value));
        }
        if (!listEntryKeys.isEmpty()) {
            Assert.fail((String)("Missing " + TestModel.OUTER_LIST_QNAME.getLocalName() + " entries with keys: " + listEntryKeys));
        }
        Assert.assertEquals((String)"Last log index", (long)nListEntries, (long)((Shard)shard.underlyingActor()).getShardMBean().getLastLogIndex());
        Assert.assertEquals((String)"Commit index", (long)nListEntries, (long)((Shard)shard.underlyingActor()).getShardMBean().getCommitIndex());
        Assert.assertEquals((String)"Last applied", (long)nListEntries, (long)((Shard)shard.underlyingActor()).getShardMBean().getLastApplied());
        shard.tell((Object)PoisonPill.getInstance(), ActorRef.noSender());
    }

    protected void verifyLastApplied(TestActorRef<Shard> shard, long expectedValue) {
        long lastApplied = -1L;
        for (int i = 0; i < 100; ++i) {
            lastApplied = ((Shard)shard.underlyingActor()).getShardMBean().getLastApplied();
            if (lastApplied == expectedValue) {
                return;
            }
            Uninterruptibles.sleepUninterruptibly((long)50L, (TimeUnit)TimeUnit.MILLISECONDS);
        }
        Assert.fail((String)String.format("Expected last applied: %d, Actual: %d", expectedValue, lastApplied));
    }

    protected DataTree createDelegatingMockDataTree() throws Exception {
        DataTree actual = new InMemoryDataTreeFactory().create(DataTreeConfiguration.DEFAULT_CONFIGURATION);
        DataTree mock = (DataTree)Mockito.mock(DataTree.class);
        ((DataTree)Mockito.doAnswer(invocation -> {
            actual.validate((DataTreeModification)invocation.getArgument(0));
            return null;
        }).when((Object)mock)).validate((DataTreeModification)ArgumentMatchers.any(DataTreeModification.class));
        ((DataTree)Mockito.doAnswer(invocation -> actual.prepare((DataTreeModification)invocation.getArgument(0))).when((Object)mock)).prepare((DataTreeModification)ArgumentMatchers.any(DataTreeModification.class));
        ((DataTree)Mockito.doAnswer(invocation -> {
            actual.commit((DataTreeCandidate)invocation.getArgument(0));
            return null;
        }).when((Object)mock)).commit((DataTreeCandidate)ArgumentMatchers.any(DataTreeCandidate.class));
        ((DataTree)Mockito.doAnswer(invocation -> {
            actual.setEffectiveModelContext((EffectiveModelContext)invocation.getArgument(0));
            return null;
        }).when((Object)mock)).setEffectiveModelContext((EffectiveModelContext)ArgumentMatchers.any(EffectiveModelContext.class));
        ((DataTree)Mockito.doAnswer(invocation -> actual.takeSnapshot()).when((Object)mock)).takeSnapshot();
        ((DataTree)Mockito.doAnswer(invocation -> actual.getRootPath()).when((Object)mock)).getRootPath();
        return mock;
    }

    protected ShardDataTreeCohort mockShardDataTreeCohort() {
        ShardDataTreeCohort cohort = (ShardDataTreeCohort)Mockito.mock(ShardDataTreeCohort.class);
        DataTreeCandidateTip candidate = AbstractShardTest.mockCandidate("candidate");
        ShardDataTreeMocking.successfulCanCommit(cohort);
        ShardDataTreeMocking.successfulPreCommit(cohort, (DataTreeCandidate)candidate);
        ShardDataTreeMocking.successfulCommit(cohort);
        ((ShardDataTreeCohort)Mockito.doReturn((Object)candidate).when((Object)cohort)).getCandidate();
        return cohort;
    }

    protected Map<TransactionIdentifier, CapturingShardDataTreeCohort> setupCohortDecorator(Shard shard, TransactionIdentifier ... transactionIDs) {
        HashMap<TransactionIdentifier, CapturingShardDataTreeCohort> cohortMap = new HashMap<TransactionIdentifier, CapturingShardDataTreeCohort>();
        for (TransactionIdentifier id : transactionIDs) {
            cohortMap.put(id, new CapturingShardDataTreeCohort());
        }
        shard.getCommitCoordinator().setCohortDecorator((transactionID, actual) -> {
            CapturingShardDataTreeCohort cohort = (CapturingShardDataTreeCohort)((Object)((Object)cohortMap.get(transactionID)));
            cohort.setDelegate(actual);
            return cohort;
        });
        return cohortMap;
    }

    protected BatchedModifications prepareBatchedModifications(TransactionIdentifier transactionID, MutableCompositeModification modification) {
        return AbstractShardTest.prepareBatchedModifications(transactionID, modification, false);
    }

    protected static BatchedModifications prepareBatchedModifications(TransactionIdentifier transactionID, MutableCompositeModification modification, boolean doCommitOnReady) {
        BatchedModifications batchedModifications = new BatchedModifications(transactionID, 11);
        batchedModifications.addModification((Modification)modification);
        batchedModifications.setReady();
        batchedModifications.setDoCommitOnReady(doCommitOnReady);
        batchedModifications.setTotalMessagesSent(1);
        return batchedModifications;
    }

    protected static BatchedModifications prepareBatchedModifications(TransactionIdentifier transactionID, YangInstanceIdentifier path, NormalizedNode<?, ?> data, boolean doCommitOnReady) {
        MutableCompositeModification modification = new MutableCompositeModification();
        modification.addModification((Modification)new WriteModification(path, data));
        return AbstractShardTest.prepareBatchedModifications(transactionID, modification, doCommitOnReady);
    }

    protected static ForwardedReadyTransaction prepareForwardedReadyTransaction(TestActorRef<Shard> shard, TransactionIdentifier transactionID, YangInstanceIdentifier path, NormalizedNode<?, ?> data, boolean doCommitOnReady) {
        ReadWriteShardDataTreeTransaction rwTx = ((Shard)shard.underlyingActor()).getDataStore().newReadWriteTransaction(transactionID);
        ((DataTreeModification)rwTx.getSnapshot()).write(path, data);
        return new ForwardedReadyTransaction(transactionID, 11, rwTx, doCommitOnReady, Optional.empty());
    }

    public static NormalizedNode<?, ?> readStore(TestActorRef<? extends Shard> shard, YangInstanceIdentifier id) {
        return ((Shard)shard.underlyingActor()).getDataStore().readNode(id).orElse(null);
    }

    public static NormalizedNode<?, ?> readStore(DataTree store, YangInstanceIdentifier id) {
        return store.takeSnapshot().readNode(id).orElse(null);
    }

    public void writeToStore(TestActorRef<Shard> shard, YangInstanceIdentifier id, NormalizedNode<?, ?> node) throws InterruptedException, ExecutionException {
        Future future = Patterns.ask(shard, (Object)AbstractShardTest.newBatchedModifications(AbstractShardTest.nextTransactionId(), id, node, true, true, 1), (Timeout)new Timeout(5L, TimeUnit.SECONDS));
        try {
            Await.ready((Awaitable)future, (Duration)FiniteDuration.create((long)5L, (TimeUnit)TimeUnit.SECONDS));
        }
        catch (TimeoutException e) {
            throw new ExecutionException(e);
        }
    }

    public static void writeToStore(ShardDataTree store, YangInstanceIdentifier id, NormalizedNode<?, ?> node) throws DataValidationFailedException {
        BatchedModifications batched = AbstractShardTest.newBatchedModifications(AbstractShardTest.nextTransactionId(), id, node, true, true, 1);
        DataTreeModification modification = store.getDataTree().takeSnapshot().newModification();
        batched.apply(modification);
        store.notifyListeners(AbstractShardTest.commitTransaction(store.getDataTree(), modification));
    }

    public static void writeToStore(DataTree store, YangInstanceIdentifier id, NormalizedNode<?, ?> node) throws DataValidationFailedException {
        DataTreeModification transaction = store.takeSnapshot().newModification();
        transaction.write(id, node);
        transaction.ready();
        store.validate(transaction);
        DataTreeCandidateTip candidate = store.prepare(transaction);
        store.commit((DataTreeCandidate)candidate);
    }

    public void mergeToStore(ShardDataTree store, YangInstanceIdentifier id, NormalizedNode<?, ?> node) throws DataValidationFailedException {
        BatchedModifications batched = new BatchedModifications(AbstractShardTest.nextTransactionId(), 11);
        batched.addModification((Modification)new MergeModification(id, node));
        batched.setReady();
        batched.setDoCommitOnReady(true);
        batched.setTotalMessagesSent(1);
        DataTreeModification modification = store.getDataTree().takeSnapshot().newModification();
        batched.apply(modification);
        store.notifyListeners(AbstractShardTest.commitTransaction(store.getDataTree(), modification));
    }

    DataTree setupInMemorySnapshotStore() throws DataValidationFailedException {
        DataTree testStore = new InMemoryDataTreeFactory().create(DataTreeConfiguration.DEFAULT_OPERATIONAL, SCHEMA_CONTEXT);
        AbstractShardTest.writeToStore(testStore, TestModel.TEST_PATH, ImmutableNodes.containerNode((QName)TestModel.TEST_QNAME));
        NormalizedNode<?, ?> root = AbstractShardTest.readStore(testStore, YangInstanceIdentifier.empty());
        InMemorySnapshotStore.addSnapshot((String)this.shardID.toString(), (Object)Snapshot.create((Snapshot.State)new ShardSnapshotState((ShardDataTreeSnapshot)new MetadataShardDataTreeSnapshot(root)), Collections.emptyList(), (long)0L, (long)1L, (long)-1L, (long)-1L, (long)1L, null, null));
        return testStore;
    }

    static CommitTransactionPayload payloadForModification(DataTree source, DataTreeModification mod, TransactionIdentifier transactionId) throws DataValidationFailedException, IOException {
        source.validate(mod);
        DataTreeCandidateTip candidate = source.prepare(mod);
        source.commit((DataTreeCandidate)candidate);
        return CommitTransactionPayload.create((TransactionIdentifier)transactionId, (DataTreeCandidate)candidate);
    }

    static BatchedModifications newBatchedModifications(TransactionIdentifier transactionID, YangInstanceIdentifier path, NormalizedNode<?, ?> data, boolean ready, boolean doCommitOnReady, int messagesSent) {
        BatchedModifications batched = new BatchedModifications(transactionID, 11);
        batched.addModification((Modification)new WriteModification(path, data));
        if (ready) {
            batched.setReady();
        }
        batched.setDoCommitOnReady(doCommitOnReady);
        batched.setTotalMessagesSent(messagesSent);
        return batched;
    }

    static BatchedModifications newReadyBatchedModifications(TransactionIdentifier transactionID, YangInstanceIdentifier path, NormalizedNode<?, ?> data, SortedSet<String> participatingShardNames) {
        BatchedModifications batched = new BatchedModifications(transactionID, 11);
        batched.addModification((Modification)new WriteModification(path, data));
        batched.setReady(Optional.of(participatingShardNames));
        batched.setTotalMessagesSent(1);
        return batched;
    }

    static void verifyOuterListEntry(TestActorRef<Shard> shard, Object expIDValue) {
        NormalizedNode<?, ?> outerList = AbstractShardTest.readStore(shard, TestModel.OUTER_LIST_PATH);
        Assert.assertNotNull((String)(TestModel.OUTER_LIST_QNAME.getLocalName() + " not found"), outerList);
        Assert.assertTrue((String)(TestModel.OUTER_LIST_QNAME.getLocalName() + " value is not Iterable"), (boolean)(outerList.getValue() instanceof Iterable));
        Object entry = ((Iterable)outerList.getValue()).iterator().next();
        Assert.assertTrue((String)(TestModel.OUTER_LIST_QNAME.getLocalName() + " entry is not MapEntryNode"), (boolean)(entry instanceof MapEntryNode));
        MapEntryNode mapEntry = (MapEntryNode)entry;
        Optional idLeaf = mapEntry.getChild((YangInstanceIdentifier.PathArgument)new YangInstanceIdentifier.NodeIdentifier(TestModel.ID_QNAME));
        Assert.assertTrue((String)("Missing leaf " + TestModel.ID_QNAME.getLocalName()), (boolean)idLeaf.isPresent());
        Assert.assertEquals((String)(TestModel.ID_QNAME.getLocalName() + " value"), (Object)expIDValue, (Object)((DataContainerChild)idLeaf.get()).getValue());
    }

    public static DataTreeCandidateTip mockCandidate(String name) {
        DataTreeCandidateTip mockCandidate = (DataTreeCandidateTip)Mockito.mock(DataTreeCandidateTip.class, (String)name);
        DataTreeCandidateNode mockCandidateNode = (DataTreeCandidateNode)Mockito.mock(DataTreeCandidateNode.class, (String)(name + "-node"));
        ((DataTreeCandidateNode)Mockito.doReturn((Object)ModificationType.WRITE).when((Object)mockCandidateNode)).getModificationType();
        ((DataTreeCandidateNode)Mockito.doReturn(Optional.of(ImmutableNodes.containerNode((QName)CarsModel.CARS_QNAME))).when((Object)mockCandidateNode)).getDataAfter();
        ((DataTreeCandidateTip)Mockito.doReturn((Object)CarsModel.BASE_PATH).when((Object)mockCandidate)).getRootPath();
        ((DataTreeCandidateTip)Mockito.doReturn((Object)mockCandidateNode).when((Object)mockCandidate)).getRootNode();
        return mockCandidate;
    }

    static DataTreeCandidateTip mockUnmodifiedCandidate(String name) {
        DataTreeCandidateTip mockCandidate = (DataTreeCandidateTip)Mockito.mock(DataTreeCandidateTip.class, (String)name);
        DataTreeCandidateNode mockCandidateNode = (DataTreeCandidateNode)Mockito.mock(DataTreeCandidateNode.class, (String)(name + "-node"));
        ((DataTreeCandidateNode)Mockito.doReturn((Object)ModificationType.UNMODIFIED).when((Object)mockCandidateNode)).getModificationType();
        ((DataTreeCandidateTip)Mockito.doReturn((Object)YangInstanceIdentifier.empty()).when((Object)mockCandidate)).getRootPath();
        ((DataTreeCandidateTip)Mockito.doReturn((Object)mockCandidateNode).when((Object)mockCandidate)).getRootNode();
        return mockCandidate;
    }

    static DataTreeCandidate commitTransaction(DataTree store, DataTreeModification modification) throws DataValidationFailedException {
        modification.ready();
        store.validate(modification);
        DataTreeCandidateTip candidate = store.prepare(modification);
        store.commit((DataTreeCandidate)candidate);
        return candidate;
    }

    public static class CapturingShardDataTreeCohort
    extends ShardDataTreeCohort {
        private volatile ShardDataTreeCohort delegate;
        private FutureCallback<Void> canCommit;
        private FutureCallback<DataTreeCandidate> preCommit;
        private FutureCallback<UnsignedLong> commit;

        public void setDelegate(ShardDataTreeCohort delegate) {
            this.delegate = delegate;
        }

        public FutureCallback<Void> getCanCommit() {
            Assert.assertNotNull((String)"canCommit was not invoked", this.canCommit);
            return this.canCommit;
        }

        public FutureCallback<DataTreeCandidate> getPreCommit() {
            Assert.assertNotNull((String)"preCommit was not invoked", this.preCommit);
            return this.preCommit;
        }

        public FutureCallback<UnsignedLong> getCommit() {
            Assert.assertNotNull((String)"commit was not invoked", this.commit);
            return this.commit;
        }

        public TransactionIdentifier getIdentifier() {
            return (TransactionIdentifier)this.delegate.getIdentifier();
        }

        DataTreeCandidateTip getCandidate() {
            return this.delegate.getCandidate();
        }

        DataTreeModification getDataTreeModification() {
            return this.delegate.getDataTreeModification();
        }

        public void canCommit(FutureCallback<Void> callback) {
            this.canCommit = CapturingShardDataTreeCohort.mockFutureCallback(callback);
            this.delegate.canCommit(this.canCommit);
        }

        public void preCommit(FutureCallback<DataTreeCandidate> callback) {
            this.preCommit = CapturingShardDataTreeCohort.mockFutureCallback(callback);
            this.delegate.preCommit(this.preCommit);
        }

        public void commit(FutureCallback<UnsignedLong> callback) {
            this.commit = CapturingShardDataTreeCohort.mockFutureCallback(callback);
            this.delegate.commit(this.commit);
        }

        private static <T> FutureCallback<T> mockFutureCallback(FutureCallback<T> actual) {
            FutureCallback mock = (FutureCallback)Mockito.mock(FutureCallback.class);
            ((FutureCallback)Mockito.doAnswer(invocation -> {
                actual.onFailure((Throwable)invocation.getArgument(0));
                return null;
            }).when((Object)mock)).onFailure((Throwable)ArgumentMatchers.any(Throwable.class));
            ((FutureCallback)Mockito.doAnswer(invocation -> {
                actual.onSuccess(invocation.getArgument(0));
                return null;
            }).when((Object)mock)).onSuccess(ArgumentMatchers.nullable(Object.class));
            return mock;
        }

        public void abort(FutureCallback<Void> callback) {
            this.delegate.abort(callback);
        }

        public boolean isFailed() {
            return this.delegate.isFailed();
        }

        public ShardDataTreeCohort.State getState() {
            return this.delegate.getState();
        }

        Optional<SortedSet<String>> getParticipatingShardNames() {
            return this.delegate.getParticipatingShardNames();
        }
    }

    public static final class DelegatingShardCreator
    implements Creator<Shard> {
        private final Creator<Shard> delegate;

        DelegatingShardCreator(Creator<Shard> delegate) {
            this.delegate = delegate;
        }

        public Shard create() throws Exception {
            return (Shard)this.delegate.create();
        }
    }
}

