/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import akka.actor.ActorRef;
import akka.actor.ActorSelection;
import akka.pattern.Patterns;
import akka.testkit.TestActorRef;
import akka.testkit.javadsl.TestKit;
import akka.util.Timeout;
import java.util.AbstractMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.opendaylight.controller.cluster.datastore.AbstractShardTest;
import org.opendaylight.controller.cluster.datastore.DataTreeChangeListenerActor;
import org.opendaylight.controller.cluster.datastore.Shard;
import org.opendaylight.controller.cluster.datastore.ShardTestKit;
import org.opendaylight.controller.cluster.datastore.messages.CloseDataTreeNotificationListenerRegistration;
import org.opendaylight.controller.cluster.datastore.messages.CloseDataTreeNotificationListenerRegistrationReply;
import org.opendaylight.controller.cluster.datastore.messages.RegisterDataTreeChangeListener;
import org.opendaylight.controller.cluster.datastore.messages.RegisterDataTreeNotificationListenerReply;
import org.opendaylight.controller.cluster.datastore.utils.MockDataTreeChangeListener;
import org.opendaylight.controller.md.cluster.datastore.model.TestModel;
import org.opendaylight.mdsal.dom.api.DOMDataTreeChangeListener;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataValidationFailedException;
import org.opendaylight.yangtools.yang.data.impl.schema.ImmutableNodes;
import scala.concurrent.Await;
import scala.concurrent.Awaitable;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;

public class DataTreeChangeListenerSupportTest
extends AbstractShardTest {
    private Shard shard;
    private TestActorRef<Shard> shardActor;

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.createShard();
    }

    @Override
    @After
    public void tearDown() {
        super.tearDown();
        this.actorFactory.close();
    }

    @Test
    public void testChangeListenerWithNoInitialData() {
        MockDataTreeChangeListener listener = this.registerChangeListener(TestModel.TEST_PATH, 0).getKey();
        listener.expectNoMoreChanges("Unexpected initial change event");
    }

    @Test
    public void testInitialChangeListenerEventWithContainerPath() throws DataValidationFailedException {
        DataTreeChangeListenerSupportTest.writeToStore(this.shard.getDataStore(), TestModel.TEST_PATH, ImmutableNodes.containerNode((QName)TestModel.TEST_QNAME));
        Map.Entry<MockDataTreeChangeListener, ActorSelection> entry = this.registerChangeListener(TestModel.TEST_PATH, 1);
        MockDataTreeChangeListener listener = entry.getKey();
        listener.waitForChangeEvents(new YangInstanceIdentifier[0]);
        listener.verifyNotifiedData(TestModel.TEST_PATH);
        listener.reset(1);
        DataTreeChangeListenerSupportTest.writeToStore(this.shard.getDataStore(), TestModel.TEST_PATH, ImmutableNodes.containerNode((QName)TestModel.TEST_QNAME));
        listener.waitForChangeEvents(new YangInstanceIdentifier[0]);
        listener.verifyNotifiedData(TestModel.TEST_PATH);
        listener.reset(1);
        TestKit kit = new TestKit(DataTreeChangeListenerSupportTest.getSystem());
        entry.getValue().tell((Object)CloseDataTreeNotificationListenerRegistration.getInstance(), kit.getRef());
        kit.expectMsgClass(java.time.Duration.ofSeconds(5L), CloseDataTreeNotificationListenerRegistrationReply.class);
        DataTreeChangeListenerSupportTest.writeToStore(this.shard.getDataStore(), TestModel.TEST_PATH, ImmutableNodes.containerNode((QName)TestModel.TEST_QNAME));
        listener.verifyNoNotifiedData(TestModel.TEST_PATH);
    }

    @Test
    public void testInitialChangeListenerEventWithListPath() throws DataValidationFailedException {
        this.mergeToStore(this.shard.getDataStore(), TestModel.TEST_PATH, TestModel.testNodeWithOuter(1, 2));
        MockDataTreeChangeListener listener = this.registerChangeListener(TestModel.OUTER_LIST_PATH, 1).getKey();
        listener.waitForChangeEvents(new YangInstanceIdentifier[0]);
        listener.verifyNotifiedData(TestModel.OUTER_LIST_PATH);
    }

    @Test
    public void testInitialChangeListenerEventWithWildcardedListPath() throws DataValidationFailedException {
        this.mergeToStore(this.shard.getDataStore(), TestModel.TEST_PATH, TestModel.testNodeWithOuter(1, 2));
        MockDataTreeChangeListener listener = this.registerChangeListener(TestModel.OUTER_LIST_PATH.node(TestModel.OUTER_LIST_QNAME), 1).getKey();
        listener.waitForChangeEvents(new YangInstanceIdentifier[0]);
        listener.verifyNotifiedData(TestModel.outerEntryPath(1), TestModel.outerEntryPath(2));
    }

    @Test
    public void testInitialChangeListenerEventWithNestedWildcardedListsPath() throws DataValidationFailedException {
        this.mergeToStore(this.shard.getDataStore(), TestModel.TEST_PATH, TestModel.testNodeWithOuter(TestModel.outerNode(TestModel.outerNodeEntry(1, TestModel.innerNode("one", "two")), TestModel.outerNodeEntry(2, TestModel.innerNode("three", "four")))));
        MockDataTreeChangeListener listener = this.registerChangeListener(TestModel.OUTER_LIST_PATH.node(TestModel.OUTER_LIST_QNAME).node(TestModel.INNER_LIST_QNAME).node(TestModel.INNER_LIST_QNAME), 1).getKey();
        listener.waitForChangeEvents(new YangInstanceIdentifier[0]);
        listener.verifyNotifiedData(TestModel.innerEntryPath(1, "one"), TestModel.innerEntryPath(1, "two"), TestModel.innerEntryPath(2, "three"), TestModel.innerEntryPath(2, "four"));
        MockDataTreeChangeListener listener2 = this.registerChangeListener(TestModel.OUTER_LIST_PATH.node((YangInstanceIdentifier.PathArgument)TestModel.outerEntryKey(1)).node(TestModel.INNER_LIST_QNAME).node(TestModel.INNER_LIST_QNAME), 1).getKey();
        listener2.waitForChangeEvents(new YangInstanceIdentifier[0]);
        listener2.verifyNotifiedData(TestModel.innerEntryPath(1, "one"), TestModel.innerEntryPath(1, "two"));
        listener2.verifyNoNotifiedData(TestModel.innerEntryPath(2, "three"), TestModel.innerEntryPath(2, "four"));
        listener.reset(1);
        listener2.reset(1);
        this.mergeToStore(this.shard.getDataStore(), TestModel.TEST_PATH, TestModel.testNodeWithOuter(TestModel.outerNode(TestModel.outerNodeEntry(1, TestModel.innerNode("three")))));
        listener.waitForChangeEvents(new YangInstanceIdentifier[0]);
        listener.verifyNotifiedData(TestModel.innerEntryPath(1, "three"));
        listener2.waitForChangeEvents(new YangInstanceIdentifier[0]);
        listener2.verifyNotifiedData(TestModel.innerEntryPath(1, "three"));
    }

    private Map.Entry<MockDataTreeChangeListener, ActorSelection> registerChangeListener(YangInstanceIdentifier path, int expectedEvents) {
        RegisterDataTreeNotificationListenerReply reply;
        MockDataTreeChangeListener listener = new MockDataTreeChangeListener(expectedEvents);
        ActorRef dclActor = this.actorFactory.createActor(DataTreeChangeListenerActor.props((DOMDataTreeChangeListener)listener, (YangInstanceIdentifier)TestModel.TEST_PATH));
        try {
            reply = (RegisterDataTreeNotificationListenerReply)Await.result((Awaitable)Patterns.ask(this.shardActor, (Object)new RegisterDataTreeChangeListener(path, dclActor, false), (Timeout)new Timeout(5L, TimeUnit.SECONDS)), (Duration)FiniteDuration.create((long)5L, (TimeUnit)TimeUnit.SECONDS));
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return new AbstractMap.SimpleEntry<MockDataTreeChangeListener, ActorSelection>(listener, DataTreeChangeListenerSupportTest.getSystem().actorSelection(reply.getListenerRegistrationPath()));
    }

    private void createShard() {
        this.shardActor = this.actorFactory.createTestActor(this.newShardProps());
        ShardTestKit.waitUntilLeader(this.shardActor);
        this.shard = (Shard)this.shardActor.underlyingActor();
    }
}

