/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import akka.actor.ActorSystem;
import akka.actor.Address;
import akka.actor.AddressFromURIString;
import akka.cluster.Cluster;
import akka.testkit.javadsl.TestKit;
import com.google.common.base.Throwables;
import com.google.common.util.concurrent.FluentFuture;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.opendaylight.controller.cluster.datastore.AbstractDataStore;
import org.opendaylight.controller.cluster.datastore.DatastoreContext;
import org.opendaylight.controller.cluster.datastore.DistributedDataStore;
import org.opendaylight.controller.cluster.datastore.IntegrationTestKit;
import org.opendaylight.controller.md.cluster.datastore.model.CarsModel;
import org.opendaylight.controller.md.cluster.datastore.model.TestModel;
import org.opendaylight.mdsal.common.api.DataValidationFailedException;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.common.api.PostCanCommitStep;
import org.opendaylight.mdsal.common.api.PostPreCommitStep;
import org.opendaylight.mdsal.common.api.ThreePhaseCommitStep;
import org.opendaylight.mdsal.dom.api.DOMDataTreeCandidate;
import org.opendaylight.mdsal.dom.api.DOMDataTreeCommitCohort;
import org.opendaylight.mdsal.dom.api.DOMDataTreeCommitCohortRegistration;
import org.opendaylight.mdsal.dom.api.DOMDataTreeIdentifier;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreThreePhaseCommitCohort;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreWriteTransaction;
import org.opendaylight.yangtools.concepts.Path;
import org.opendaylight.yangtools.util.concurrent.FluentFutures;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.Uint64;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.MapEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.ModificationType;
import org.opendaylight.yangtools.yang.data.impl.schema.ImmutableNodes;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;

public class DataTreeCohortIntegrationTest {
    private static final DataValidationFailedException FAILED_CAN_COMMIT = new DataValidationFailedException(YangInstanceIdentifier.class, (Path)TestModel.TEST_PATH, "Test failure.");
    private static final FluentFuture<PostCanCommitStep> FAILED_CAN_COMMIT_FUTURE = FluentFutures.immediateFailedFluentFuture((Throwable)FAILED_CAN_COMMIT);
    private static final DOMDataTreeIdentifier TEST_ID = new DOMDataTreeIdentifier(LogicalDatastoreType.CONFIGURATION, TestModel.TEST_PATH);
    private static ActorSystem system;
    private final DatastoreContext.Builder datastoreContextBuilder = DatastoreContext.newBuilder().shardHeartbeatIntervalInMillis(100);

    @BeforeClass
    public static void setUpClass() {
        system = ActorSystem.create((String)"cluster-test", (Config)ConfigFactory.load().getConfig("Member1"));
        Address member1Address = AddressFromURIString.parse((String)"akka://cluster-test@127.0.0.1:2558");
        Cluster.get((ActorSystem)system).join(member1Address);
    }

    @AfterClass
    public static void tearDownClass() {
        TestKit.shutdownActorSystem((ActorSystem)system);
        system = null;
    }

    protected ActorSystem getSystem() {
        return system;
    }

    @Test
    public void testSuccessfulCanCommitWithNoopPostStep() throws Exception {
        DOMDataTreeCommitCohort cohort = (DOMDataTreeCommitCohort)Mockito.mock(DOMDataTreeCommitCohort.class);
        ((DOMDataTreeCommitCohort)Mockito.doReturn((Object)PostCanCommitStep.NOOP_SUCCESSFUL_FUTURE).when((Object)cohort)).canCommit(ArgumentMatchers.any(Object.class), (SchemaContext)ArgumentMatchers.any(SchemaContext.class), (Collection)ArgumentMatchers.any(Collection.class));
        ArgumentCaptor candidateCapt = ArgumentCaptor.forClass(Collection.class);
        IntegrationTestKit kit = new IntegrationTestKit(this.getSystem(), this.datastoreContextBuilder);
        try (AbstractDataStore dataStore = kit.setupAbstractDataStore(DistributedDataStore.class, "testSuccessfulCanCommitWithNoopPostStep", "test-1");){
            DOMDataTreeCommitCohortRegistration cohortReg = dataStore.registerCommitCohort(TEST_ID, cohort);
            Assert.assertNotNull((Object)cohortReg);
            IntegrationTestKit.verifyShardState(dataStore, "test-1", state -> Assert.assertEquals((String)"Cohort registrations", (long)1L, (long)state.getCommitCohortActors().size()));
            ContainerNode node = ImmutableNodes.containerNode((QName)TestModel.TEST_QNAME);
            kit.testWriteTransaction(dataStore, TestModel.TEST_PATH, (NormalizedNode<?, ?>)node);
            ((DOMDataTreeCommitCohort)Mockito.verify((Object)cohort)).canCommit(ArgumentMatchers.any(Object.class), (SchemaContext)ArgumentMatchers.any(SchemaContext.class), (Collection)candidateCapt.capture());
            DataTreeCohortIntegrationTest.assertDataTreeCandidate((DOMDataTreeCandidate)((Collection)candidateCapt.getValue()).iterator().next(), TEST_ID, ModificationType.WRITE, Optional.of(node), Optional.empty());
            Mockito.reset((Object[])new DOMDataTreeCommitCohort[]{cohort});
            ((DOMDataTreeCommitCohort)Mockito.doReturn((Object)PostCanCommitStep.NOOP_SUCCESSFUL_FUTURE).when((Object)cohort)).canCommit(ArgumentMatchers.any(Object.class), (SchemaContext)ArgumentMatchers.any(SchemaContext.class), (Collection)ArgumentMatchers.any(Collection.class));
            kit.testWriteTransaction(dataStore, TestModel.OUTER_LIST_PATH, ImmutableNodes.mapNodeBuilder((QName)TestModel.OUTER_LIST_QNAME).withChild((NormalizedNode)ImmutableNodes.mapEntry((QName)TestModel.OUTER_LIST_QNAME, (QName)TestModel.ID_QNAME, (Object)42)).build());
            ((DOMDataTreeCommitCohort)Mockito.verify((Object)cohort)).canCommit(ArgumentMatchers.any(Object.class), (SchemaContext)ArgumentMatchers.any(SchemaContext.class), (Collection)ArgumentMatchers.any(Collection.class));
            cohortReg.close();
            IntegrationTestKit.verifyShardState(dataStore, "test-1", state -> Assert.assertEquals((String)"Cohort registrations", (long)0L, (long)state.getCommitCohortActors().size()));
            kit.testWriteTransaction(dataStore, TestModel.TEST_PATH, (NormalizedNode<?, ?>)node);
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{cohort});
        }
    }

    @Test
    public void testFailedCanCommit() throws Exception {
        DOMDataTreeCommitCohort failedCohort = (DOMDataTreeCommitCohort)Mockito.mock(DOMDataTreeCommitCohort.class);
        ((DOMDataTreeCommitCohort)Mockito.doReturn(FAILED_CAN_COMMIT_FUTURE).when((Object)failedCohort)).canCommit(ArgumentMatchers.any(Object.class), (SchemaContext)ArgumentMatchers.any(SchemaContext.class), (Collection)ArgumentMatchers.any(Collection.class));
        IntegrationTestKit kit = new IntegrationTestKit(this.getSystem(), this.datastoreContextBuilder);
        try (AbstractDataStore dataStore = kit.setupAbstractDataStore(DistributedDataStore.class, "testFailedCanCommit", "test-1");){
            dataStore.registerCommitCohort(TEST_ID, failedCohort);
            IntegrationTestKit.verifyShardState(dataStore, "test-1", state -> Assert.assertEquals((String)"Cohort registrations", (long)1L, (long)state.getCommitCohortActors().size()));
            DOMStoreWriteTransaction writeTx = dataStore.newWriteOnlyTransaction();
            writeTx.write(TestModel.TEST_PATH, (NormalizedNode)ImmutableNodes.containerNode((QName)TestModel.TEST_QNAME));
            DOMStoreThreePhaseCommitCohort dsCohort = writeTx.ready();
            try {
                dsCohort.canCommit().get(5L, TimeUnit.SECONDS);
                Assert.fail((String)"Exception should be raised.");
            }
            catch (ExecutionException e) {
                Assert.assertSame((Object)FAILED_CAN_COMMIT, (Object)Throwables.getRootCause((Throwable)e));
            }
        }
    }

    @Test
    public void testCanCommitWithListEntries() throws Exception {
        DOMDataTreeCommitCohort cohort = (DOMDataTreeCommitCohort)Mockito.mock(DOMDataTreeCommitCohort.class);
        ((DOMDataTreeCommitCohort)Mockito.doReturn((Object)PostCanCommitStep.NOOP_SUCCESSFUL_FUTURE).when((Object)cohort)).canCommit(ArgumentMatchers.any(Object.class), (SchemaContext)ArgumentMatchers.any(SchemaContext.class), (Collection)ArgumentMatchers.any(Collection.class));
        IntegrationTestKit kit = new IntegrationTestKit(this.getSystem(), this.datastoreContextBuilder);
        try (AbstractDataStore dataStore = kit.setupAbstractDataStore(DistributedDataStore.class, "testCanCommitWithMultipleListEntries", "cars-1");){
            DOMDataTreeCommitCohortRegistration cohortReg = dataStore.registerCommitCohort(new DOMDataTreeIdentifier(LogicalDatastoreType.CONFIGURATION, CarsModel.CAR_LIST_PATH.node(CarsModel.CAR_QNAME)), cohort);
            Assert.assertNotNull((Object)cohortReg);
            IntegrationTestKit.verifyShardState(dataStore, "cars-1", state -> Assert.assertEquals((String)"Cohort registrations", (long)1L, (long)state.getCommitCohortActors().size()));
            DOMStoreWriteTransaction writeTx = dataStore.newWriteOnlyTransaction();
            writeTx.write(CarsModel.BASE_PATH, CarsModel.emptyContainer());
            writeTx.write(CarsModel.CAR_LIST_PATH, CarsModel.newCarMapNode());
            kit.doCommit(writeTx.ready());
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{cohort});
            writeTx = dataStore.newWriteOnlyTransaction();
            YangInstanceIdentifier optimaPath = CarsModel.newCarPath("optima");
            MapEntryNode optimaNode = CarsModel.newCarEntry("optima", Uint64.valueOf((int)20000));
            writeTx.write(optimaPath, (NormalizedNode)optimaNode);
            kit.doCommit(writeTx.ready());
            ArgumentCaptor candidateCapture = ArgumentCaptor.forClass(Collection.class);
            ((DOMDataTreeCommitCohort)Mockito.verify((Object)cohort)).canCommit(ArgumentMatchers.any(Object.class), (SchemaContext)ArgumentMatchers.any(SchemaContext.class), (Collection)candidateCapture.capture());
            DataTreeCohortIntegrationTest.assertDataTreeCandidate((DOMDataTreeCandidate)((Collection)candidateCapture.getValue()).iterator().next(), new DOMDataTreeIdentifier(LogicalDatastoreType.CONFIGURATION, optimaPath), ModificationType.WRITE, Optional.of(optimaNode), Optional.empty());
            Mockito.reset((Object[])new DOMDataTreeCommitCohort[]{cohort});
            ((DOMDataTreeCommitCohort)Mockito.doReturn((Object)PostCanCommitStep.NOOP_SUCCESSFUL_FUTURE).when((Object)cohort)).canCommit(ArgumentMatchers.any(Object.class), (SchemaContext)ArgumentMatchers.any(SchemaContext.class), (Collection)ArgumentMatchers.any(Collection.class));
            writeTx = dataStore.newWriteOnlyTransaction();
            YangInstanceIdentifier sportagePath = CarsModel.newCarPath("sportage");
            MapEntryNode sportageNode = CarsModel.newCarEntry("sportage", Uint64.valueOf((int)20000));
            YangInstanceIdentifier soulPath = CarsModel.newCarPath("soul");
            MapEntryNode soulNode = CarsModel.newCarEntry("soul", Uint64.valueOf((int)20000));
            writeTx.write(CarsModel.BASE_PATH, (NormalizedNode)CarsModel.newCarsNode(CarsModel.newCarsMapNode(sportageNode, soulNode)));
            kit.doCommit(writeTx.ready());
            candidateCapture = ArgumentCaptor.forClass(Collection.class);
            ((DOMDataTreeCommitCohort)Mockito.verify((Object)cohort)).canCommit(ArgumentMatchers.any(Object.class), (SchemaContext)ArgumentMatchers.any(SchemaContext.class), (Collection)candidateCapture.capture());
            DataTreeCohortIntegrationTest.assertDataTreeCandidate(DataTreeCohortIntegrationTest.findCandidate((ArgumentCaptor<Collection>)candidateCapture, sportagePath), new DOMDataTreeIdentifier(LogicalDatastoreType.CONFIGURATION, sportagePath), ModificationType.WRITE, Optional.of(sportageNode), Optional.empty());
            DataTreeCohortIntegrationTest.assertDataTreeCandidate(DataTreeCohortIntegrationTest.findCandidate((ArgumentCaptor<Collection>)candidateCapture, soulPath), new DOMDataTreeIdentifier(LogicalDatastoreType.CONFIGURATION, soulPath), ModificationType.WRITE, Optional.of(soulNode), Optional.empty());
            DataTreeCohortIntegrationTest.assertDataTreeCandidate(DataTreeCohortIntegrationTest.findCandidate((ArgumentCaptor<Collection>)candidateCapture, optimaPath), new DOMDataTreeIdentifier(LogicalDatastoreType.CONFIGURATION, optimaPath), ModificationType.DELETE, Optional.empty(), Optional.of(optimaNode));
            Mockito.reset((Object[])new DOMDataTreeCommitCohort[]{cohort});
            ((DOMDataTreeCommitCohort)Mockito.doReturn((Object)PostCanCommitStep.NOOP_SUCCESSFUL_FUTURE).when((Object)cohort)).canCommit(ArgumentMatchers.any(Object.class), (SchemaContext)ArgumentMatchers.any(SchemaContext.class), (Collection)ArgumentMatchers.any(Collection.class));
            writeTx = dataStore.newWriteOnlyTransaction();
            writeTx.delete(CarsModel.BASE_PATH);
            kit.doCommit(writeTx.ready());
            candidateCapture = ArgumentCaptor.forClass(Collection.class);
            ((DOMDataTreeCommitCohort)Mockito.verify((Object)cohort)).canCommit(ArgumentMatchers.any(Object.class), (SchemaContext)ArgumentMatchers.any(SchemaContext.class), (Collection)candidateCapture.capture());
            DataTreeCohortIntegrationTest.assertDataTreeCandidate(DataTreeCohortIntegrationTest.findCandidate((ArgumentCaptor<Collection>)candidateCapture, sportagePath), new DOMDataTreeIdentifier(LogicalDatastoreType.CONFIGURATION, sportagePath), ModificationType.DELETE, Optional.empty(), Optional.of(sportageNode));
            DataTreeCohortIntegrationTest.assertDataTreeCandidate(DataTreeCohortIntegrationTest.findCandidate((ArgumentCaptor<Collection>)candidateCapture, soulPath), new DOMDataTreeIdentifier(LogicalDatastoreType.CONFIGURATION, soulPath), ModificationType.DELETE, Optional.empty(), Optional.of(soulNode));
        }
    }

    private static DOMDataTreeCandidate findCandidate(ArgumentCaptor<Collection> candidateCapture, YangInstanceIdentifier rootPath) {
        for (Object obj : (Collection)candidateCapture.getValue()) {
            DOMDataTreeCandidate candidate = (DOMDataTreeCandidate)obj;
            if (!rootPath.equals((Object)candidate.getRootPath().getRootIdentifier())) continue;
            return candidate;
        }
        return null;
    }

    @Test
    @Ignore
    public void testAbortAfterCanCommit() throws Exception {
        DOMDataTreeCommitCohort cohortToAbort = (DOMDataTreeCommitCohort)Mockito.mock(DOMDataTreeCommitCohort.class);
        PostCanCommitStep stepToAbort = (PostCanCommitStep)Mockito.mock(PostCanCommitStep.class);
        ((PostCanCommitStep)Mockito.doReturn((Object)ThreePhaseCommitStep.NOOP_ABORT_FUTURE).when((Object)stepToAbort)).abort();
        ((PostCanCommitStep)Mockito.doReturn((Object)PostPreCommitStep.NOOP_FUTURE).when((Object)stepToAbort)).preCommit();
        ((DOMDataTreeCommitCohort)Mockito.doReturn((Object)FluentFutures.immediateFluentFuture((Object)stepToAbort)).when((Object)cohortToAbort)).canCommit(ArgumentMatchers.any(Object.class), (SchemaContext)ArgumentMatchers.any(SchemaContext.class), (Collection)ArgumentMatchers.any(Collection.class));
        IntegrationTestKit kit = new IntegrationTestKit(this.getSystem(), this.datastoreContextBuilder);
        try (AbstractDataStore dataStore = kit.setupAbstractDataStore(DistributedDataStore.class, "testAbortAfterCanCommit", "test-1", "cars-1");){
            dataStore.registerCommitCohort(TEST_ID, cohortToAbort);
            IntegrationTestKit.verifyShardState(dataStore, "test-1", state -> Assert.assertEquals((String)"Cohort registrations", (long)1L, (long)state.getCommitCohortActors().size()));
            DOMStoreWriteTransaction writeTx = dataStore.newWriteOnlyTransaction();
            writeTx.write(TestModel.TEST_PATH, (NormalizedNode)ImmutableNodes.containerNode((QName)TestModel.TEST_QNAME));
            writeTx.write(CarsModel.BASE_PATH, CarsModel.emptyContainer());
            DOMStoreThreePhaseCommitCohort dsCohort = writeTx.ready();
            dsCohort.canCommit().get(5L, TimeUnit.SECONDS);
            dsCohort.preCommit().get(5L, TimeUnit.SECONDS);
            dsCohort.abort().get(5L, TimeUnit.SECONDS);
            ((PostCanCommitStep)Mockito.verify((Object)stepToAbort)).abort();
        }
    }

    private static void assertDataTreeCandidate(DOMDataTreeCandidate candidate, DOMDataTreeIdentifier expTreeId, ModificationType expType, Optional<NormalizedNode<?, ?>> expDataAfter, Optional<NormalizedNode<?, ?>> expDataBefore) {
        Assert.assertNotNull((String)("Expected candidate for path " + expTreeId.getRootIdentifier()), (Object)candidate);
        Assert.assertEquals((String)"rootPath", (Object)expTreeId, (Object)candidate.getRootPath());
        Assert.assertEquals((String)"modificationType", (Object)expType, (Object)candidate.getRootNode().getModificationType());
        Assert.assertEquals((String)"dataAfter present", (Object)expDataAfter.isPresent(), (Object)candidate.getRootNode().getDataAfter().isPresent());
        if (expDataAfter.isPresent()) {
            Assert.assertEquals((String)"dataAfter", expDataAfter.get(), candidate.getRootNode().getDataAfter().get());
        }
        Assert.assertEquals((String)"dataBefore present", (Object)expDataBefore.isPresent(), (Object)candidate.getRootNode().getDataBefore().isPresent());
        if (expDataBefore.isPresent()) {
            Assert.assertEquals((String)"dataBefore", expDataBefore.get(), candidate.getRootNode().getDataBefore().get());
        }
    }
}

