/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import java.util.HashMap;
import org.junit.Assert;
import org.junit.Test;
import org.opendaylight.controller.cluster.datastore.AbstractDatastoreContextIntrospectorFactory;
import org.opendaylight.controller.cluster.datastore.DatastoreContext;
import org.opendaylight.controller.cluster.datastore.DatastoreContextIntrospector;
import org.opendaylight.controller.cluster.datastore.DefaultDatastoreContextIntrospectorFactory;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingNormalizedNodeSerializer;
import org.opendaylight.mdsal.binding.dom.codec.impl.BindingCodecContext;
import org.opendaylight.mdsal.binding.runtime.spi.BindingRuntimeHelpers;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.DataStorePropertiesContainer;

public class DatastoreContextIntrospectorTest {
    static final AbstractDatastoreContextIntrospectorFactory INTROSPECTOR_FACTORY = new DefaultDatastoreContextIntrospectorFactory((BindingNormalizedNodeSerializer)new BindingCodecContext(BindingRuntimeHelpers.createRuntimeContext((Class[])new Class[]{DataStorePropertiesContainer.class})));

    @Test
    public void testYangDefaults() {
        DatastoreContextIntrospector introspector = INTROSPECTOR_FACTORY.newInstance(DatastoreContext.newBuilder().shardBatchedModificationCount(2).transactionDebugContextEnabled(true).build());
        DatastoreContext context = introspector.getContext();
        Assert.assertEquals((long)1000L, (long)context.getShardBatchedModificationCount());
        Assert.assertFalse((boolean)context.isTransactionDebugContextEnabled());
    }

    @Test
    public void testUpdate() {
        DatastoreContextIntrospector introspector = INTROSPECTOR_FACTORY.newInstance(LogicalDatastoreType.OPERATIONAL);
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("shard-transaction-idle-timeout-in-minutes", "31");
        properties.put("operation-timeout-in-seconds", "26");
        properties.put("shard-transaction-commit-timeout-in-seconds", "100");
        properties.put("shard-journal-recovery-log-batch-size", "199");
        properties.put("shard-snapshot-batch-count", "212");
        properties.put("shard-heartbeat-interval-in-millis", "101");
        properties.put("shard-transaction-commit-queue-capacity", "567");
        properties.put("shard-initialization-timeout-in-seconds", "82");
        properties.put("shard-leader-election-timeout-in-seconds", "66");
        properties.put("initial-settle-timeout-multiplier", "5");
        properties.put("recovery-snapshot-interval-seconds", "360");
        properties.put("shard-isolated-leader-check-interval-in-millis", "123");
        properties.put("shard-snapshot-data-threshold-percentage", "100");
        properties.put("shard-snapshot-data-threshold", "800");
        properties.put("shard-election-timeout-factor", "21");
        properties.put("shard-batched-modification-count", "901");
        properties.put("transactionCreationInitialRateLimit", "200");
        properties.put("MaxShardDataChangeExecutorPoolSize", "41");
        properties.put("Max-Shard-Data-Change Executor-Queue Size", "1111");
        properties.put(" max shard data change listener queue size", "2222");
        properties.put("mAx-shaRd-data-STORE-executor-quEUe-size", "3333");
        properties.put("persistent", "false");
        properties.put("initial-payload-serialized-buffer-capacity", "600");
        boolean updated = introspector.update(properties);
        Assert.assertTrue((String)"updated", (boolean)updated);
        DatastoreContext context = introspector.getContext();
        Assert.assertEquals((long)31L, (long)context.getShardTransactionIdleTimeout().toMinutes());
        Assert.assertEquals((long)26000L, (long)context.getOperationTimeoutInMillis());
        Assert.assertEquals((long)100L, (long)context.getShardTransactionCommitTimeoutInSeconds());
        Assert.assertEquals((long)199L, (long)context.getShardRaftConfig().getJournalRecoveryLogBatchSize());
        Assert.assertEquals((long)212L, (long)context.getShardRaftConfig().getSnapshotBatchCount());
        Assert.assertEquals((long)101L, (long)context.getShardRaftConfig().getHeartBeatInterval().length());
        Assert.assertEquals((long)567L, (long)context.getShardTransactionCommitQueueCapacity());
        Assert.assertEquals((long)82L, (long)context.getShardInitializationTimeout().duration().toSeconds());
        Assert.assertEquals((long)66L, (long)context.getShardLeaderElectionTimeout().duration().toSeconds());
        Assert.assertEquals((long)5L, (long)context.getInitialSettleTimeoutMultiplier());
        Assert.assertEquals((long)360L, (long)context.getShardRaftConfig().getRecoverySnapshotIntervalSeconds());
        Assert.assertEquals((long)123L, (long)context.getShardRaftConfig().getIsolatedCheckIntervalInMillis());
        Assert.assertEquals((long)100L, (long)context.getShardRaftConfig().getSnapshotDataThresholdPercentage());
        Assert.assertEquals((long)800L, (long)context.getShardRaftConfig().getSnapshotDataThreshold());
        Assert.assertEquals((long)21L, (long)context.getShardRaftConfig().getElectionTimeoutFactor());
        Assert.assertEquals((long)901L, (long)context.getShardBatchedModificationCount());
        Assert.assertEquals((long)200L, (long)context.getTransactionCreationInitialRateLimit());
        Assert.assertEquals((long)600L, (long)context.getInitialPayloadSerializedBufferCapacity());
        Assert.assertFalse((boolean)context.isPersistent());
        properties.put("shard-transaction-idle-timeout-in-minutes", "32");
        properties.put("operation-timeout-in-seconds", "27");
        properties.put("shard-heartbeat-interval-in-millis", "102");
        properties.put("shard-election-timeout-factor", "22");
        properties.put("initial-settle-timeout-multiplier", "6");
        properties.put("max-shard-data-change-executor-pool-size", "42");
        properties.put("max-shard-data-store-executor-queue-size", "4444");
        properties.put("persistent", "true");
        updated = introspector.update(properties);
        Assert.assertTrue((String)"updated", (boolean)updated);
        context = introspector.getContext();
        Assert.assertEquals((long)32L, (long)context.getShardTransactionIdleTimeout().toMinutes());
        Assert.assertEquals((long)27000L, (long)context.getOperationTimeoutInMillis());
        Assert.assertEquals((long)100L, (long)context.getShardTransactionCommitTimeoutInSeconds());
        Assert.assertEquals((long)199L, (long)context.getShardRaftConfig().getJournalRecoveryLogBatchSize());
        Assert.assertEquals((long)212L, (long)context.getShardRaftConfig().getSnapshotBatchCount());
        Assert.assertEquals((long)102L, (long)context.getShardRaftConfig().getHeartBeatInterval().length());
        Assert.assertEquals((long)567L, (long)context.getShardTransactionCommitQueueCapacity());
        Assert.assertEquals((long)82L, (long)context.getShardInitializationTimeout().duration().toSeconds());
        Assert.assertEquals((long)66L, (long)context.getShardLeaderElectionTimeout().duration().toSeconds());
        Assert.assertEquals((long)6L, (long)context.getInitialSettleTimeoutMultiplier());
        Assert.assertEquals((long)123L, (long)context.getShardRaftConfig().getIsolatedCheckIntervalInMillis());
        Assert.assertEquals((long)100L, (long)context.getShardRaftConfig().getSnapshotDataThresholdPercentage());
        Assert.assertEquals((long)800L, (long)context.getShardRaftConfig().getSnapshotDataThreshold());
        Assert.assertEquals((long)22L, (long)context.getShardRaftConfig().getElectionTimeoutFactor());
        Assert.assertEquals((long)200L, (long)context.getTransactionCreationInitialRateLimit());
        Assert.assertTrue((boolean)context.isPersistent());
        updated = introspector.update(null);
        Assert.assertFalse((String)"updated", (boolean)updated);
        updated = introspector.update(new HashMap());
        Assert.assertFalse((String)"updated", (boolean)updated);
    }

    @Test
    public void testUpdateWithInvalidValues() {
        DatastoreContextIntrospector introspector = INTROSPECTOR_FACTORY.newInstance(LogicalDatastoreType.OPERATIONAL);
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("shard-transaction-idle-timeout-in-minutes", "0");
        properties.put("shard-journal-recovery-log-batch-size", "199");
        properties.put("shard-transaction-commit-timeout-in-seconds", "bogus");
        properties.put("shard-snapshot-batch-count", "212");
        properties.put("operation-timeout-in-seconds", "4");
        properties.put("shard-heartbeat-interval-in-millis", "99");
        properties.put("shard-transaction-commit-queue-capacity", "567");
        properties.put("shard-snapshot-data-threshold-percentage", "101");
        properties.put("shard-snapshot-data-threshold", "-1");
        properties.put("shard-initialization-timeout-in-seconds", "-1");
        properties.put("max-shard-data-change-executor-pool-size", "bogus");
        properties.put("unknownProperty", "1");
        boolean updated = introspector.update(properties);
        Assert.assertTrue((String)"updated", (boolean)updated);
        DatastoreContext context = introspector.getContext();
        Assert.assertEquals((Object)DatastoreContext.DEFAULT_SHARD_TRANSACTION_IDLE_TIMEOUT, (Object)context.getShardTransactionIdleTimeout());
        Assert.assertEquals((long)199L, (long)context.getShardRaftConfig().getJournalRecoveryLogBatchSize());
        Assert.assertEquals((long)30L, (long)context.getShardTransactionCommitTimeoutInSeconds());
        Assert.assertEquals((long)212L, (long)context.getShardRaftConfig().getSnapshotBatchCount());
        Assert.assertEquals((long)5000L, (long)context.getOperationTimeoutInMillis());
        Assert.assertEquals((long)500L, (long)context.getShardRaftConfig().getHeartBeatInterval().length());
        Assert.assertEquals((long)567L, (long)context.getShardTransactionCommitQueueCapacity());
        Assert.assertEquals((long)12L, (long)context.getShardRaftConfig().getSnapshotDataThresholdPercentage());
        Assert.assertEquals((long)0L, (long)context.getShardRaftConfig().getSnapshotDataThreshold());
        Assert.assertEquals((Object)DatastoreContext.DEFAULT_SHARD_INITIALIZATION_TIMEOUT, (Object)context.getShardInitializationTimeout());
    }

    @Test
    public void testUpdateWithDatastoreTypeSpecificProperties() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("shard-transaction-idle-timeout-in-minutes", "22");
        properties.put("operational.shard-transaction-idle-timeout-in-minutes", "33");
        properties.put("config.shard-transaction-idle-timeout-in-minutes", "44");
        properties.put("max-shard-data-change-executor-pool-size", "222");
        properties.put("operational.max-shard-data-change-executor-pool-size", "333");
        properties.put("config.max-shard-data-change-executor-pool-size", "444");
        properties.put("persistent", "false");
        properties.put("operational.Persistent", "true");
        DatastoreContextIntrospector operIntrospector = INTROSPECTOR_FACTORY.newInstance(LogicalDatastoreType.OPERATIONAL);
        boolean updated = operIntrospector.update(properties);
        Assert.assertTrue((String)"updated", (boolean)updated);
        DatastoreContext operContext = operIntrospector.getContext();
        Assert.assertEquals((long)33L, (long)operContext.getShardTransactionIdleTimeout().toMinutes());
        Assert.assertTrue((boolean)operContext.isPersistent());
        DatastoreContextIntrospector configIntrospector = INTROSPECTOR_FACTORY.newInstance(LogicalDatastoreType.CONFIGURATION);
        updated = configIntrospector.update(properties);
        Assert.assertTrue((String)"updated", (boolean)updated);
        DatastoreContext configContext = configIntrospector.getContext();
        Assert.assertEquals((long)44L, (long)configContext.getShardTransactionIdleTimeout().toMinutes());
        Assert.assertFalse((boolean)configContext.isPersistent());
    }

    @Test
    public void testGetDatastoreContextForShard() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("shard-transaction-idle-timeout-in-minutes", "22");
        properties.put("operational.shard-transaction-idle-timeout-in-minutes", "33");
        properties.put("config.shard-transaction-idle-timeout-in-minutes", "44");
        properties.put("topology.shard-transaction-idle-timeout-in-minutes", "55");
        properties.put("config.topology.persistent", "false");
        DatastoreContextIntrospector operIntrospector = INTROSPECTOR_FACTORY.newInstance(LogicalDatastoreType.OPERATIONAL);
        DatastoreContext shardContext = operIntrospector.newContextFactory().getShardDatastoreContext("topology");
        Assert.assertEquals((long)10L, (long)shardContext.getShardTransactionIdleTimeout().toMinutes());
        operIntrospector.update(properties);
        DatastoreContext operContext = operIntrospector.getContext();
        Assert.assertEquals((long)33L, (long)operContext.getShardTransactionIdleTimeout().toMinutes());
        shardContext = operIntrospector.newContextFactory().getShardDatastoreContext("topology");
        Assert.assertEquals((long)55L, (long)shardContext.getShardTransactionIdleTimeout().toMinutes());
        DatastoreContextIntrospector configIntrospector = INTROSPECTOR_FACTORY.newInstance(LogicalDatastoreType.CONFIGURATION);
        configIntrospector.update(properties);
        DatastoreContext configContext = configIntrospector.getContext();
        Assert.assertEquals((long)44L, (long)configContext.getShardTransactionIdleTimeout().toMinutes());
        shardContext = configIntrospector.newContextFactory().getShardDatastoreContext("topology");
        Assert.assertEquals((long)55L, (long)shardContext.getShardTransactionIdleTimeout().toMinutes());
        Assert.assertFalse((boolean)shardContext.isPersistent());
        properties.put("operational.topology.shard-transaction-idle-timeout-in-minutes", "66");
        properties.put("config.topology.shard-transaction-idle-timeout-in-minutes", "77");
        operIntrospector.update(properties);
        shardContext = operIntrospector.newContextFactory().getShardDatastoreContext("topology");
        Assert.assertEquals((long)66L, (long)shardContext.getShardTransactionIdleTimeout().toMinutes());
        configIntrospector.update(properties);
        shardContext = configIntrospector.newContextFactory().getShardDatastoreContext("topology");
        Assert.assertEquals((long)77L, (long)shardContext.getShardTransactionIdleTimeout().toMinutes());
        shardContext = configIntrospector.newContextFactory().getShardDatastoreContext("default");
        Assert.assertEquals((long)44L, (long)shardContext.getShardTransactionIdleTimeout().toMinutes());
        Assert.assertTrue((boolean)shardContext.isPersistent());
    }
}

